/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.items.tools;

import de.comeight.crystallogy.items.tools.BaseItemPickaxe;
import de.comeight.crystallogy.util.ToolUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BaseCrystalPickaxe
extends BaseItemPickaxe {
    public BaseCrystalPickaxe(Item.ToolMaterial material, String id) {
        super(material, id);
        this.func_77656_e(this.func_77612_l() * 3);
    }

    public int getAOE() {
        return 3;
    }

    protected EnumFacing getDirectionPlayerIsFacing(World worldIn, EntityPlayer player) {
        RayTraceResult rTR = this.func_77621_a(worldIn, player, false);
        return rTR.field_178784_b.func_176734_d();
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!entityLiving.func_70093_af()) {
            this.breakBlocksArround(stack, worldIn, pos, entityLiving);
        } else if (state.func_185887_b(worldIn, pos) > 0.0f) {
            stack.func_77972_a(1, entityLiving);
        }
        return true;
    }

    protected void breakBlocksArround(ItemStack stack, World worldIn, BlockPos pos, EntityLivingBase entityLiving) {
        EnumFacing direction = this.getDirectionPlayerIsFacing(worldIn, (EntityPlayer)entityLiving);
        int aOE = this.getAOE();
        int aOEHalf = (int)Math.round((double)aOE / 2.0);
        switch (direction) {
            case DOWN: {
                pos = pos.func_177982_a(0, -aOEHalf, 0);
                break;
            }
            case UP: {
                pos = pos.func_177982_a(0, aOEHalf, 0);
                break;
            }
            case WEST: {
                pos = pos.func_177982_a(-aOEHalf, aOEHalf, 0);
                break;
            }
            case EAST: {
                pos = pos.func_177982_a(aOEHalf, aOEHalf, 0);
                break;
            }
            case NORTH: {
                pos = pos.func_177982_a(0, aOEHalf, -aOEHalf);
                break;
            }
            case SOUTH: {
                pos = pos.func_177982_a(0, aOEHalf, aOEHalf);
                break;
            }
        }
        for (int i = -aOE; i < aOE; ++i) {
            for (int j = -aOE; j < aOE; ++j) {
                for (int j2 = -aOE; j2 < aOE; ++j2) {
                    this.tryMineBlock(worldIn, pos.func_177982_a(i, j, j2), stack, entityLiving);
                }
            }
        }
    }

    protected void tryMineBlock(World worldIn, BlockPos pos, ItemStack stack, EntityLivingBase entityLiving) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (stack == null || stack.func_77952_i() >= stack.func_77958_k()) {
            stack.func_77972_a(1, entityLiving);
            return;
        }
        if (state.func_177230_c().getHarvestLevel(state) <= this.getHarvestLevel(stack, "pickaxe") && this.func_150897_b(state)) {
            if (block.func_149688_o(state) == Material.field_151579_a) {
                return;
            }
            ToolUtils.mineBlock(worldIn, worldIn.func_180495_p(pos), pos);
            if (state.func_185887_b(worldIn, pos) > 0.0f) {
                stack.func_77972_a(1, entityLiving);
            }
        }
    }
}

