/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.items.tools;

import de.comeight.crystallogy.CommonProxy;
import de.comeight.crystallogy.blocks.materials.CustomToolMaterials;
import de.comeight.crystallogy.items.tools.BaseItemSword;
import de.comeight.crystallogy.network.NetworkPacketParticle;
import de.comeight.crystallogy.network.NetworkParticle;
import de.comeight.crystallogy.particles.ParticleB;
import de.comeight.crystallogy.tileEntitys.TileEntityEntityJar;
import de.comeight.crystallogy.util.ToolTipBuilder;
import de.comeight.crystallogy.util.Utilities;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseCrystalKnife
extends BaseItemSword {
    private float attackDamage;

    public BaseCrystalKnife(String id) {
        super(CustomToolMaterials.CRYSTALLKNIF, id);
        this.canRepair = true;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.hasEntity(stack);
    }

    public boolean hasEntity(ItemStack stack) {
        NBTTagCompound c = stack.func_77978_p();
        return c != null && c.func_74779_i("name") != null && !c.func_74779_i("name").equals("-") && !c.func_74779_i("name").equals("");
    }

    protected EntityLivingBase getEntity(ItemStack stack, World worldIn) {
        NBTTagCompound compound = stack.func_77978_p();
        UUID uuid = UUID.fromString(compound.func_74779_i("uuid"));
        List list = worldIn.func_72910_y();
        for (Entity entity : list) {
            if (!uuid.equals(entity.func_110124_au())) continue;
            return (EntityLivingBase)entity;
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            itemStackIn = this.removeEntity(itemStackIn, worldIn, playerIn.func_174791_d(), true);
        } else if (!this.hasEntity(itemStackIn)) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                playerIn.func_71059_n((Entity)playerIn);
            }
            this.saveNBT(itemStackIn, (EntityLivingBase)playerIn);
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityEntityJar tE;
        if (this.hasEntity(stack) && worldIn.func_175625_s(pos) instanceof TileEntityEntityJar && !(tE = (TileEntityEntityJar)worldIn.func_175625_s(pos)).hasEntity()) {
            tE.setEntity(this.getEntity(stack, worldIn));
            stack = this.removeEntity(stack, worldIn, playerIn.func_174791_d(), false);
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(stack, playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.hasEntity(stack)) {
            this.removeEntity(stack, target.field_70170_p, attacker.func_174791_d(), true);
        }
        if (!(target instanceof EntityPlayer)) {
            stack = this.saveNBT(stack, target);
            super.func_77644_a(stack, target, attacker);
            return true;
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public float func_150931_i() {
        return this.attackDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound == null) {
            stack = this.saveEmptyNBT(stack);
            tooltip.add(TextFormatting.GOLD + "Name:" + TextFormatting.RESET + " -");
            tooltip.add(TextFormatting.GOLD + "UUID:" + TextFormatting.RESET + " -");
        } else {
            if (this.hasEntity(stack)) {
                tooltip.add("Has Entity: " + TextFormatting.DARK_GREEN + "Yes");
            } else {
                tooltip.add("Has Entity: " + TextFormatting.DARK_RED + "No");
            }
            if (GuiScreen.func_146272_n()) {
                tooltip.add("");
                tooltip.add(TextFormatting.GOLD + "Name: " + TextFormatting.RESET + nbtTagCompound.func_74779_i("name"));
                tooltip.add(TextFormatting.GOLD + "UUID: " + TextFormatting.RESET + nbtTagCompound.func_74779_i("uuid"));
            } else {
                ToolTipBuilder.addShiftForMoreDetails(tooltip);
            }
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public ItemStack saveNBT(ItemStack stack, EntityLivingBase entity) {
        stack = this.saveEmptyNBT(stack);
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        nbtTagCompound.func_74778_a("name", entity.func_70005_c_());
        nbtTagCompound.func_74778_a("uuid", entity.func_110124_au().toString());
        stack.func_77982_d(nbtTagCompound);
        return stack;
    }

    protected ItemStack saveEmptyNBT(ItemStack stack) {
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
        }
        nbtTagCompound.func_74778_a("name", "-");
        nbtTagCompound.func_74778_a("uuid", "-");
        stack.func_77982_d(nbtTagCompound);
        return stack;
    }

    protected ItemStack getItemStack() {
        return this.saveEmptyNBT(new ItemStack((Item)this));
    }

    protected ItemStack removeEntity(ItemStack stack, World worldIn, Vec3d pos, boolean release) {
        if (this.hasEntity(stack)) {
            stack = this.saveEmptyNBT(stack);
            if (release) {
                if (worldIn.field_72995_K) {
                    for (int i = 0; i < 5; ++i) {
                        ParticleB gP = new ParticleB(worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0);
                        gP.setParticleMaxAge(120);
                        gP.func_70538_b(Utilities.getRandFloat(0.0f, 100.0f), Utilities.getRandFloat(0.0f, 100.0f), Utilities.getRandFloat(0.0f, 100.0f));
                        NetworkParticle nP = new NetworkParticle(gP, gP.name);
                        nP.setSize(new Vec3d(1.0, 2.0, 1.0));
                        nP.setNumberOfParticle(30);
                        NetworkPacketParticle pMtS = new NetworkPacketParticle(nP);
                        CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)pMtS);
                    }
                }
                worldIn.func_72942_c((Entity)new EntityLightningBolt(worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, false));
                worldIn.func_184148_a((EntityPlayer)null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187533_aW, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                worldIn.func_184148_a((EntityPlayer)null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187532_aV, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                worldIn.func_184148_a((EntityPlayer)null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187855_gD, SoundCategory.NEUTRAL, 1.0f, 0.6f);
            }
        }
        return stack;
    }
}

