/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.items.crafting.infusion;

import de.comeight.crystallogy.CommonProxy;
import de.comeight.crystallogy.handler.InfusionRecipeHandler;
import de.comeight.crystallogy.network.NetworkPacketInfusionRecipeStatus;
import de.comeight.crystallogy.network.NetworkPacketParticle;
import de.comeight.crystallogy.network.NetworkPacketUpdateInventory;
import de.comeight.crystallogy.network.NetworkParticle;
import de.comeight.crystallogy.particles.ParticleNColor;
import de.comeight.crystallogy.tileEntitys.TileEnityInfuserBlock;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class InfusionRecipe {
    public final String id;
    protected final int totalCookTime;
    protected int curentCookTime;
    protected World worldIn;
    protected TileEnityInfuserBlock centerInput;
    protected TileEnityInfuserBlock[] ingredients;
    protected ItemStack output;
    protected boolean active;

    public InfusionRecipe(String id, int totalCookTime) {
        this.id = id;
        this.totalCookTime = totalCookTime;
        this.curentCookTime = 0;
        this.worldIn = null;
        this.centerInput = null;
        this.ingredients = null;
        this.output = null;
        this.active = false;
    }

    public int getTotalCookTime() {
        return this.totalCookTime;
    }

    public boolean isActive() {
        return this.active;
    }

    public ItemStack getRecipeOutput() {
        ItemStack iStack = this.output;
        this.output = null;
        return iStack;
    }

    public abstract InfusionRecipe getRecipe();

    protected void setTileEnityInfuserBlocks(BlockPos centerInputPos, BlockPos[] ingredientsPos, World worldIn) {
        TileEntity tE = worldIn.func_175625_s(centerInputPos);
        if (tE instanceof TileEnityInfuserBlock) {
            this.centerInput = (TileEnityInfuserBlock)tE;
        }
        ArrayList<TileEnityInfuserBlock> list = new ArrayList<TileEnityInfuserBlock>();
        for (int i = 0; i < ingredientsPos.length; ++i) {
            TileEnityInfuserBlock tEI;
            tE = worldIn.func_175625_s(ingredientsPos[i]);
            if (!(tE instanceof TileEnityInfuserBlock) || (tEI = (TileEnityInfuserBlock)tE).func_70301_a(0) == null) continue;
            list.add(tEI);
        }
        TileEnityInfuserBlock[] a = new TileEnityInfuserBlock[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            a[i] = (TileEnityInfuserBlock)((Object)list.get(i));
        }
        this.ingredients = a;
    }

    public BlockPos[] getActiveInfuserBlocks() {
        BlockPos[] positions = new BlockPos[this.ingredients.length];
        for (int i = 0; i < this.ingredients.length; ++i) {
            positions[i] = this.ingredients[i].func_174877_v();
        }
        return positions;
    }

    public abstract ArrayList<ArrayList<ItemStack>> getInputsJEI();

    public abstract ArrayList<ItemStack> getOutputJEI();

    public abstract boolean match(ItemStack var1, ItemStack[] var2);

    public void cook(BlockPos centerInputPos, BlockPos[] ingredientsPos, World worldIn) {
        if (this.output == null) {
            try {
                throw new Exception("Match recipe first!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.worldIn = worldIn;
            this.setTileEnityInfuserBlocks(centerInputPos, ingredientsPos, worldIn);
            this.startAnimationOnClients();
            this.active = true;
        }
    }

    public void tick() {
        if (!this.active) {
            return;
        }
        if (this.worldIn != null) {
            // empty if block
        }
        if (!this.stillActive()) {
            this.done(false);
        }
        if (!this.canIncCurentCookTime()) {
            this.done(true);
        }
    }

    protected boolean stillActive() {
        if (this.centerInput == null || this.centerInput.func_70301_a(0) == null) {
            return false;
        }
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i] != null && this.ingredients[i].func_70301_a(0) != null) continue;
            return false;
        }
        return true;
    }

    protected boolean canIncCurentCookTime() {
        ++this.curentCookTime;
        if (this.curentCookTime >= this.totalCookTime) {
            this.curentCookTime = 0;
            return false;
        }
        return true;
    }

    protected void done(boolean successfully) {
        if (successfully) {
            this.setCenterInputItem();
            this.removeIngredients();
        }
        this.stopAnimationOnClients(successfully);
        this.spawnParticlesOnClient(successfully);
        this.active = false;
    }

    protected void spawnParticlesOnClient(boolean successfully) {
        BlockPos pos = this.centerInput.func_174877_v();
        ParticleNColor particle = new ParticleNColor(this.worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.6, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
        NetworkParticle nP = new NetworkParticle(particle, "n_c");
        nP.setSize(new Vec3d(0.25, 2.0, 0.25));
        nP.setNumberOfParticle(30);
        NetworkPacketParticle pMtS = new NetworkPacketParticle(nP);
        CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)pMtS);
        if (!successfully) {
            for (int i = 0; i < this.ingredients.length; ++i) {
                pos = this.ingredients[i].func_174877_v();
                particle = new ParticleNColor(this.worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.6, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                nP = new NetworkParticle(particle, "n_c");
                nP.setSize(new Vec3d(0.25, 2.0, 0.25));
                nP.setNumberOfParticle(30);
                pMtS = new NetworkPacketParticle(nP);
                CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)pMtS);
            }
        }
    }

    protected void startAnimationOnClients() {
        NetworkPacketInfusionRecipeStatus packet = new NetworkPacketInfusionRecipeStatus(this.centerInput.func_174877_v(), true, InfusionRecipeHandler.getIndexOfRecipe(this), true);
        CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)packet);
    }

    protected void stopAnimationOnClients(boolean successfully) {
        NetworkPacketInfusionRecipeStatus packet = new NetworkPacketInfusionRecipeStatus(this.centerInput.func_174877_v(), false, -1, successfully);
        CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)packet);
    }

    protected void removeIngredients() {
        for (int i = 0; i < this.ingredients.length; ++i) {
            this.ingredients[i].func_70299_a(0, null);
            this.setItemOnClient(this.ingredients[i].func_174877_v(), null);
        }
    }

    protected void setCenterInputItem() {
        this.centerInput.func_70299_a(0, this.output);
        this.setItemOnClient(this.centerInput.func_174877_v(), this.output);
    }

    protected void setItemOnClient(BlockPos pos, ItemStack stack) {
        NetworkPacketUpdateInventory message = new NetworkPacketUpdateInventory(pos, stack, 0);
        CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)message);
    }

    protected boolean compare(ItemStack i1, ItemStack i2) {
        if (i1.func_77973_b() != i2.func_77973_b()) {
            return false;
        }
        return !i1.func_77973_b().func_77614_k() || i1.func_77973_b().getDamage(i1) == i2.func_77973_b().getDamage(i2);
    }
}

