/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.items.armor;

import de.comeight.crystallogy.blocks.materials.CustomArmorMaterials;
import de.comeight.crystallogy.handler.ItemHandler;
import de.comeight.crystallogy.items.armor.BaseArmor;
import de.comeight.crystallogy.util.ToolTipBuilder;
import de.comeight.crystallogy.util.Utilities;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class Armor_hunters
extends BaseArmor {
    private static final String ID = "armor_hunter_";

    public Armor_hunters(int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(CustomArmorMaterials.CRYSTALL_HUNTER, renderIndexIn, equipmentSlotIn, ID + equipmentSlotIn.func_188450_d());
    }

    @Override
    public String getID() {
        return ID + this.field_77881_a.func_188450_d();
    }

    public boolean isPlayerWearingFullArmor(EntityPlayer player) {
        return player.field_71071_by.func_70440_f(3) != null && player.field_71071_by.func_70440_f(3).func_77973_b() == ItemHandler.armorHelmet_hunter && player.field_71071_by.func_70440_f(2) != null && player.field_71071_by.func_70440_f(2).func_77973_b() == ItemHandler.armorChestplate_hunter && player.field_71071_by.func_70440_f(1) != null && player.field_71071_by.func_70440_f(1).func_77973_b() == ItemHandler.armorLeggins_hunter && player.field_71071_by.func_70440_f(0) != null && player.field_71071_by.func_70440_f(0).func_77973_b() == ItemHandler.armorBoots_hunter;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        int index = -1;
        if (!this.isPlayerWearingFullArmor(player) || (index = this.hasEnergyCrystal(player)) == -1) {
            this.disableCapabilities(world, player);
        } else if (itemStack.func_77973_b() == ItemHandler.armorChestplate_hunter) {
            this.enableCapabilities(world, player);
            if (!world.field_72995_K) {
                if (player.field_71075_bZ.field_75100_b) {
                    this.damageEnergyCrystal(player, index);
                } else if (Utilities.getRandInt(0, 5) == 0) {
                    this.damageEnergyCrystal(player, index);
                }
            }
        }
    }

    private void enableCapabilities(World world, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71075_bZ.field_75101_c = true;
            player.field_71075_bZ.field_75102_a = true;
        }
        if (!world.field_72995_K) {
            player.field_71075_bZ.func_82877_b(0.12f);
            player.field_71075_bZ.func_75092_a(0.06f);
        }
    }

    private void disableCapabilities(World world, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            player.field_71075_bZ.field_75102_a = false;
        }
        if (!world.field_72995_K) {
            player.field_71075_bZ.func_82877_b(0.1f);
            player.field_71075_bZ.func_75092_a(0.05f);
        }
    }

    private int hasEnergyCrystal(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != ItemHandler.energyCrystal || player.field_71071_by.field_70462_a[i].func_77952_i() >= player.field_71071_by.field_70462_a[i].func_77958_k()) continue;
            return i;
        }
        return -1;
    }

    private void damageEnergyCrystal(EntityPlayer player, int index) {
        player.field_71071_by.func_70301_a(index).func_77972_a(1, (EntityLivingBase)player);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (GuiScreen.func_146272_n()) {
            tooltip.add("");
            tooltip.add(TextFormatting.DARK_PURPLE + "When completely equipped:");
            tooltip.add(TextFormatting.BLUE + "-Flight");
            tooltip.add(TextFormatting.BLUE + "-Full damage protection (except void damage)");
            tooltip.add(TextFormatting.BLUE + "+20% Speed");
        } else {
            ToolTipBuilder.addShiftForMoreDetails(tooltip);
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }
}

