/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.items.armor;

import de.comeight.crystallogy.blocks.materials.CustomArmorMaterials;
import de.comeight.crystallogy.items.armor.BaseArmor;
import de.comeight.crystallogy.util.ToolTipBuilder;
import de.comeight.crystallogy.util.Utilities;
import de.comeight.crystallogy.util.armor.ArmorListEntry;
import de.comeight.crystallogy.util.armor.CombinedArmorList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Armor_combined
extends BaseArmor
implements ISpecialArmor {
    private static final String ID = "armor_combined_";

    public Armor_combined(int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(CustomArmorMaterials.CRYSTALL_COMBINED, renderIndexIn, equipmentSlotIn, ID + equipmentSlotIn.func_188450_d());
    }

    @Override
    public String getID() {
        return ID + this.field_77881_a.func_188450_d();
    }

    public UUID getArmorListEntryId(ItemStack itemStackIn) {
        if (!itemStackIn.func_77942_o()) {
            this.createNewTagCompound(itemStackIn);
        }
        if (!itemStackIn.func_77978_p().func_186855_b("armorListEntryId")) {
            this.createNewIdTag(itemStackIn);
        }
        return itemStackIn.func_77978_p().func_186857_a("armorListEntryId");
    }

    public LinkedList<ItemStack> getArmorList(ItemStack itemStackIn) {
        ArmorListEntry entry = CombinedArmorList.getEntry(this.getArmorListEntryId(itemStackIn));
        if (entry != null) {
            return entry.getList();
        }
        return null;
    }

    public static void addArmor(ItemStack itemStackIn, ItemStack armor) {
        if (itemStackIn.func_77973_b() instanceof Armor_combined) {
            Armor_combined armorCombined = (Armor_combined)itemStackIn.func_77973_b();
            UUID id = armorCombined.getArmorListEntryId(itemStackIn);
            CombinedArmorList.addArmor(armor, id);
            armorCombined.save(itemStackIn);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        LinkedList<ItemStack> list = this.getArmorList(itemStack);
        if (list == null) {
            return;
        }
        for (ItemStack armorStack : list) {
            ItemArmor armor = (ItemArmor)armorStack.func_77973_b();
            armor.onArmorTick(world, player, itemStack);
        }
    }

    public void func_77663_a(ItemStack itemStack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (Utilities.getRandInt(0, 10) == 0 || System.currentTimeMillis() % 50L == 0L) {
            this.manageArmor(itemStack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        LinkedList<ItemStack> list = this.getArmorList(stack);
        if (GuiScreen.func_146272_n()) {
            tooltip.add("");
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ItemArmor armor = (ItemArmor)list.get(i).func_77973_b();
                    tooltip.add(TextFormatting.DARK_AQUA + String.valueOf(i + 1) + ": " + TextFormatting.RESET + armor.func_77653_i(new ItemStack((Item)armor)));
                    armor.func_77624_a(stack, playerIn, tooltip, advanced);
                    tooltip.add("");
                }
            } else {
                tooltip.add(TextFormatting.DARK_AQUA + "No armor added!");
            }
        } else {
            if (list != null) {
                tooltip.add(TextFormatting.DARK_AQUA + "Size: " + list.size());
            } else {
                tooltip.add(TextFormatting.DARK_AQUA + "Size: 0");
            }
            ToolTipBuilder.addShiftForMoreDetails(tooltip);
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        ISpecialArmor.ArmorProperties ap = new ISpecialArmor.ArmorProperties(1, 2.0, 1);
        return ap;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        int iArmor = 0;
        return iArmor;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        LinkedList<ItemStack> list = this.getArmorList(stack);
        if (list == null) {
            return;
        }
        for (ItemStack armorStack : list) {
            ItemArmor armor = (ItemArmor)armorStack.func_77973_b();
            if (!(armor instanceof ISpecialArmor)) continue;
            ISpecialArmor armor2 = (ISpecialArmor)armor;
            armor2.damageArmor(entity, stack, source, damage, slot);
        }
    }

    private void createNewTagCompound(ItemStack itemStackIn) {
        itemStackIn.func_77982_d(new NBTTagCompound());
    }

    private void createNewIdTag(ItemStack itemStackIn) {
        NBTTagCompound compound = itemStackIn.func_77978_p();
        compound.func_186854_a("armorListEntryId", UUID.randomUUID());
        itemStackIn.func_77982_d(compound);
    }

    private void save(ItemStack itemStackIn) {
        UUID id = this.getArmorListEntryId(itemStackIn);
        CombinedArmorList.writeToNBT(id, itemStackIn.func_77978_p());
    }

    private void read(ItemStack itemStackIn) {
        if (itemStackIn.func_77942_o()) {
            CombinedArmorList.readFromNBT(itemStackIn.func_77978_p());
        }
    }

    private boolean hasArmorIdStored(ItemStack itemStackIn) {
        return itemStackIn.func_77942_o() && itemStackIn.func_77978_p().func_186855_b("armorListEntryId");
    }

    private void manageArmor(ItemStack itemStackIn) {
        if (this.hasArmorIdStored(itemStackIn)) {
            this.read(itemStackIn);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            ArmorListEntry entry = CombinedArmorList.removeEntry(this.getArmorListEntryId(itemStackIn));
            this.createNewTagCompound(itemStackIn);
            this.createNewIdTag(itemStackIn);
            if (entry == null) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
            }
            for (ItemStack armorStack : entry.getList()) {
                if (playerIn.field_71071_by.func_70441_a(armorStack)) continue;
                playerIn.func_71019_a(armorStack, false);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }
}

