/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.itemBlocks;

import de.comeight.crystallogy.itemBlocks.BaseItemBlock;
import de.comeight.crystallogy.util.EntityUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockCrystalOfHolding
extends BaseItemBlock {
    public ItemBlockCrystalOfHolding(Block block) {
        super(block, "crystalOfHolding");
    }

    public boolean hasEntity(ItemStack stack) {
        return true;
    }

    public boolean func_77636_d(ItemStack stack) {
        return EntityUtils.hasEntity(stack.func_77978_p());
    }

    public Entity getEntity(ItemStack stack, World worldIn) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound compound = stack.func_77978_p();
        Entity ent = EntityUtils.readEntityFromCompound(compound, worldIn);
        stack.func_77982_d(this.getEmptyCompound());
        return ent;
    }

    public void setEntity(ItemStack stack, Entity ent) {
        NBTTagCompound compound = new NBTTagCompound();
        EntityUtils.writeEntityToCompound(compound, ent);
        stack.func_77982_d(compound);
    }

    private NBTTagCompound getEmptyCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("hasEntity", false);
        return compound;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74767_n("hasEntity")) {
                tooltip.add("Has Entity: " + TextFormatting.DARK_GREEN + "Yes");
                tooltip.add(TextFormatting.GOLD + "Name: " + TextFormatting.RESET + tag.func_74779_i("id_entity"));
                tooltip.add("");
                tooltip.add("Reight click to plant on Sanstone.");
                tooltip.add("Shift reight click to release entity.");
            } else {
                tooltip.add("Has Entity: " + TextFormatting.DARK_RED + "No");
                tooltip.add(TextFormatting.GOLD + "Name: " + TextFormatting.RESET + "-");
            }
        } else {
            tooltip.add("Has Entity: " + TextFormatting.DARK_RED + "No");
            tooltip.add(TextFormatting.GOLD + "Name: " + TextFormatting.RESET + "-");
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af() && EntityUtils.hasEntity(stack.func_77978_p())) {
            pos = pos.func_177972_a(facing);
            this.releaseEntity(stack, worldIn, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), playerIn);
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(stack, playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void releaseEntity(ItemStack stack, World worldIn, Vec3d pos, EntityPlayer playerIn) {
        if (!this.hasEntity(stack)) {
            return;
        }
        ItemStack ret = stack.func_77946_l();
        ret.field_77994_a = 1;
        --stack.field_77994_a;
        Entity ent = this.getEntity(ret, worldIn);
        if (!playerIn.field_71075_bZ.field_75098_d && !playerIn.field_71071_by.func_70441_a(ret)) {
            playerIn.func_71019_a(ret, false);
        }
        if (ent != null && !worldIn.field_72995_K) {
            ent.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            ent.func_184221_a(MathHelper.func_180182_a((Random)new Random()));
            worldIn.func_72838_d(ent);
            if (ent instanceof EntityLiving) {
                ((EntityLiving)ent).func_70642_aH();
            }
        }
    }
}

