/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.handler;

import com.google.common.collect.Maps;
import de.comeight.crystallogy.particles.BaseParticle;
import de.comeight.crystallogy.particles.InfuserBlockActiveParticle;
import de.comeight.crystallogy.particles.InfusionParticle;
import de.comeight.crystallogy.particles.JumpParticleBetweenCrystalls;
import de.comeight.crystallogy.particles.LightParticle;
import de.comeight.crystallogy.particles.ParticleA;
import de.comeight.crystallogy.particles.ParticleB;
import de.comeight.crystallogy.particles.ParticleC;
import de.comeight.crystallogy.particles.ParticleD;
import de.comeight.crystallogy.particles.ParticleE;
import de.comeight.crystallogy.particles.ParticleF;
import de.comeight.crystallogy.particles.ParticleNColor;
import de.comeight.crystallogy.util.Utilities;
import java.util.Map;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleHandler {
    private Map<Integer, IParticleFactory> particleTypes = Maps.newHashMap();

    public IParticleFactory getParticleFactory(int id) {
        return this.particleTypes.get(id);
    }

    public static BaseParticle getBaseParticleFromType(String type) {
        return ParticleHandler.getBaseParticleFromType(type, null);
    }

    public static BaseParticle getBaseParticleFromType(String type, String s) {
        BaseParticle particle = new BaseParticle();
        if (type.equals("a")) {
            particle = new ParticleA(s);
        } else if (type.equals("b")) {
            particle = new ParticleB(s);
        } else if (type.equals("c")) {
            particle = new ParticleC(s);
        } else if (type.equals("d")) {
            particle = new ParticleD(s);
        } else if (type.equals("e")) {
            particle = new ParticleE(s);
        } else if (type.equals("f")) {
            particle = new ParticleF(s);
        } else if (type.equals("2")) {
            particle = new InfusionParticle(s);
        } else if (type.equals("1")) {
            particle = new JumpParticleBetweenCrystalls(s);
        } else if (type.equals("n_c")) {
            particle = new ParticleNColor(s);
        } else if (type.equals("i_color")) {
            particle = new InfuserBlockActiveParticle(s);
        } else {
            Utilities.addConsoleText("Unknown Particle Type!");
        }
        return particle;
    }

    public void registerParticle(int id, IParticleFactory particleFactory) {
        this.particleTypes.put(id, particleFactory);
    }

    @SubscribeEvent
    public void stitcherEventPre(TextureStitchEvent.Pre event) {
        int i;
        for (i = 0; i < ParticleA.rL.length; ++i) {
            event.getMap().func_174942_a(ParticleA.rL[i]);
        }
        for (i = 0; i < ParticleB.rL.length; ++i) {
            event.getMap().func_174942_a(ParticleB.rL[i]);
        }
        for (i = 0; i < ParticleC.rL.length; ++i) {
            event.getMap().func_174942_a(ParticleC.rL[i]);
        }
        for (i = 0; i < ParticleD.rL.length; ++i) {
            event.getMap().func_174942_a(ParticleD.rL[i]);
        }
        for (i = 0; i < ParticleE.rL.length; ++i) {
            event.getMap().func_174942_a(ParticleE.rL[i]);
        }
        for (i = 0; i < ParticleF.rL.length; ++i) {
            event.getMap().func_174942_a(ParticleF.rL[i]);
        }
        for (i = 0; i < ParticleNColor.rL.length; ++i) {
            event.getMap().func_174942_a(ParticleNColor.rL[i]);
        }
        for (i = 0; i < InfusionParticle.rL.length; ++i) {
            event.getMap().func_174942_a(InfusionParticle.rL[i]);
        }
        for (i = 0; i < JumpParticleBetweenCrystalls.rL.length; ++i) {
            event.getMap().func_174942_a(JumpParticleBetweenCrystalls.rL[i]);
        }
        for (i = 0; i < InfuserBlockActiveParticle.rL.length; ++i) {
            event.getMap().func_174942_a(InfuserBlockActiveParticle.rL[i]);
        }
        for (i = 0; i < LightParticle.rL.length; ++i) {
            event.getMap().func_174942_a(LightParticle.rL[i]);
        }
        Utilities.addConsoleText("All particles are registered.");
    }
}

