/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.handler;

import de.comeight.crystallogy.items.crafting.BaseRecipe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public abstract class BaseRecipeHandler {
    protected ArrayList<BaseRecipe> craftingList = new ArrayList();

    public ArrayList<BaseRecipe> getRecipes() {
        return this.craftingList;
    }

    public int[] getNumberOfInputItems(ItemStack[] input) {
        if (input == null) {
            return null;
        }
        BaseRecipe recipe = this.findRecipe(input);
        if (recipe == null) {
            return null;
        }
        int[] ret = new int[recipe.input.length];
        for (int i = 0; i < recipe.input.length; ++i) {
            ret[i] = recipe.input[i].field_77994_a;
        }
        return ret;
    }

    public ItemStack[] getResults(ItemStack[] input) {
        if (input == null) {
            return null;
        }
        BaseRecipe recipe = this.findRecipe(input);
        if (recipe != null) {
            return recipe.getOutput(input);
        }
        return null;
    }

    public float getExperience(ItemStack[] input) {
        if (input == null) {
            return 0.0f;
        }
        BaseRecipe recipe = this.findRecipe(input);
        if (recipe != null) {
            return recipe.experience;
        }
        return 0.0f;
    }

    public int getTotalCookTime(ItemStack[] input) {
        if (input == null) {
            return 0;
        }
        BaseRecipe recipe = this.findRecipe(input);
        if (recipe != null) {
            return recipe.totalCookTime;
        }
        return 0;
    }

    public ArrayList<ArrayList<ItemStack>> getInputs() {
        ArrayList<ArrayList<ItemStack>> inputs = new ArrayList<ArrayList<ItemStack>>();
        int e = 0;
        for (BaseRecipe baseRecipe : this.craftingList) {
            inputs.add(new ArrayList());
            for (int i = 0; i < baseRecipe.input.length; ++i) {
                inputs.get(e).add(baseRecipe.input[i]);
            }
            ++e;
        }
        return inputs;
    }

    public ArrayList<ArrayList<ItemStack>> getOutputs() {
        ArrayList<ArrayList<ItemStack>> outputs = new ArrayList<ArrayList<ItemStack>>();
        int e = 0;
        for (BaseRecipe baseRecipe : this.craftingList) {
            outputs.add(new ArrayList());
            for (int i = 0; i < baseRecipe.getOutput(baseRecipe.input).length; ++i) {
                outputs.get(e).add(baseRecipe.getOutput(baseRecipe.input)[i]);
            }
            ++e;
        }
        return outputs;
    }

    public BaseRecipe findRecipe(ItemStack[] input) {
        for (BaseRecipe baseRecipe : this.craftingList) {
            boolean wrong = false;
            for (int i = 0; i < baseRecipe.input.length; ++i) {
                if (input[i] != null && baseRecipe.input[i].func_77973_b() == input[i].func_77973_b() && baseRecipe.input[i].field_77994_a <= input[i].field_77994_a) continue;
                wrong = true;
            }
            if (wrong) continue;
            return baseRecipe;
        }
        return null;
    }

    public boolean match(ItemStack[] input) {
        if (input == null) {
            return false;
        }
        return this.findRecipe(input) != null;
    }

    public void addRecipe(BaseRecipe recipe) {
        this.craftingList.add(recipe);
    }
}

