/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.compat.jei.infusion;

import de.comeight.crystallogy.compat.jei.CrystallogyPlugin;
import de.comeight.crystallogy.compat.jei.infusion.InfusionRecipeJEI;
import de.comeight.crystallogy.handler.InfusionRecipeHandler;
import de.comeight.crystallogy.items.crafting.infusion.InfusionRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class InfusionCraftingCategory
implements IRecipeCategory {
    @Nonnull
    public static final String ID = "crystallogy:infusion.JEI";
    @Nonnull
    private static final String TITEL = "Infusion Crafting";
    @Nonnull
    private final IDrawable background = CrystallogyPlugin.jeiHelper.getGuiHelper().createBlankDrawable(200, 100);
    @Nonnull
    private final IDrawable slotsDrawable = CrystallogyPlugin.jeiHelper.getGuiHelper().getSlotDrawable();
    private static final ResourceLocation rL = new ResourceLocation("crystallogy:textures/guis/jei/GuiInfusion.png");
    private static final int CENTERSLOT = 0;
    private static final int SURROUNDING_1 = 1;
    private static final int SURROUNDING_2 = 2;
    private static final int SURROUNDING_3 = 3;
    private static final int SURROUNDING_4 = 4;
    private static final int OUTPUT = 5;

    @Nonnull
    public String getUid() {
        return ID;
    }

    @Nonnull
    public String getTitle() {
        return TITEL;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.init(0, true, 52, 42);
        group.init(1, true, 24, 42);
        group.init(2, true, 52, 70);
        group.init(3, true, 80, 42);
        group.init(4, true, 52, 12);
        if (recipeWrapper instanceof InfusionRecipeJEI) {
            InfusionRecipeJEI recipe = (InfusionRecipeJEI)recipeWrapper;
            for (int i = 0; i < recipe.getInputs().size(); ++i) {
                group.setFromRecipe(i, (List)recipe.getInputs().get(i));
            }
            group.init(5, true, 122, 42);
            group.setFromRecipe(5, recipe.getOutputs());
        }
    }

    public static ArrayList<InfusionRecipeJEI> getRecipes() {
        ArrayList<InfusionRecipeJEI> recipes = new ArrayList<InfusionRecipeJEI>();
        for (InfusionRecipe infusionRecipe : InfusionRecipeHandler.getRecipes()) {
            recipes.add(new InfusionRecipeJEI(infusionRecipe));
        }
        return recipes;
    }

    public void drawExtras(Minecraft minecraft) {
        this.slotsDrawable.draw(minecraft, 52, 42);
        this.slotsDrawable.draw(minecraft, 24, 42);
        this.slotsDrawable.draw(minecraft, 52, 70);
        this.slotsDrawable.draw(minecraft, 80, 42);
        this.slotsDrawable.draw(minecraft, 52, 12);
        this.slotsDrawable.draw(minecraft, 122, 42);
    }

    public void drawAnimations(Minecraft minecraft) {
    }
}

