/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.blocks;

import com.google.common.base.Predicate;
import de.comeight.crystallogy.CommonProxy;
import de.comeight.crystallogy.blocks.BaseBlockCutout;
import de.comeight.crystallogy.handler.BlockHandler;
import de.comeight.crystallogy.network.NetworkPacketParticle;
import de.comeight.crystallogy.network.NetworkParticle;
import de.comeight.crystallogy.particles.JumpParticleBetweenCrystalls;
import de.comeight.crystallogy.particles.ParticleB;
import de.comeight.crystallogy.util.RGBColor;
import de.comeight.crystallogy.util.Utilities;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Crystall
extends BaseBlockCutout {
    protected RGBColor color = new RGBColor(1.0f, 1.0f, 1.0f);
    protected int chance = 5;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(EnumFacing p_apply_1_) {
            return true;
        }
    });
    protected static final AxisAlignedBB CRYSTAL_NORTH_AABB = new AxisAlignedBB(0.3, 0.25, 0.4, 0.7, 0.9, 1.0);
    protected static final AxisAlignedBB CRYSTAL_SOUTH_AABB = new AxisAlignedBB(0.3, 0.25, 0.0, 0.7, 0.9, 0.6);
    protected static final AxisAlignedBB CRYSTAL_WEST_AABB = new AxisAlignedBB(0.4, 0.1, 0.3, 1.0, 0.75, 0.7);
    protected static final AxisAlignedBB CRYSTAL_EAST_AABB = new AxisAlignedBB(0.0, 0.25, 0.3, 0.6, 0.9, 0.7);
    protected static final AxisAlignedBB CRYSTAL_UP_AABB = new AxisAlignedBB(0.3, 0.0, 0.25, 0.7, 0.6, 0.9);
    protected static final AxisAlignedBB CRYSTAL_DOWN_AABB = new AxisAlignedBB(0.3, 0.4, 0.25, 0.7, 1.0, 0.9);

    public Crystall(String ID) {
        super(Material.field_151592_s, ID);
        this.setHarvestLevel("pickaxe", 3);
        this.func_149715_a(0.3f);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    private void setDefaultStatus(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return CRYSTAL_NORTH_AABB;
            }
            case SOUTH: {
                return CRYSTAL_SOUTH_AABB;
            }
            case EAST: {
                return CRYSTAL_EAST_AABB;
            }
            case WEST: {
                return CRYSTAL_WEST_AABB;
            }
            case UP: {
                return CRYSTAL_UP_AABB;
            }
            case DOWN: {
                return CRYSTAL_DOWN_AABB;
            }
        }
        return CRYSTAL_DOWN_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.field_72995_K) {
            this.addGlitterParticleChance(worldIn, pos, this.chance);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    protected void addJumpParticleBetweenCrystallsChance(World worldIn, BlockPos pos, int chance) {
        if (Utilities.getRandInt(1, chance) == chance) {
            this.findCrystallsAndSendJumpParticle(worldIn, pos);
        }
    }

    protected void findCrystallsAndSendJumpParticle(World worldIn, BlockPos pos) {
        for (int i = -8; i < 8; ++i) {
            for (int e = -8; e < 8; ++e) {
                for (int j = -8; j < 8; ++j) {
                    if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n() + i, pos.func_177956_o() + e, pos.func_177952_p() + j)).func_177230_c() == BlockHandler.crystall_blue) {
                        this.addJumpParticleBetweenCrystalls(worldIn, pos, new Vec3d((double)(pos.func_177958_n() + i) + 0.5, (double)(pos.func_177956_o() + e) + 0.2, (double)pos.func_177952_p() + 0.5 + (double)j), new RGBColor(0.5f, 0.5f, 1.0f));
                    }
                    if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n() + i, pos.func_177956_o() + e, pos.func_177952_p() + j)).func_177230_c() != BlockHandler.crystall_red) continue;
                    this.addJumpParticleBetweenCrystalls(worldIn, pos, new Vec3d((double)(pos.func_177958_n() + i) + 0.5, (double)(pos.func_177956_o() + e) + 0.2, (double)pos.func_177952_p() + 0.5 + (double)j), this.color);
                }
            }
        }
    }

    protected void addJumpParticleBetweenCrystalls(World worldIn, BlockPos pos, Vec3d targetPos, RGBColor color) {
        JumpParticleBetweenCrystalls jP = new JumpParticleBetweenCrystalls(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5, 0.1, 0.1, 0.1, targetPos);
        jP.func_70538_b(color.r, color.g, color.b);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)jP);
    }

    protected void setParticleColor(RGBColor color) {
        this.color = color;
    }

    protected void addGlitterParticleChance(World worldIn, BlockPos pos) {
        this.addGlitterParticleChance(worldIn, pos, this.chance);
    }

    protected void addGlitterParticleChance(World worldIn, BlockPos pos, int chance) {
        if (Utilities.getRandInt(1, chance) == chance) {
            this.addGlitterParticle(worldIn, pos);
        }
    }

    protected void addGlitterParticle(World worldIn, BlockPos pos) {
        ParticleB gP = new ParticleB(worldIn, (double)pos.func_177958_n() + Utilities.getRandDouble(0.3, 0.7), (double)pos.func_177956_o() + Utilities.getRandDouble(0.2, 0.6), (double)pos.func_177952_p() + Utilities.getRandDouble(0.25, 0.9), 0.2, 0.2, 0.2);
        gP.func_70538_b(this.color.r, this.color.g, this.color.b);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)gP);
    }

    protected void addGlitterParticleNetworkChance(World worldIn, BlockPos pos, int chance) {
        if (Utilities.getRandInt(1, chance) == chance) {
            this.addGlitterParticleNetwork(worldIn, pos);
        }
    }

    protected void addGlitterParticleNetwork(World worldIn, BlockPos pos) {
        ParticleB gP = new ParticleB(worldIn, (double)pos.func_177958_n() + Utilities.getRandDouble(0.25, 0.75), (double)pos.func_177956_o() + Utilities.getRandDouble(0.25, 0.75), (double)pos.func_177952_p() + Utilities.getRandDouble(0.25, 0.75), 0.0, 0.0, 0.0);
        gP.setParticleMaxAge(60);
        gP.func_70538_b(this.color.r, this.color.g, this.color.b);
        NetworkParticle nP = new NetworkParticle(gP, gP.name);
        nP.setSize(new Vec3d(0.0, 0.0, 0.0));
        NetworkPacketParticle pMtS = new NetworkPacketParticle(nP);
        CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)pMtS);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        for (int i = 0; i < 10; ++i) {
            this.addGlitterParticleNetwork(worldIn, pos);
        }
        super.func_180649_a(worldIn, pos, playerIn);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        for (int i = 0; i < 50; ++i) {
            this.addGlitterParticleNetwork(worldIn, pos);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            entityIn.func_70097_a(DamageSource.field_76377_j, 0.5f);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultStatus(worldIn, pos, state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing;
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        if (iblockstate.func_177230_c() instanceof Crystall && (enumfacing = (EnumFacing)iblockstate.func_177229_b((IProperty)FACING)) == facing) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

