/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.blocks;

import de.comeight.crystallogy.blocks.BaseBlockCutout;
import de.comeight.crystallogy.tileEntitys.TileEntityCrystalOfHolding;
import de.comeight.crystallogy.util.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CrystalOfHolding
extends BaseBlockCutout
implements IPlantable {
    public static final String ID = "crystalOfHolding";
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
    private static final AxisAlignedBB[] CRYSTAL_OF_HOLDING_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0)};

    public CrystalOfHolding() {
        super(Material.field_151588_w, ID);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CRYSTAL_OF_HOLDING_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int count = 1;
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 2) {
            count = 2 + rand.nextInt(3) + (fortune > 0 ? rand.nextInt(fortune + 1) : 0);
        }
        for (int i = 0; i < count; ++i) {
            ret.add(this.getItemStackWithData((World)world, pos));
        }
        return ret;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getItemStackWithData(world, pos);
    }

    private ItemStack getItemStackWithData(World world, BlockPos pos) {
        TileEntity tE = world.func_175625_s(pos);
        ItemStack stack = new ItemStack((Block)this);
        if (tE instanceof TileEntityCrystalOfHolding) {
            TileEntityCrystalOfHolding crystal = (TileEntityCrystalOfHolding)tE;
            NBTTagCompound compound = new NBTTagCompound();
            if (crystal.hasEntity()) {
                EntityUtils.writeEntityToCompound(compound, crystal.getEntity());
                stack.func_77982_d(compound);
            }
        }
        return stack;
    }

    private Entity getEntity(World worldIn, BlockPos pos) {
        TileEntity tE = worldIn.func_175625_s(pos);
        if (tE instanceof TileEntityCrystalOfHolding) {
            TileEntityCrystalOfHolding crystal = (TileEntityCrystalOfHolding)tE;
            return crystal.getEntity();
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tE = worldIn.func_175625_s(pos);
        if (tE instanceof TileEntityCrystalOfHolding && stack.func_77942_o()) {
            TileEntityCrystalOfHolding crystal = (TileEntityCrystalOfHolding)tE;
            crystal.setEntity(EntityUtils.readEntityFromCompound(stack.func_77978_p(), worldIn));
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && this.canSustainCrystal(worldIn.func_180495_p(pos.func_177977_b()));
    }

    private void findAndTryPlant(World worldIn, BlockPos pos, Random rand) {
        Entity ent = this.getEntity(worldIn, pos);
        int side = rand.nextInt(4);
        switch (side) {
            case 0: {
                this.tryPlantAt(worldIn, pos.func_177978_c(), ent);
                break;
            }
            case 1: {
                this.tryPlantAt(worldIn, pos.func_177974_f(), ent);
                break;
            }
            case 2: {
                this.tryPlantAt(worldIn, pos.func_177976_e(), ent);
                break;
            }
            case 3: {
                this.tryPlantAt(worldIn, pos.func_177968_d(), ent);
            }
        }
    }

    private void tryPlantAt(World worldIn, BlockPos pos, Entity ent) {
        if (worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a && this.canSustainCrystal(worldIn.func_180495_p(pos.func_177977_b()))) {
            worldIn.func_180501_a(pos, this.func_176223_P(), 2);
            this.copyEntity(worldIn, pos, ent);
        }
    }

    private void copyEntity(World worldIn, BlockPos pos, Entity ent) {
        TileEntity tE = worldIn.func_175625_s(pos);
        if (tE instanceof TileEntityCrystalOfHolding) {
            TileEntityCrystalOfHolding crystal = (TileEntityCrystalOfHolding)tE;
            crystal.setEntity(ent);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i <= 2 && rand.nextInt(30) == 0) {
            if (i == 2) {
                this.findAndTryPlant(worldIn, pos, rand);
            } else {
                this.grow(worldIn, pos, state, i + 1);
            }
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    private void grow(World worldIn, BlockPos pos, IBlockState state, int age) {
        TileEntity tE = worldIn.func_175625_s(pos);
        state = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age));
        worldIn.func_180501_a(pos, state, 2);
        if (tE != null) {
            tE.func_145829_t();
            worldIn.func_175690_a(pos, tE);
        }
    }

    protected boolean canSustainCrystal(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150322_A;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCrystalOfHolding();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }
}

