/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.blocks;

import de.comeight.crystallogy.blocks.BaseBlockTileEntity;
import de.comeight.crystallogy.blocks.materials.CustomMaterials;
import de.comeight.crystallogy.tileEntitys.TileEntityEntityJar;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseBlockEntityJar
extends BaseBlockTileEntity {
    public BaseBlockEntityJar(String id) {
        super(CustomMaterials.field_151592_s, id);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.685, 0.75);
    }

    protected ItemStack getItemStackWithData(World world, BlockPos pos) {
        TileEntity tE = world.func_175625_s(pos);
        ItemStack stack = new ItemStack((Block)this);
        if (tE instanceof TileEntityEntityJar) {
            TileEntityEntityJar jar = (TileEntityEntityJar)tE;
            NBTTagCompound compound = new NBTTagCompound();
            if (jar.hasEntity()) {
                jar.writeCustomDataToNBT(compound);
                stack.func_77982_d(compound);
            }
        }
        return stack;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getItemStackWithData(world, pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(this.getItemStackWithData((World)world, pos));
        return ret;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        if (worldIn.field_72995_K) {
            return 0;
        }
        TileEntity tE = worldIn.func_175625_s(pos);
        if (tE instanceof TileEntityEntityJar) {
            TileEntityEntityJar jar = (TileEntityEntityJar)tE;
            if (tE != null && jar.hasEntity()) {
                return 2;
            }
        }
        return 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tE = worldIn.func_175625_s(pos);
        if (tE instanceof TileEntityEntityJar && stack.func_77942_o()) {
            TileEntityEntityJar jar = (TileEntityEntityJar)tE;
            jar.readCustomDataToNBT(stack.func_77978_p());
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityEntityJar jar;
        TileEntity tE = worldIn.func_175625_s(pos);
        if (tE instanceof TileEntityEntityJar && (jar = (TileEntityEntityJar)tE).hasEntity()) {
            if (playerIn.func_70093_af()) {
                jar.removeEntity(worldIn, new Vec3d((Vec3i)pos), true);
                worldIn.func_175685_c(pos, (Block)this);
            } else {
                ItemStack stack = null;
                stack = playerIn.func_184614_ca();
                if (stack != null && !worldIn.field_72995_K) {
                    this.testForThreatDust(stack, jar, pos, playerIn);
                }
            }
        }
        return true;
    }

    protected void testForThreatDust(ItemStack stack, TileEntityEntityJar jar, BlockPos pos, EntityPlayer playerIn) {
        TileEntityEntityJar.EnumThreats threat = TileEntityEntityJar.EnumThreats.getThreatDust(stack);
        if (threat != null) {
            jar.addThreat(threat);
            ItemStack playerIStack = playerIn.func_184614_ca();
            if (playerIStack != null) {
                --playerIStack.field_77994_a;
            }
        }
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        super.func_180649_a(worldIn, pos, playerIn);
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityEntityJar();
    }
}

