/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.InternalConfigurationException;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertyType;
import edu.cmu.sphinx.util.props.RawPropertyData;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4PropWrapper;
import edu.cmu.sphinx.util.props.S4Property;
import edu.cmu.sphinx.util.props.S4String;
import edu.cmu.sphinx.util.props.S4StringList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertySheet
implements Cloneable {
    public static final String COMP_LOG_LEVEL = "logLevel";
    private Map<String, S4PropWrapper> registeredProperties = new HashMap<String, S4PropWrapper>();
    private Map<String, Object> propValues = new HashMap<String, Object>();
    private Map<String, Object> rawProps = new HashMap<String, Object>();
    private ConfigurationManager cm;
    private Configurable owner;
    private Class<? extends Configurable> ownerClass;
    private String instanceName;

    public PropertySheet(Configurable configurable, String name, RawPropertyData rpd, ConfigurationManager ConfigurationManager2) {
        this(configurable.getClass(), name, ConfigurationManager2, rpd);
        this.owner = configurable;
    }

    public PropertySheet(Class<? extends Configurable> confClass, String name, ConfigurationManager cm, RawPropertyData rpd) {
        this.ownerClass = confClass;
        this.cm = cm;
        this.instanceName = name;
        PropertySheet.parseClass(confClass);
        this.setConfigurableClass(confClass);
        Map<String, Object> flatProps = rpd.flatten(cm).getProperties();
        this.rawProps = new HashMap<String, Object>(rpd.getProperties());
        for (String propName : this.rawProps.keySet()) {
            this.propValues.put(propName, flatProps.get(propName));
        }
    }

    private void registerProperty(String propName, S4PropWrapper property) {
        if (property == null || propName == null) {
            throw new InternalConfigurationException(this.getInstanceName(), propName, "property or its value is null");
        }
        if (!this.registeredProperties.containsKey(propName)) {
            this.registeredProperties.put(propName, property);
        }
        if (!this.propValues.containsKey(propName)) {
            this.propValues.put(propName, null);
            this.rawProps.put(propName, null);
        }
    }

    public S4PropWrapper getProperty(String name, Class<?> propertyClass) throws PropertyException {
        if (!this.propValues.containsKey(name)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, "Unknown property '" + name + "' ! Make sure that you've annotated it.");
        }
        S4PropWrapper s4PropWrapper = this.registeredProperties.get(name);
        if (s4PropWrapper == null) {
            throw new InternalConfigurationException(this.getInstanceName(), name, "Property is not an annotated property of " + this.getConfigurableClass());
        }
        try {
            propertyClass.cast(s4PropWrapper.getAnnotation());
        }
        catch (ClassCastException e) {
            throw new InternalConfigurationException(e, this.getInstanceName(), name, "Property annotation " + s4PropWrapper.getAnnotation() + " doesn't match the required type " + propertyClass.getName());
        }
        return s4PropWrapper;
    }

    public String getString(String name) throws PropertyException {
        S4PropWrapper s4PropWrapper = this.getProperty(name, S4String.class);
        S4String s4String = (S4String)s4PropWrapper.getAnnotation();
        if (this.propValues.get(name) == null) {
            boolean isDefDefined;
            boolean bl = isDefDefined = !s4String.defaultValue().equals("nullnullnull");
            if (s4String.mandatory() && !isDefDefined) {
                throw new InternalConfigurationException(this.getInstanceName(), name, "mandatory property is not set!");
            }
            this.propValues.put(name, isDefDefined ? s4String.defaultValue() : null);
        }
        String propValue = this.flattenProp(name);
        List<String> range = Arrays.asList(s4String.range());
        if (!range.isEmpty() && !range.contains(propValue)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, " is not in range (" + range + ')');
        }
        return propValue;
    }

    private String flattenProp(String name) {
        Object value = this.propValues.get(name);
        return value instanceof String ? (String)value : null;
    }

    public int getInt(String name) throws PropertyException {
        Object propObject;
        S4PropWrapper s4PropWrapper = this.getProperty(name, S4Integer.class);
        S4Integer s4Integer = (S4Integer)s4PropWrapper.getAnnotation();
        if (this.propValues.get(name) == null) {
            boolean isDefDefined;
            boolean bl = isDefDefined = s4Integer.defaultValue() != -918273645;
            if (s4Integer.mandatory()) {
                if (!isDefDefined) {
                    throw new InternalConfigurationException(this.getInstanceName(), name, "mandatory property is not set!");
                }
            } else if (!isDefDefined) {
                throw new InternalConfigurationException(this.getInstanceName(), name, "no default value for non-mandatory property");
            }
            this.propValues.put(name, s4Integer.defaultValue());
        }
        Integer propValue = (propObject = this.propValues.get(name)) instanceof Integer ? (Integer)propObject : Integer.decode(this.flattenProp(name));
        int[] range = s4Integer.range();
        if (range.length != 2) {
            throw new InternalConfigurationException(this.getInstanceName(), name, Arrays.toString(range) + " is not of expected range type, which is {minValue, maxValue)");
        }
        if (propValue < range[0] || propValue > range[1]) {
            throw new InternalConfigurationException(this.getInstanceName(), name, " is not in range (" + Arrays.toString(range) + ')');
        }
        return propValue;
    }

    public float getFloat(String name) throws PropertyException {
        return Double.valueOf(this.getDouble(name)).floatValue();
    }

    public double getDouble(String name) throws PropertyException {
        Object propObject;
        S4PropWrapper s4PropWrapper = this.getProperty(name, S4Double.class);
        S4Double s4Double = (S4Double)s4PropWrapper.getAnnotation();
        if (this.propValues.get(name) == null) {
            boolean isDefDefined;
            boolean bl = isDefDefined = s4Double.defaultValue() != -9.1827364512345E8;
            if (s4Double.mandatory()) {
                if (!isDefDefined) {
                    throw new InternalConfigurationException(this.getInstanceName(), name, "mandatory property is not set!");
                }
            } else if (!isDefDefined) {
                throw new InternalConfigurationException(this.getInstanceName(), name, "no default value for non-mandatory property");
            }
            this.propValues.put(name, s4Double.defaultValue());
        }
        Double propValue = (propObject = this.propValues.get(name)) instanceof Double ? (Double)propObject : (propObject instanceof Number ? Double.valueOf(((Number)propObject).doubleValue()) : Double.valueOf(this.flattenProp(name)));
        double[] range = s4Double.range();
        if (range.length != 2) {
            throw new InternalConfigurationException(this.getInstanceName(), name, Arrays.toString(range) + " is not of expected range type, which is {minValue, maxValue)");
        }
        if (propValue < range[0] || propValue > range[1]) {
            throw new InternalConfigurationException(this.getInstanceName(), name, " is not in range (" + Arrays.toString(range) + ')');
        }
        return propValue;
    }

    public Boolean getBoolean(String name) throws PropertyException {
        Object propObject;
        S4PropWrapper s4PropWrapper = this.getProperty(name, S4Boolean.class);
        S4Boolean s4Boolean = (S4Boolean)s4PropWrapper.getAnnotation();
        if (this.propValues.get(name) == null) {
            this.propValues.put(name, s4Boolean.defaultValue());
        }
        Boolean propValue = (propObject = this.propValues.get(name)) instanceof Boolean ? (Boolean)propObject : Boolean.valueOf(this.flattenProp(name));
        return propValue;
    }

    public Configurable getComponent(String name) throws PropertyException {
        S4PropWrapper s4PropWrapper = this.getProperty(name, S4Component.class);
        Configurable configurable = null;
        S4Component s4Component = (S4Component)s4PropWrapper.getAnnotation();
        Class<? extends Configurable> expectedType = s4Component.type();
        Object propVal = this.propValues.get(name);
        if (propVal != null && propVal instanceof Configurable) {
            return (Configurable)propVal;
        }
        if (propVal != null && propVal instanceof String) {
            PropertySheet ps = this.cm.getPropertySheet(this.flattenProp(name));
            if (ps != null) {
                configurable = ps.getOwner();
            } else {
                throw new InternalConfigurationException(this.getInstanceName(), name, "component '" + this.flattenProp(name) + "' is missing");
            }
        }
        if (configurable != null && !expectedType.isInstance(configurable)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, "mismatch between annotation and component type");
        }
        if (configurable != null) {
            this.propValues.put(name, configurable);
            return configurable;
        }
        configurable = this.getComponentFromAnnotation(name, s4Component);
        this.propValues.put(name, configurable);
        return configurable;
    }

    private Configurable getComponentFromAnnotation(String name, S4Component s4Component) {
        Class<? extends Configurable> defClass = s4Component.defaultClass();
        if (defClass.equals(Configurable.class) && s4Component.mandatory()) {
            throw new InternalConfigurationException(this.getInstanceName(), name, "mandatory property is not set!");
        }
        if (Modifier.isAbstract(defClass.getModifiers()) && s4Component.mandatory()) {
            throw new InternalConfigurationException(this.getInstanceName(), name, defClass.getName() + " is abstract!");
        }
        if (defClass.equals(Configurable.class)) {
            if (s4Component.mandatory()) {
                throw new InternalConfigurationException(this.getInstanceName(), name, this.instanceName + ": no default class defined for " + name);
            }
            return null;
        }
        Configurable configurable = ConfigurationManager.getInstance(defClass);
        if (configurable == null) {
            throw new InternalConfigurationException(this.getInstanceName(), name, "instantiation of referenenced configurable failed");
        }
        return configurable;
    }

    public Class<? extends Configurable> getComponentClass(String propName) {
        Class<? extends Configurable> defClass = null;
        if (this.propValues.get(propName) != null) {
            try {
                Class<?> objClass = Class.forName((String)this.propValues.get(propName));
                defClass = objClass.asSubclass(Configurable.class);
            }
            catch (ClassNotFoundException e) {
                PropertySheet ps = this.cm.getPropertySheet(this.flattenProp(propName));
                defClass = ps.ownerClass;
            }
        } else {
            S4Component comAnno = (S4Component)this.registeredProperties.get(propName).getAnnotation();
            defClass = comAnno.defaultClass();
            if (comAnno.mandatory()) {
                defClass = null;
            }
        }
        return defClass;
    }

    public List<String> getStringList(String name) throws InternalConfigurationException {
        this.getProperty(name, S4StringList.class);
        return ConfigurationManagerUtils.toStringList(this.propValues.get(name));
    }

    public <T> List<T> getComponentList(String name, Class<T> tclass) throws InternalConfigurationException {
        this.getProperty(name, S4ComponentList.class);
        List components = (List)this.propValues.get(name);
        assert (this.registeredProperties.get(name).getAnnotation() instanceof S4ComponentList);
        S4ComponentList annotation = (S4ComponentList)this.registeredProperties.get(name).getAnnotation();
        if (components == null) {
            List<Class<? extends Configurable>> defClasses = Arrays.asList(annotation.defaultList());
            ArrayList<Configurable> defaultComponents = new ArrayList<Configurable>();
            for (Class<? extends Configurable> defClass : defClasses) {
                defaultComponents.add(ConfigurationManager.getInstance(defClass));
            }
            this.propValues.put(name, defaultComponents);
        } else if (!components.isEmpty() && !(components.get(0) instanceof Configurable)) {
            ArrayList resolvedComponents = new ArrayList();
            for (Object componentName : components) {
                Object configurable = this.cm.lookup((String)componentName);
                if (configurable != null) {
                    resolvedComponents.add(configurable);
                    continue;
                }
                if (annotation.beTolerant()) continue;
                throw new InternalConfigurationException(name, (String)componentName, "lookup of list-element '" + componentName + "' failed!");
            }
            this.propValues.put(name, resolvedComponents);
        }
        List values = (List)this.propValues.get(name);
        ArrayList<T> result = new ArrayList<T>();
        for (Class<Configurable> obj : values) {
            if (tclass.isInstance(obj)) {
                result.add(tclass.cast(obj));
                continue;
            }
            throw new InternalConfigurationException(this.getInstanceName(), name, "Not all elements have required type " + tclass + " Found one of type " + obj.getClass());
        }
        return result;
    }

    public List<URL> getResourceList(String name) {
        ArrayList<URL> resourceList = new ArrayList<URL>();
        String pathListString = this.getString(name);
        if (pathListString != null) {
            for (String url : pathListString.split(";")) {
                try {
                    URL resourceUrl = new URL(url);
                    resourceList.add(resourceUrl);
                }
                catch (MalformedURLException mue) {
                    throw new IllegalArgumentException(url + " is not a valid URL.");
                }
            }
        }
        return resourceList;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String newInstanceName) {
        this.instanceName = newInstanceName;
    }

    public boolean isInstanciated() {
        return this.owner != null;
    }

    public synchronized Configurable getOwner() {
        try {
            if (!this.isInstanciated()) {
                Collection<String> undefProps = this.getUndefinedMandatoryProps();
                if (!undefProps.isEmpty()) {
                    throw new InternalConfigurationException(this.getInstanceName(), undefProps.toString(), "not all mandatory properties are defined");
                }
                this.owner = this.ownerClass.newInstance();
                this.owner.newProperties(this);
            }
        }
        catch (IllegalAccessException e) {
            throw new InternalConfigurationException(e, this.getInstanceName(), null, "Can't access class " + this.ownerClass);
        }
        catch (InstantiationException e) {
            throw new InternalConfigurationException(e, this.getInstanceName(), null, "Can't instantiate class " + this.ownerClass);
        }
        return this.owner;
    }

    public Collection<String> getUndefinedMandatoryProps() {
        ArrayList<String> undefProps = new ArrayList<String>();
        for (String propName : this.getRegisteredProperties()) {
            Annotation anno = this.registeredProperties.get(propName).getAnnotation();
            boolean isMandatory = false;
            if (anno instanceof S4Component) {
                isMandatory = ((S4Component)anno).mandatory() && ((S4Component)anno).defaultClass() == null;
            } else if (anno instanceof S4String) {
                isMandatory = ((S4String)anno).mandatory() && ((S4String)anno).defaultValue().equals("nullnullnull");
            } else if (anno instanceof S4Integer) {
                isMandatory = ((S4Integer)anno).mandatory() && ((S4Integer)anno).defaultValue() == -918273645;
            } else if (anno instanceof S4Double) {
                boolean bl = isMandatory = ((S4Double)anno).mandatory() && ((S4Double)anno).defaultValue() == -9.1827364512345E8;
            }
            if (!isMandatory || this.rawProps.get(propName) != null || this.propValues.get(propName) != null) continue;
            undefProps.add(propName);
        }
        return undefProps;
    }

    public Class<? extends Configurable> getConfigurableClass() {
        return this.ownerClass;
    }

    void setConfigurableClass(Class<? extends Configurable> confClass) {
        this.ownerClass = confClass;
        if (this.isInstanciated()) {
            throw new RuntimeException("class is already instantiated");
        }
        HashSet<String> classProperties = new HashSet<String>();
        Map<Field, Annotation> classProps = PropertySheet.parseClass(this.ownerClass);
        for (Map.Entry<Field, Annotation> entry : classProps.entrySet()) {
            try {
                String propertyName = (String)entry.getKey().get(null);
                assert (!classProperties.contains(propertyName)) : "duplicate property-name for different properties: " + propertyName + " for the class " + confClass;
                this.registerProperty(propertyName, new S4PropWrapper(entry.getValue()));
                classProperties.add(propertyName);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void setString(String name, String value) throws PropertyException {
        if (!this.registeredProperties.containsKey(name)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is not a registered string-property");
        }
        Annotation annotation = this.registeredProperties.get(name).getAnnotation();
        if (!(annotation instanceof S4String)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is of type string");
        }
        this.applyConfigurationChange(name, value, value);
    }

    public void setInt(String name, int value) throws PropertyException {
        if (!this.registeredProperties.containsKey(name)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is not a registered int-property");
        }
        Annotation annotation = this.registeredProperties.get(name).getAnnotation();
        if (!(annotation instanceof S4Integer)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is of type int");
        }
        this.applyConfigurationChange(name, value, value);
    }

    public void setDouble(String name, double value) throws PropertyException {
        if (!this.registeredProperties.containsKey(name)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is not a registered double-property");
        }
        Annotation annotation = this.registeredProperties.get(name).getAnnotation();
        if (!(annotation instanceof S4Double)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is of type double");
        }
        this.applyConfigurationChange(name, value, value);
    }

    public void setBoolean(String name, Boolean value) throws PropertyException {
        if (!this.registeredProperties.containsKey(name)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is not a registered boolean-property");
        }
        Annotation annotation = this.registeredProperties.get(name).getAnnotation();
        if (!(annotation instanceof S4Boolean)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is of type boolean");
        }
        this.applyConfigurationChange(name, value, value);
    }

    public void setComponent(String name, String cmName, Configurable value) throws PropertyException {
        if (!this.registeredProperties.containsKey(name)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is not a registered compontent");
        }
        Annotation annotation = this.registeredProperties.get(name).getAnnotation();
        if (!(annotation instanceof S4Component)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is of type component");
        }
        this.applyConfigurationChange(name, cmName, value);
    }

    public void setComponentList(String name, List<String> valueNames, List<Configurable> value) throws PropertyException {
        if (!this.registeredProperties.containsKey(name)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is not a registered component-list");
        }
        Annotation annotation = this.registeredProperties.get(name).getAnnotation();
        if (!(annotation instanceof S4ComponentList)) {
            throw new InternalConfigurationException(this.getInstanceName(), name, '\'' + name + "' is of type component-list");
        }
        this.rawProps.put(name, valueNames);
        this.propValues.put(name, value);
        this.applyConfigurationChange(name, valueNames, value);
    }

    private void applyConfigurationChange(String propName, Object cmName, Object value) throws PropertyException {
        this.rawProps.put(propName, cmName);
        this.propValues.put(propName, value != null ? value : cmName);
        if (this.getInstanceName() != null) {
            this.cm.fireConfChanged(this.getInstanceName(), propName);
        }
        if (this.owner != null) {
            this.owner.newProperties(this);
        }
    }

    void setRaw(String key, Object val) {
        this.rawProps.put(key, val);
        this.propValues.put(key, null);
    }

    public Object getRaw(String name) {
        return this.rawProps.get(name);
    }

    public Object getRawNoReplacement(String name) {
        return this.rawProps.get(name);
    }

    public PropertyType getType(String propName) {
        S4PropWrapper wrapper = this.registeredProperties.get(propName);
        if (wrapper == null) {
            throw new InternalConfigurationException(this.getInstanceName(), propName, " is not a valid property of" + this.getConfigurableClass());
        }
        Annotation annotation = wrapper.getAnnotation();
        if (annotation instanceof S4Component) {
            return PropertyType.COMPONENT;
        }
        if (annotation instanceof S4ComponentList) {
            return PropertyType.COMPONENT_LIST;
        }
        if (annotation instanceof S4Integer) {
            return PropertyType.INT;
        }
        if (annotation instanceof S4Double) {
            return PropertyType.DOUBLE;
        }
        if (annotation instanceof S4Boolean) {
            return PropertyType.BOOLEAN;
        }
        if (annotation instanceof S4String) {
            return PropertyType.STRING;
        }
        throw new RuntimeException("Unknown property type");
    }

    ConfigurationManager getPropertyManager() {
        return this.cm;
    }

    public Logger getLogger() {
        String baseName = ConfigurationManagerUtils.getLogPrefix(this.cm) + this.ownerClass.getName();
        Logger logger = this.instanceName != null ? Logger.getLogger(baseName + '.' + this.instanceName) : Logger.getLogger(baseName);
        Object rawLogLevel = this.rawProps.get(COMP_LOG_LEVEL);
        if (rawLogLevel != null) {
            logger.setLevel(rawLogLevel instanceof String ? Level.parse((String)rawLogLevel) : (Level)rawLogLevel);
        }
        return logger;
    }

    public Collection<String> getRegisteredProperties() {
        return Collections.unmodifiableCollection(this.registeredProperties.keySet());
    }

    public void setCM(ConfigurationManager cm) {
        this.cm = cm;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PropertySheet)) {
            return false;
        }
        PropertySheet ps = (PropertySheet)obj;
        return this.rawProps.keySet().equals(ps.rawProps.keySet());
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 1;
    }

    public String toString() {
        return this.getInstanceName() + "; isInstantiated=" + this.isInstanciated() + "; props=" + this.rawProps.keySet();
    }

    protected PropertySheet clone() throws CloneNotSupportedException {
        PropertySheet ps = (PropertySheet)super.clone();
        ps.registeredProperties = new HashMap<String, S4PropWrapper>(this.registeredProperties);
        ps.propValues = new HashMap<String, Object>(this.propValues);
        ps.rawProps = new HashMap<String, Object>(this.rawProps);
        for (String regProp : ps.getRegisteredProperties()) {
            if (this.getType(regProp) != PropertyType.COMPONENT_LIST) continue;
            ps.rawProps.put(regProp, ConfigurationManagerUtils.toStringList(this.rawProps.get(regProp)));
            ps.propValues.put(regProp, null);
        }
        ps.cm = this.cm;
        ps.owner = null;
        ps.instanceName = this.instanceName;
        return ps;
    }

    public boolean validate() {
        for (String propName : this.rawProps.keySet()) {
            if (propName.equals(COMP_LOG_LEVEL) || this.registeredProperties.containsKey(propName)) continue;
            return false;
        }
        return true;
    }

    private static Map<Field, Annotation> parseClass(Class<? extends Configurable> configurable) {
        Field[] classFields = configurable.getFields();
        HashMap<Field, Annotation> s4props = new HashMap<Field, Annotation>();
        for (Field field : classFields) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                Annotation[] superAnnotations;
                for (Annotation superAnnotation : superAnnotations = annotation.annotationType().getAnnotations()) {
                    if (!(superAnnotation instanceof S4Property)) continue;
                    int fieldModifiers = field.getModifiers();
                    assert (Modifier.isStatic(fieldModifiers)) : "property fields are assumed to be static";
                    assert (Modifier.isPublic(fieldModifiers)) : "property fields are assumed to be public";
                    assert (Modifier.isFinal(fieldModifiers)) : "property fields are assumed to be final";
                    assert (field.getType().equals(String.class)) : "properties fields are assumed to be instances of java.lang.String";
                    s4props.put(field, annotation);
                }
            }
        }
        return s4props;
    }
}

