/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.SphinxLogFormatter;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.InternalConfigurationException;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.RawPropertyData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConfigurationManagerUtils {
    private static final Pattern globalSymbolPattern = Pattern.compile("\\$\\{(\\w+)\\}");
    public static final String GLOBAL_COMMON_LOGLEVEL = "logLevel";
    public static final String CM_FILE_SUFFIX = ".sxl";
    static final Pattern jarPattern = Pattern.compile("resource:(.*)", 2);

    private ConfigurationManagerUtils() {
    }

    public boolean validateConfiguration(ConfigurationManager cm) {
        for (String compName : cm.getComponentNames()) {
            if (cm.getPropertySheet(compName).validate()) continue;
            return false;
        }
        return true;
    }

    public static String stripGlobalSymbol(String symbol) {
        Matcher matcher = globalSymbolPattern.matcher(symbol);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return symbol;
    }

    public static void editConfig(ConfigurationManager cm, String name) {
        PropertySheet ps = cm.getPropertySheet(name);
        if (ps == null) {
            System.out.println("No component: " + name);
            return;
        }
        System.out.println(name + ':');
        Collection<String> propertyNames = ps.getRegisteredProperties();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        for (String propertyName : propertyNames) {
            try {
                Object value = ps.getRaw(propertyName);
                if (value instanceof List) continue;
                String svalue = value instanceof String ? (String)value : "DEFAULT";
                boolean done = false;
                while (!done) {
                    System.out.print("  " + propertyName + " [" + svalue + "]: ");
                    String in = br.readLine();
                    if (in.isEmpty()) {
                        done = true;
                        continue;
                    }
                    if (in.equals(".")) {
                        return;
                    }
                    cm.getPropertySheet(name).setRaw(propertyName, in);
                    done = true;
                }
            }
            catch (IOException ioe) {
                System.out.println("Trouble reading input");
                return;
            }
        }
    }

    public static String getLogPrefix(ConfigurationManager cm) {
        if (cm.getConfigURL() != null) {
            return new File(cm.getConfigURL().getFile()).getName().replace(CM_FILE_SUFFIX, "").replace(".xml", "") + '.';
        }
        return "S4CM.";
    }

    public static void configureLogger(ConfigurationManager cm) {
        if (System.getProperty("java.util.logging.config.class") != null || System.getProperty("java.util.logging.config.file") != null) {
            return;
        }
        String cmPrefix = ConfigurationManagerUtils.getLogPrefix(cm);
        Logger cmRootLogger = Logger.getLogger(cmPrefix.substring(0, cmPrefix.length() - 1));
        Level rootLevel = Logger.getLogger("").getLevel();
        ConfigurationManagerUtils.configureLogger(cmRootLogger);
        String level = cm.getGlobalProperty(GLOBAL_COMMON_LOGLEVEL);
        if (level == null) {
            level = Level.WARNING.getName();
        }
        cmRootLogger.setLevel(Level.parse(level));
        Logger.getLogger("").setLevel(rootLevel);
    }

    public static void configureLogger(Logger logger) {
        logger.setUseParentHandlers(false);
        boolean hasHandler = false;
        for (Handler handler : logger.getHandlers()) {
            if (!(handler.getFormatter() instanceof SphinxLogFormatter)) continue;
            hasHandler = true;
            break;
        }
        if (!hasHandler) {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(new SphinxLogFormatter());
            logger.addHandler(handler);
        }
    }

    public static Map<String, String> fixDuplicateNames(ConfigurationManager baseCM, ConfigurationManager subCM) {
        HashMap<String, String> renames = new HashMap<String, String>();
        Iterator<String> i$ = subCM.getComponentNames().iterator();
        while (i$.hasNext()) {
            String compName;
            String uniqueName = compName = i$.next();
            int i = 0;
            while (baseCM.getComponentNames().contains(uniqueName) || subCM.getComponentNames().contains(uniqueName) && !uniqueName.equals(compName)) {
                uniqueName = compName + ++i;
            }
            subCM.renameConfigurable(compName, uniqueName);
            renames.put(compName, uniqueName);
        }
        return renames;
    }

    public static String toXML(ConfigurationManager cm) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        sb.append("\n<!--    Sphinx-4 Configuration file--> \n\n");
        sb.append("<config>");
        Pattern pattern = Pattern.compile("\\$\\{(\\w+)\\}");
        Map<String, String> globalProps = cm.getGlobalProperties();
        for (Map.Entry<String, String> entry : globalProps.entrySet()) {
            String propName = entry.getKey();
            Matcher matcher = pattern.matcher(propName);
            propName = matcher.matches() ? matcher.group(1) : propName;
            sb.append("\n\t<property name=\"").append(propName).append("\" value=\"").append(entry.getValue()).append("\"/>");
        }
        for (String instanceName : cm.getComponentNames()) {
            sb.append("\n\n").append(ConfigurationManagerUtils.propSheet2XML(instanceName, cm.getPropertySheet(instanceName)));
        }
        sb.append("\n</config>");
        return sb.toString();
    }

    private static String propSheet2XML(String instanceName, PropertySheet ps) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t<component name=\"").append(instanceName).append("\" type=\"").append(ps.getConfigurableClass().getName()).append("\">");
        block3: for (String propName : ps.getRegisteredProperties()) {
            String predec = "\n\t\t<property name=\"" + propName + "\" ";
            if (ps.getRawNoReplacement(propName) == null) continue;
            switch (ps.getType(propName)) {
                case COMPONENT_LIST: {
                    sb.append("\n\t\t<propertylist name=\"").append(propName).append("\">");
                    List<String> compNames = ConfigurationManagerUtils.toStringList(ps.getRawNoReplacement(propName));
                    for (String compName : compNames) {
                        sb.append("\n\t\t\t<item>").append(compName).append("</item>");
                    }
                    sb.append("\n\t\t</propertylist>");
                    continue block3;
                }
            }
            sb.append(predec).append("value=\"").append(ps.getRawNoReplacement(propName)).append("\"/>");
        }
        sb.append("\n\t</component>\n\n");
        return sb.toString();
    }

    public static void save(ConfigurationManager cm, File cmLocation) {
        if (!cmLocation.getName().endsWith(CM_FILE_SUFFIX)) {
            System.err.println("WARNING: Serialized s4-configuration should have the suffix '.sxl'");
        }
        assert (cm != null);
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cmLocation), Charset.forName("UTF-8")));
            String configXML = ConfigurationManagerUtils.toXML(cm);
            pw.print(configXML);
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public static void showConfig(ConfigurationManager cm) {
        System.out.println(" ============ config ============= ");
        for (String allName : cm.getInstanceNames(Configurable.class)) {
            ConfigurationManagerUtils.showConfig(cm, allName);
        }
    }

    public static void showConfig(ConfigurationManager cm, String name) {
        if (!cm.getComponentNames().contains(name)) {
            System.out.println("No component: " + name);
            return;
        }
        System.out.println(name + ':');
        PropertySheet properties = cm.getPropertySheet(name);
        for (String propertyName : properties.getRegisteredProperties()) {
            System.out.print("    " + propertyName + " = ");
            Object obj = properties.getRaw(propertyName);
            if (obj instanceof String) {
                System.out.println(obj);
                continue;
            }
            if (obj instanceof List) {
                List l = (List)obj;
                Iterator k = l.iterator();
                while (k.hasNext()) {
                    System.out.print(k.next());
                    if (!k.hasNext()) continue;
                    System.out.print(", ");
                }
                System.out.println();
                continue;
            }
            System.out.println("[DEFAULT]");
        }
    }

    static void applySystemProperties(Map<String, RawPropertyData> rawMap, Map<String, String> global) throws PropertyException {
        Properties props = System.getProperties();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            String value = props.getProperty(param);
            int lb = param.indexOf(91);
            int rb = param.indexOf(93);
            if (lb > 0 && rb > lb) {
                String compName = param.substring(0, lb);
                String paramName = param.substring(lb + 1, rb);
                RawPropertyData rpd = rawMap.get(compName);
                if (rpd != null) {
                    rpd.add(paramName, value);
                    continue;
                }
                throw new InternalConfigurationException(compName, param, "System property attempting to set parameter  for unknown component " + compName + " (" + param + ')');
            }
            if (param.indexOf(46) != -1) continue;
            global.put(param, value);
        }
    }

    static void renameComponent(ConfigurationManager cm, String oldName, String newName) {
        assert (cm != null);
        assert (oldName != null && newName != null);
        if (cm.getPropertySheet(oldName) == null) {
            throw new RuntimeException("no configurable (to be renamed) named " + oldName + " is contained in the CM");
        }
        for (String instanceName : cm.getComponentNames()) {
            PropertySheet propSheet = cm.getPropertySheet(instanceName);
            block5: for (String propName : propSheet.getRegisteredProperties()) {
                if (propSheet.getRawNoReplacement(propName) == null) continue;
                switch (propSheet.getType(propName)) {
                    case COMPONENT_LIST: {
                        List<String> compNames = ConfigurationManagerUtils.toStringList(propSheet.getRawNoReplacement(propName));
                        for (int i = 0; i < compNames.size(); ++i) {
                            String compName = compNames.get(i);
                            if (!compName.equals(oldName)) continue;
                            compNames.set(i, newName);
                        }
                        continue block5;
                    }
                    case COMPONENT: {
                        if (!propSheet.getRawNoReplacement(propName).equals(oldName)) break;
                        propSheet.setRaw(propName, newName);
                    }
                }
            }
        }
        PropertySheet ps = cm.getPropertySheet(oldName);
        ps.setInstanceName(newName);
        for (Map.Entry<String, String> entry : cm.getGlobalProperties().entrySet()) {
            if (!entry.getValue().equals(oldName)) continue;
            cm.setGlobalProperty(entry.getKey(), newName);
        }
    }

    public static URL getResource(String name, PropertySheet ps) throws PropertyException {
        String location = ps.getString(name);
        if (location == null) {
            throw new InternalConfigurationException(ps.getInstanceName(), name, "Required resource property '" + name + "' not set");
        }
        try {
            URL url = ConfigurationManagerUtils.resourceToURL(location);
            if (url == null) {
                throw new InternalConfigurationException(ps.getInstanceName(), name, "Can't locate " + location);
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new InternalConfigurationException(e, ps.getInstanceName(), name, "Bad URL " + location + e.getMessage());
        }
    }

    public static URL resourceToURL(String location) throws MalformedURLException {
        Matcher jarMatcher = jarPattern.matcher(location);
        if (jarMatcher.matches()) {
            String resourceName = jarMatcher.group(1);
            return ConfigurationManagerUtils.class.getResource(resourceName);
        }
        if (location.indexOf(58) == -1) {
            location = "file:" + location;
        }
        return new URL(location);
    }

    public static boolean isDerivedClass(Class<?> derived, Class<?> parent) {
        return parent.isAssignableFrom(derived);
    }

    public static boolean isImplementingInterface(Class<?> aClass, Class<?> interfaceClass) {
        assert (interfaceClass.isInterface());
        Class<?> superClass = aClass.getSuperclass();
        if (superClass != null && ConfigurationManagerUtils.isImplementingInterface(superClass, interfaceClass)) {
            return true;
        }
        for (Class<?> curInterface : aClass.getInterfaces()) {
            if (!curInterface.equals(interfaceClass) && !ConfigurationManagerUtils.isImplementingInterface(curInterface, interfaceClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubClass(Class<?> aClass, Class<?> possibleSuperclass) {
        while (aClass != null && !aClass.equals(Object.class)) {
            if ((aClass = aClass.getSuperclass()) == null || !aClass.equals(possibleSuperclass)) continue;
            return true;
        }
        return false;
    }

    public static ConfigurationManager getPropertyManager(PropertySheet ps) {
        return ps.getPropertyManager();
    }

    public static Map<String, List<PropertySheet>> listAllsPropNames(ConfigurationManager cm) {
        HashMap<String, List<PropertySheet>> allProps = new HashMap<String, List<PropertySheet>>();
        for (String configName : cm.getComponentNames()) {
            PropertySheet ps = cm.getPropertySheet(configName);
            for (String propName : ps.getRegisteredProperties()) {
                if (!allProps.containsKey(propName)) {
                    allProps.put(propName, new ArrayList());
                }
                ((List)allProps.get(propName)).add(ps);
            }
        }
        return allProps;
    }

    public static void dumpPropStructure(ConfigurationManager cm) {
        Map<String, List<PropertySheet>> allProps = ConfigurationManagerUtils.listAllsPropNames(cm);
        System.out.println("Property-structure of '" + cm.getConfigURL() + "':");
        System.out.println("\nUnambiguous properties = ");
        for (Map.Entry<String, List<PropertySheet>> entry : allProps.entrySet()) {
            if (entry.getValue().size() != 1) continue;
            System.out.print(entry.getKey() + ", ");
        }
        System.out.println("\n\nAmbiguous properties: ");
        for (Map.Entry<String, List<PropertySheet>> entry : allProps.entrySet()) {
            if (entry.getValue().size() == 1) continue;
            System.out.print(entry.getKey() + '=');
            for (PropertySheet ps : entry.getValue()) {
                System.out.print(ps.getInstanceName() + ", ");
            }
            System.out.println();
        }
    }

    public static void setProperty(ConfigurationManager cm, String propName, String propValue) {
        String componentName;
        assert (propValue != null);
        Map<String, List<PropertySheet>> allProps = ConfigurationManagerUtils.listAllsPropNames(cm);
        Set<String> configurableNames = cm.getComponentNames();
        if (!(allProps.containsKey(propName) || propName.contains("->") || configurableNames.contains(propName))) {
            throw new RuntimeException("No property or configurable '" + propName + "' in configuration '" + cm.getConfigURL() + "'!");
        }
        if (configurableNames.contains(propName)) {
            try {
                Class<Configurable> confClass = Class.forName(propValue).asSubclass(Configurable.class);
                ConfigurationManagerUtils.setClass(cm.getPropertySheet(propName), confClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (!propName.contains("->") && allProps.get(propName).size() > 1) {
            throw new RuntimeException("Property-name '" + propName + "' is ambiguous with respect to configuration '" + cm.getConfigURL() + "'. Use 'componentName->propName' to disambiguate your request.");
        }
        if (propName.contains("->")) {
            String[] splitProp = propName.split("->");
            componentName = splitProp[0];
            propName = splitProp[1];
        } else {
            componentName = allProps.get(propName).get(0).getInstanceName();
        }
        ConfigurationManagerUtils.setProperty(cm, componentName, propName, propValue);
    }

    public static void setProperty(ConfigurationManager cm, String componentName, String propName, String propValue) {
        PropertySheet ps = cm.getPropertySheet(componentName);
        if (ps == null) {
            throw new RuntimeException("Component '" + propName + "' is not registered to this system configuration '");
        }
        if (propValue.equals("null")) {
            propValue = null;
        }
        switch (ps.getType(propName)) {
            case BOOLEAN: {
                ps.setBoolean(propName, Boolean.parseBoolean(propValue));
                break;
            }
            case DOUBLE: {
                ps.setDouble(propName, Double.parseDouble(propValue));
                break;
            }
            case INT: {
                ps.setInt(propName, Integer.parseInt(propValue));
                break;
            }
            case STRING: {
                ps.setString(propName, propValue);
                break;
            }
            case COMPONENT: {
                ps.setComponent(propName, propValue, null);
                break;
            }
            case COMPONENT_LIST: {
                ArrayList<String> compNames = new ArrayList<String>();
                for (String component : propValue.split(";")) {
                    compNames.add(component.trim());
                }
                ps.setComponentList(propName, compNames, null);
                break;
            }
            default: {
                throw new RuntimeException("unknown property-type");
            }
        }
    }

    public static URL getURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Collection<String> getNonInstaniatedComps(ConfigurationManager cm) {
        ArrayList<String> nonInstComponents = new ArrayList<String>();
        for (String compName : cm.getComponentNames()) {
            if (cm.getPropertySheet(compName).isInstanciated()) continue;
            nonInstComponents.add(compName);
        }
        return nonInstComponents;
    }

    public static void setClass(PropertySheet ps, Class<? extends Configurable> confClass) {
        if (ps.isInstanciated()) {
            throw new RuntimeException("configurable " + ps.getInstanceName() + "has already been instantiated");
        }
        ps.setConfigurableClass(confClass);
    }

    public static List<String> toStringList(Object obj) {
        ArrayList<String> result = new ArrayList<String>();
        if (!(obj instanceof List)) {
            return null;
        }
        for (Object o : (List)obj) {
            if (!(o instanceof String)) continue;
            result.add((String)o);
        }
        return result;
    }
}

