/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationChangeListener;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.InternalConfigurationException;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.RawPropertyData;
import edu.cmu.sphinx.util.props.SaxLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ConfigurationManager
implements Cloneable {
    private List<ConfigurationChangeListener> changeListeners = new ArrayList<ConfigurationChangeListener>();
    private Map<String, PropertySheet> symbolTable = new LinkedHashMap<String, PropertySheet>();
    private Map<String, RawPropertyData> rawPropertyMap = new HashMap<String, RawPropertyData>();
    private Map<String, String> globalProperties = new HashMap<String, String>();
    private boolean showCreations;
    private URL configURL;

    public ConfigurationManager() {
    }

    public ConfigurationManager(String configFileName) throws PropertyException {
        this(ConfigurationManagerUtils.getURL(new File(configFileName)));
    }

    public ConfigurationManager(URL url) throws PropertyException {
        this.configURL = url;
        try {
            this.rawPropertyMap = new SaxLoader(url, this.globalProperties).load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ConfigurationManagerUtils.applySystemProperties(this.rawPropertyMap, this.globalProperties);
        ConfigurationManagerUtils.configureLogger(this);
        String showCreations = this.globalProperties.get("showCreations");
        if (showCreations != null) {
            this.showCreations = "true".equals(showCreations);
        }
    }

    public PropertySheet getPropertySheet(String instanceName) {
        RawPropertyData rpd;
        if (!this.symbolTable.containsKey(instanceName) && (rpd = this.rawPropertyMap.get(instanceName)) != null) {
            String className = rpd.getClassName();
            try {
                Class<?> cls = Class.forName(className);
                PropertySheet propertySheet = new PropertySheet(cls.asSubclass(Configurable.class), instanceName, this, rpd);
                this.symbolTable.put(instanceName, propertySheet);
            }
            catch (ClassNotFoundException e) {
                System.err.println("class not found !" + e);
            }
            catch (ClassCastException e) {
                System.err.println("can not cast class !" + e);
            }
            catch (ExceptionInInitializerError e) {
                System.err.println("couldn't load class !" + e);
            }
        }
        return this.symbolTable.get(instanceName);
    }

    public Collection<String> getInstanceNames(Class<? extends Configurable> type) {
        ArrayList<String> instanceNames = new ArrayList<String>();
        for (PropertySheet ps : this.symbolTable.values()) {
            if (!ps.isInstanciated() || !ConfigurationManagerUtils.isDerivedClass(ps.getConfigurableClass(), type)) continue;
            instanceNames.add(ps.getInstanceName());
        }
        return instanceNames;
    }

    public Set<String> getComponentNames() {
        return this.rawPropertyMap.keySet();
    }

    public <C extends Configurable> C lookup(String instanceName) throws InternalConfigurationException {
        PropertySheet ps = this.getPropertySheet(instanceName = this.getStrippedComponentName(instanceName));
        if (ps == null) {
            return null;
        }
        if (this.showCreations) {
            this.getRootLogger().config("Creating: " + instanceName);
        }
        return (C)ps.getOwner();
    }

    public <C extends Configurable> C lookup(Class<C> confClass) {
        List<PropertySheet> matchPropSheets = this.getPropSheets(confClass);
        if (matchPropSheets.isEmpty()) {
            return null;
        }
        assert (matchPropSheets.size() == 1);
        return (C)((Configurable)confClass.cast(this.lookup(matchPropSheets.get(0).getInstanceName())));
    }

    public List<PropertySheet> getPropSheets(Class<? extends Configurable> confClass) {
        ArrayList<PropertySheet> psCol = new ArrayList<PropertySheet>();
        for (PropertySheet ps : this.symbolTable.values()) {
            if (!ConfigurationManagerUtils.isDerivedClass(ps.getConfigurableClass(), confClass)) continue;
            psCol.add(ps);
        }
        return psCol;
    }

    public void addConfigurable(Class<? extends Configurable> confClass, String name) {
        this.addConfigurable(confClass, name, new HashMap<String, Object>());
    }

    public void addConfigurable(Class<? extends Configurable> confClass, String name, Map<String, Object> props) {
        if (name == null) {
            name = confClass.getName();
        }
        if (this.symbolTable.containsKey(name)) {
            throw new IllegalArgumentException("tried to override existing component name : " + name);
        }
        PropertySheet ps = ConfigurationManager.getPropSheetInstanceFromClass(confClass, props, name, this);
        this.symbolTable.put(name, ps);
        this.rawPropertyMap.put(name, new RawPropertyData(name, confClass.getName()));
        for (ConfigurationChangeListener changeListener : this.changeListeners) {
            changeListener.componentAdded(this, ps);
        }
    }

    public void addConfigurable(Configurable configurable, String name) {
        if (this.symbolTable.containsKey(name)) {
            throw new IllegalArgumentException("tried to override existing component name");
        }
        RawPropertyData dummyRPD = new RawPropertyData(name, configurable.getClass().getName());
        PropertySheet ps = new PropertySheet(configurable, name, dummyRPD, this);
        this.symbolTable.put(name, ps);
        this.rawPropertyMap.put(name, dummyRPD);
        for (ConfigurationChangeListener changeListener : this.changeListeners) {
            changeListener.componentAdded(this, ps);
        }
    }

    public void renameConfigurable(String oldName, String newName) {
        PropertySheet ps = this.getPropertySheet(oldName);
        if (ps == null) {
            throw new RuntimeException("no configurable (to be renamed) named " + oldName + " is contained in the CM");
        }
        ConfigurationManagerUtils.renameComponent(this, oldName, newName);
        this.symbolTable.remove(oldName);
        this.symbolTable.put(newName, ps);
        RawPropertyData rpd = this.rawPropertyMap.remove(oldName);
        this.rawPropertyMap.put(newName, new RawPropertyData(newName, rpd.getClassName(), rpd.getProperties()));
        this.fireRenamedConfigurable(oldName, newName);
    }

    public void removeConfigurable(String name) {
        assert (this.getComponentNames().contains(name));
        PropertySheet ps = this.symbolTable.remove(name);
        this.rawPropertyMap.remove(name);
        for (ConfigurationChangeListener changeListener : this.changeListeners) {
            changeListener.componentRemoved(this, ps);
        }
    }

    public void addSubConfiguration(ConfigurationManager subCM) {
        this.addSubConfiguration(subCM, false);
    }

    public void addSubConfiguration(ConfigurationManager subCM, boolean doOverrideComponents) {
        Set<String> compNames = this.getComponentNames();
        for (String componentName : subCM.getComponentNames()) {
            if (!compNames.contains(componentName)) continue;
            if (doOverrideComponents && !this.getPropertySheet(componentName).isInstanciated()) {
                PropertySheet ps = subCM.getPropertySheet(componentName);
                this.symbolTable.put(componentName, ps);
                this.rawPropertyMap.put(componentName, new RawPropertyData(componentName, ps.getConfigurableClass().getSimpleName()));
                continue;
            }
            throw new RuntimeException(componentName + " is already registered to system configuration");
        }
        for (String globProp : subCM.globalProperties.keySet()) {
            if (!this.globalProperties.containsKey(globProp) || System.getProperties().containsKey(globProp) || doOverrideComponents) continue;
            throw new RuntimeException(globProp + " is already registered as global property");
        }
        this.globalProperties.putAll(subCM.globalProperties);
        for (PropertySheet ps : subCM.symbolTable.values()) {
            ps.setCM(this);
        }
        this.symbolTable.putAll(subCM.symbolTable);
        this.rawPropertyMap.putAll(subCM.rawPropertyMap);
    }

    public Map<String, String> getGlobalProperties() {
        return new HashMap<String, String>(this.globalProperties);
    }

    public String getGlobalProperty(String propertyName) {
        String globProp = this.globalProperties.get(propertyName);
        return globProp != null ? globProp.toString() : null;
    }

    public String getGloPropReference(String propertyName) {
        return this.globalProperties.get(propertyName);
    }

    public URL getConfigURL() {
        return this.configURL;
    }

    public void setGlobalProperty(String propertyName, String value) {
        if (value == null) {
            this.globalProperties.remove(propertyName);
        } else {
            this.globalProperties.put(propertyName, value);
        }
        for (String instanceName : this.getInstanceNames(Configurable.class)) {
            PropertySheet ps = this.getPropertySheet(instanceName);
            if (!ps.isInstanciated()) continue;
            try {
                ps.getOwner().newProperties(ps);
            }
            catch (PropertyException e) {
                e.printStackTrace();
            }
        }
    }

    public String getStrippedComponentName(String propertyName) {
        assert (propertyName != null);
        while (propertyName.startsWith("$")) {
            propertyName = this.globalProperties.get(ConfigurationManagerUtils.stripGlobalSymbol(propertyName)).toString();
        }
        return propertyName;
    }

    public void addConfigurationChangeListener(ConfigurationChangeListener l) {
        if (l == null) {
            return;
        }
        this.changeListeners.add(l);
    }

    public void removeConfigurationChangeListener(ConfigurationChangeListener l) {
        if (l == null) {
            return;
        }
        this.changeListeners.remove(l);
    }

    void fireConfChanged(String configurableName, String propertyName) {
        assert (this.getComponentNames().contains(configurableName));
        for (ConfigurationChangeListener changeListener : this.changeListeners) {
            changeListener.configurationChanged(configurableName, propertyName, this);
        }
    }

    void fireRenamedConfigurable(String oldName, String newName) {
        assert (this.getComponentNames().contains(newName));
        for (ConfigurationChangeListener changeListener : this.changeListeners) {
            changeListener.componentRenamed(this, this.getPropertySheet(newName), oldName);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfigurationManager)) {
            return false;
        }
        ConfigurationManager cm = (ConfigurationManager)obj;
        Set<String> thisCompNames = this.getComponentNames();
        if (!thisCompNames.equals(cm.getComponentNames())) {
            return false;
        }
        for (String instanceName : thisCompNames) {
            PropertySheet myPropSheet = this.getPropertySheet(instanceName);
            PropertySheet otherPropSheet = cm.getPropertySheet(instanceName);
            if (otherPropSheet.equals(myPropSheet)) continue;
            return false;
        }
        return cm.getGlobalProperties().equals(this.getGlobalProperties());
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 1;
    }

    public ConfigurationManager clone() throws CloneNotSupportedException {
        ConfigurationManager cloneCM = (ConfigurationManager)super.clone();
        cloneCM.changeListeners = new ArrayList<ConfigurationChangeListener>();
        cloneCM.symbolTable = new LinkedHashMap<String, PropertySheet>();
        for (Map.Entry<String, PropertySheet> entry : this.symbolTable.entrySet()) {
            cloneCM.symbolTable.put(entry.getKey(), entry.getValue().clone());
        }
        cloneCM.globalProperties = new HashMap<String, String>(this.globalProperties);
        cloneCM.rawPropertyMap = new HashMap<String, RawPropertyData>(this.rawPropertyMap);
        return cloneCM;
    }

    public static <C extends Configurable> C getInstance(Class<C> targetClass) throws PropertyException {
        return ConfigurationManager.getInstance(targetClass, new HashMap<String, Object>());
    }

    public static <C extends Configurable> C getInstance(Class<C> targetClass, Map<String, Object> props) throws PropertyException {
        return ConfigurationManager.getInstance(targetClass, props, null);
    }

    public static <C extends Configurable> C getInstance(Class<C> targetClass, Map<String, Object> props, String compName) throws PropertyException {
        PropertySheet ps = ConfigurationManager.getPropSheetInstanceFromClass(targetClass, props, compName, new ConfigurationManager());
        Configurable configurable = ps.getOwner();
        return (C)((Configurable)targetClass.cast(configurable));
    }

    private static PropertySheet getPropSheetInstanceFromClass(Class<? extends Configurable> targetClass, Map<String, Object> defaultProps, String componentName, ConfigurationManager cm) {
        RawPropertyData rpd = new RawPropertyData(componentName, targetClass.getName());
        for (Map.Entry<String, Object> entry : defaultProps.entrySet()) {
            Object property = entry.getValue();
            if (property instanceof Class) {
                property = ((Class)property).getName();
            }
            rpd.getProperties().put(entry.getKey(), property);
        }
        return new PropertySheet(targetClass, componentName, cm, rpd);
    }

    public Logger getRootLogger() {
        return Logger.getLogger(ConfigurationManagerUtils.getLogPrefix(this));
    }
}

