/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.ReferenceSource;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class FileReferenceSource
implements ReferenceSource {
    private final List<String> references = new LinkedList<String>();

    public FileReferenceSource(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(";;")) continue;
            int fromIndex = 0;
            boolean isSilence = false;
            for (int i = 0; i < 6; ++i) {
                String type;
                if (i == 2 && (type = line.substring(fromIndex)).startsWith("inter_segment_gap")) {
                    isSilence = true;
                    break;
                }
                fromIndex = line.indexOf(32, fromIndex) + 1;
            }
            if (isSilence) continue;
            String reference = line.substring(fromIndex).trim();
            this.references.add(reference);
        }
        reader.close();
    }

    @Override
    public List<String> getReferences() {
        return this.references;
    }
}

