/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

public class Complex {
    private double real;
    private double imaginary;

    public Complex() {
        this.reset();
    }

    public Complex(double real) {
        this.set(real, 0.0);
    }

    public Complex(double real, double imaginary) {
        this.set(real, imaginary);
    }

    public double getReal() {
        return this.real;
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public void reset() {
        this.real = 0.0;
        this.imaginary = 0.0;
    }

    public void set(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public void addComplex(Complex a, Complex b) {
        this.real = a.real + b.real;
        this.imaginary = a.imaginary + b.imaginary;
    }

    public void subtractComplex(Complex a, Complex b) {
        this.real = a.real - b.real;
        this.imaginary = a.imaginary - b.imaginary;
    }

    public void multiplyComplex(Complex a, Complex b) {
        this.real = a.real * b.real - a.imaginary * b.imaginary;
        this.imaginary = a.real * b.imaginary + a.imaginary * b.real;
    }

    public void divideComplex(Complex a, Complex b) {
        this.real = a.real * b.real + a.imaginary * b.imaginary;
        this.imaginary = a.imaginary * b.real - a.real * b.imaginary;
        this.scaleComplex(this, b.squaredMagnitudeComplex());
    }

    public void scaleComplex(Complex a, double b) {
        this.real = a.real / b;
        this.imaginary = a.imaginary / b;
    }

    public double squaredMagnitudeComplex() {
        double squaredMag = this.real * this.real + this.imaginary * this.imaginary;
        return squaredMag;
    }

    public String toString() {
        return "(" + this.real + ", " + this.imaginary + ')';
    }
}

