/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.TextDictionary;
import edu.cmu.sphinx.trainer.Graph;
import edu.cmu.sphinx.trainer.Node;
import edu.cmu.sphinx.trainer.NodeType;

public class TrainerDictionary
extends TextDictionary {
    static final String UTTERANCE_BEGIN_SYMBOL = "<s>";
    static final String UTTERANCE_END_SYMBOL = "</s>";
    static final String SILENCE_SYMBOL = "SIL";

    public Graph getWordGraph(String word, boolean hasDummy) {
        Node prevNode;
        Graph wordGraph = new Graph();
        Node wordNode = null;
        int pronunciationID = 0;
        String wordWithoutParentheses = word.replaceFirst("\\(.*\\)", "");
        if (word.equals(wordWithoutParentheses)) {
            pronunciationID = 0;
        } else {
            String number = word.replaceFirst(".*\\(", "").replaceFirst("\\)", "");
            try {
                pronunciationID = Integer.parseInt(number);
            }
            catch (NumberFormatException nfe) {
                throw new Error("Word with invalid pronunciation ID", nfe);
            }
        }
        Pronunciation[] pronunciations = this.getWord(wordWithoutParentheses).getPronunciations();
        if (pronunciations == null) {
            System.out.println("Pronunciation not found for word " + wordWithoutParentheses);
            return null;
        }
        if (pronunciationID >= pronunciations.length) {
            System.out.println("Dictionary has only " + pronunciations.length + " for word " + word);
            return null;
        }
        Unit[] units = pronunciations[pronunciationID].getUnits();
        assert (units != null) : "units is empty: problem with dictionary?";
        if (hasDummy) {
            Node initialNode = new Node(NodeType.DUMMY);
            wordGraph.addNode(initialNode);
            wordGraph.setInitialNode(initialNode);
            prevNode = initialNode;
        } else {
            prevNode = null;
        }
        for (Unit unit : units) {
            wordNode = new Node(NodeType.PHONE, unit.getName());
            if (prevNode == null) {
                wordGraph.addNode(wordNode);
                wordGraph.setInitialNode(wordNode);
            } else {
                wordGraph.linkNodes(prevNode, wordNode);
            }
            prevNode = wordNode;
        }
        if (hasDummy) {
            wordNode = new Node(NodeType.DUMMY);
            wordGraph.linkNodes(prevNode, wordNode);
        }
        assert (wordNode != null);
        wordGraph.setFinalNode(wordNode);
        return wordGraph;
    }

    @Override
    public String toString() {
        return "DEFAULT";
    }
}

