/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.TrainerAcousticModel;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.TrainerScore;
import edu.cmu.sphinx.trainer.ControlFile;
import edu.cmu.sphinx.trainer.Learner;
import edu.cmu.sphinx.trainer.TrainManager;
import edu.cmu.sphinx.trainer.Utterance;
import edu.cmu.sphinx.trainer.UtteranceHMMGraph;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.io.IOException;
import java.util.List;

public class SimpleTrainManager
implements TrainManager {
    @S4Component(type=ControlFile.class)
    public static final String CONTROL_FILE = "control";
    private ControlFile controlFile;
    private boolean dumpMemoryInfo;
    @S4Component(type=Learner.class)
    public static final String LEARNER = "learner";
    private Learner learner;
    @S4Component(type=Learner.class)
    public static final String INIT_LEARNER = "initLearner";
    private Learner initLearner;
    @S4Component(type=UnitManager.class)
    public static final String UNIT_MANAGER = "unitManager";
    private UnitManager unitManager;
    @S4ComponentList(type=TrainerAcousticModel.class)
    public static final String AM_COLLECTION = "models";
    private List<? extends TrainerAcousticModel> acousticModels;
    @S4Boolean(defaultValue=false)
    public static final String DUMP_MEMORY_INFO = "dumpMemoryInfo";
    private int maxIteration;
    private float minimumImprovement;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.dumpMemoryInfo = ps.getBoolean(DUMP_MEMORY_INFO);
        this.learner = (Learner)ps.getComponent(LEARNER);
        this.controlFile = (ControlFile)ps.getComponent(CONTROL_FILE);
        this.initLearner = (Learner)ps.getComponent(INIT_LEARNER);
        this.minimumImprovement = ps.getFloat("minimumImprovement");
        this.maxIteration = ps.getInt("maximumIteration");
        this.acousticModels = ps.getComponentList(AM_COLLECTION, TrainerAcousticModel.class);
        this.unitManager = (UnitManager)ps.getComponent(UNIT_MANAGER);
    }

    @Override
    public void train() {
        assert (this.controlFile != null);
        this.controlFile.startUtteranceIterator();
        while (this.controlFile.hasMoreUtterances()) {
            Utterance utterance = this.controlFile.nextUtterance();
            System.out.println(utterance);
            utterance.startTranscriptIterator();
            while (utterance.hasMoreTranscripts()) {
                System.out.println(utterance.nextTranscript());
            }
        }
    }

    @Override
    public void copyModels(String context) throws IOException {
        this.loadModels(context);
        this.saveModels(context);
    }

    @Override
    public void saveModels(String context) throws IOException {
        if (1 == this.acousticModels.size()) {
            this.acousticModels.get(0).save(null);
        } else {
            for (AcousticModel acousticModel : this.acousticModels) {
                if (!(acousticModel instanceof TrainerAcousticModel)) continue;
                TrainerAcousticModel tmodel = (TrainerAcousticModel)acousticModel;
                tmodel.save(acousticModel.getName());
            }
        }
    }

    private void loadModels(String context) throws IOException {
        this.dumpMemoryInfo("TrainManager start");
        for (TrainerAcousticModel trainerAcousticModel : this.acousticModels) {
            trainerAcousticModel.load();
        }
        this.dumpMemoryInfo("acoustic model");
    }

    @Override
    public void initializeModels(String context) throws IOException {
        this.dumpMemoryInfo("TrainManager start");
        for (TrainerAcousticModel trainerAcousticModel : this.acousticModels) {
            this.controlFile.startUtteranceIterator();
            while (this.controlFile.hasMoreUtterances()) {
                TrainerScore[] score;
                Utterance utterance = this.controlFile.nextUtterance();
                this.initLearner.setUtterance(utterance);
                while ((score = this.initLearner.getScore()) != null) {
                    assert (score.length == 1);
                    trainerAcousticModel.accumulate(0, score);
                }
            }
            trainerAcousticModel.normalize();
        }
        this.dumpMemoryInfo("acoustic model");
    }

    @Override
    public void trainContextIndependentModels(String context) throws IOException {
        if (this.learner == null) {
            this.loadModels(context);
        }
        this.dumpMemoryInfo("TrainManager start");
        for (TrainerAcousticModel trainerAcousticModel : this.acousticModels) {
            float lastLogLikelihood = Float.MAX_VALUE;
            float relativeImprovement = 100.0f;
            for (int iteration = 0; iteration < this.maxIteration && relativeImprovement > this.minimumImprovement; ++iteration) {
                System.out.println("Iteration: " + iteration);
                trainerAcousticModel.resetBuffers();
                this.controlFile.startUtteranceIterator();
                while (this.controlFile.hasMoreUtterances()) {
                    TrainerScore[] score;
                    Utterance utterance = this.controlFile.nextUtterance();
                    UtteranceHMMGraph uttGraph = new UtteranceHMMGraph(context, utterance, trainerAcousticModel, this.unitManager);
                    this.learner.setUtterance(utterance);
                    this.learner.setGraph(uttGraph);
                    TrainerScore[] nextScore = null;
                    while ((score = this.learner.getScore()) != null) {
                        for (int i = 0; i < score.length; ++i) {
                            if (i > 0) {
                                trainerAcousticModel.accumulate(i, score, nextScore);
                                continue;
                            }
                            trainerAcousticModel.accumulate(i, score);
                        }
                        nextScore = score;
                    }
                    trainerAcousticModel.updateLogLikelihood();
                }
                float logLikelihood = trainerAcousticModel.normalize();
                System.out.println("Loglikelihood: " + logLikelihood);
                this.saveModels(context);
                if (iteration > 0) {
                    if (lastLogLikelihood != 0.0f) {
                        relativeImprovement = (logLikelihood - lastLogLikelihood) / lastLogLikelihood * 100.0f;
                    } else if (lastLogLikelihood == logLikelihood) {
                        relativeImprovement = 0.0f;
                    }
                    System.out.println("Finished iteration: " + iteration + " - Improvement: " + relativeImprovement);
                }
                lastLogLikelihood = logLikelihood;
            }
        }
    }

    private void dumpMemoryInfo(String what) {
        if (this.dumpMemoryInfo) {
            Utilities.dumpMemoryInfo(what);
        }
    }
}

