/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.trainer.Edge;
import edu.cmu.sphinx.trainer.NodeType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Node {
    private String nodeId;
    private Object object;
    private NodeType nodeType;
    private List<Edge> incomingEdges = new ArrayList<Edge>();
    private Iterator<Edge> incomingEdgeIterator;
    private List<Edge> outgoingEdges = new ArrayList<Edge>();
    private Iterator<Edge> outgoingEdgeIterator;

    Node(NodeType nodeType, String nodeSymbol) {
        this.nodeId = nodeSymbol;
        this.nodeType = nodeType;
        this.object = null;
    }

    Node(NodeType nodeType) {
        this(nodeType, null);
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void addIncomingEdge(Edge edge) {
        this.incomingEdges.add(edge);
    }

    public void startIncomingEdgeIterator() {
        this.incomingEdgeIterator = this.incomingEdges.iterator();
    }

    public boolean hasMoreIncomingEdges() {
        return this.incomingEdgeIterator.hasNext();
    }

    public Edge nextIncomingEdge() {
        return this.incomingEdgeIterator.next();
    }

    public int incomingEdgesSize() {
        return this.incomingEdges.size();
    }

    public void addOutgoingEdge(Edge edge) {
        this.outgoingEdges.add(edge);
    }

    public void startOutgoingEdgeIterator() {
        this.outgoingEdgeIterator = this.outgoingEdges.iterator();
    }

    public boolean hasMoreOutgoingEdges() {
        return this.outgoingEdgeIterator.hasNext();
    }

    public Edge nextOutgoingEdge() {
        return this.outgoingEdgeIterator.next();
    }

    public int outgoingEdgesSize() {
        return this.outgoingEdges.size();
    }

    public boolean isType(String type) {
        return type.equals(this.nodeType.toString());
    }

    public NodeType getType() {
        return this.nodeType;
    }

    public String getID() {
        return this.nodeId;
    }

    public boolean validate() {
        boolean passed = true;
        if ((this.isType("WORD") || this.isType("PHONE")) && this.nodeId == null) {
            System.out.println("Content null in a WORD node.");
            passed = false;
        }
        if (this.incomingEdgesSize() == 0 && this.outgoingEdgesSize() == 0) {
            System.out.println("Node not connected anywhere.");
            passed = false;
        }
        return passed;
    }

    public void print() {
        System.out.print("ID: " + this.nodeId);
        System.out.print(" Type: " + this.nodeType + " | ");
        this.startIncomingEdgeIterator();
        while (this.hasMoreIncomingEdges()) {
            System.out.print(this.nextIncomingEdge() + " ");
        }
        System.out.print(" | ");
        this.startOutgoingEdgeIterator();
        while (this.hasMoreOutgoingEdges()) {
            System.out.print(this.nextOutgoingEdge() + " ");
        }
        System.out.println();
    }
}

