/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.feature;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertyException;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Logger;

public class FeatureFileDumper {
    private FrontEnd frontEnd;
    private StreamDataSource audioSource;
    private List<float[]> allFeatures;
    private int featureLength = -1;
    private static final Logger logger = Logger.getLogger("edu.cmu.sphinx.tools.feature.FeatureFileDumper");

    public FeatureFileDumper(ConfigurationManager cm, String frontEndName) throws IOException {
        try {
            this.frontEnd = (FrontEnd)cm.lookup(frontEndName);
            this.audioSource = (StreamDataSource)cm.lookup("streamDataSource");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processFile(String inputAudioFile) throws FileNotFoundException {
        this.audioSource.setInputStream(new FileInputStream(inputAudioFile));
        this.allFeatures = new LinkedList<float[]>();
        this.getAllFeatures();
        logger.info("Frames: " + this.allFeatures.size());
    }

    private void getAllFeatures() {
        try {
            assert (this.allFeatures != null);
            Data feature = this.frontEnd.getData();
            while (!(feature instanceof DataEndSignal)) {
                Object[] featureData;
                if (feature instanceof DoubleData) {
                    featureData = ((DoubleData)feature).getValues();
                    if (this.featureLength < 0) {
                        this.featureLength = featureData.length;
                        logger.info("Feature length: " + this.featureLength);
                    }
                    float[] convertedData = new float[featureData.length];
                    for (int i = 0; i < featureData.length; ++i) {
                        convertedData[i] = (float)featureData[i];
                    }
                    this.allFeatures.add(convertedData);
                } else if (feature instanceof FloatData) {
                    featureData = ((FloatData)feature).getValues();
                    if (this.featureLength < 0) {
                        this.featureLength = featureData.length;
                        logger.info("Feature length: " + this.featureLength);
                    }
                    this.allFeatures.add((float[])featureData);
                }
                feature = this.frontEnd.getData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getNumberDataPoints() {
        return this.allFeatures.size() * this.featureLength;
    }

    public void dumpBinary(String outputFile) throws IOException {
        DataOutputStream outStream = new DataOutputStream(new FileOutputStream(outputFile));
        outStream.writeInt(this.getNumberDataPoints());
        for (float[] feature : this.allFeatures) {
            for (float val : feature) {
                outStream.writeFloat(val);
            }
        }
        outStream.close();
    }

    public void dumpAscii(String outputFile) throws IOException {
        PrintStream ps = new PrintStream(new FileOutputStream(outputFile), true);
        ps.print(this.getNumberDataPoints());
        ps.print(' ');
        for (float[] feature : this.allFeatures) {
            for (float val : feature) {
                ps.print(val);
                ps.print(' ');
            }
        }
        ps.close();
    }

    public static void main(String[] argv) {
        String configFile = null;
        String frontEndName = null;
        String inputFile = null;
        String inputCtl = null;
        String outputFile = null;
        String format = "binary";
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-c")) {
                configFile = argv[++i];
            }
            if (argv[i].equals("-name")) {
                frontEndName = argv[++i];
            }
            if (argv[i].equals("-i")) {
                inputFile = argv[++i];
            }
            if (argv[i].equals("-ctl")) {
                inputCtl = argv[++i];
            }
            if (argv[i].equals("-o")) {
                outputFile = argv[++i];
            }
            if (!argv[i].equals("-format")) continue;
            format = argv[++i];
        }
        if (frontEndName == null || inputFile == null && inputCtl == null || outputFile == null || format == null) {
            System.out.println("Usage: FeatureFileDumper [ -config configFile ] -name frontendName < -i input File -o outputFile | -ctl inputFile -i inputFolder -o outputFolder >\nPossible frontends are: cepstraFrontEnd, spectraFrontEnd, plpFrontEnd");
            System.exit(1);
        }
        logger.info("Input file: " + inputFile);
        logger.info("Output file: " + outputFile);
        logger.info("Format: " + format);
        try {
            URL url = configFile != null ? new File(configFile).toURI().toURL() : FeatureFileDumper.class.getResource("frontend.config.xml");
            ConfigurationManager cm = new ConfigurationManager(url);
            if (cm.lookup(frontEndName) == null) {
                throw new RuntimeException("No such frontend: " + frontEndName);
            }
            FeatureFileDumper dumper = new FeatureFileDumper(cm, frontEndName);
            if (inputCtl == null) {
                dumper.processFile(inputFile, outputFile, format);
            } else {
                dumper.processCtl(inputCtl, inputFile, outputFile, format);
            }
        }
        catch (IOException ioe) {
            System.err.println("I/O Error " + ioe);
        }
        catch (PropertyException p) {
            System.err.println("Bad configuration " + p);
        }
    }

    private void processFile(String inputFile, String outputFile, String format) throws MalformedURLException, IOException {
        this.processFile(inputFile);
        if (format.equals("binary")) {
            this.dumpBinary(outputFile);
        } else if (format.equals("ascii")) {
            this.dumpAscii(outputFile);
        } else {
            System.out.println("ERROR: unknown output format: " + format);
        }
    }

    private void processCtl(String inputCtl, String inputFolder, String outputFolder, String format) throws MalformedURLException, IOException {
        Scanner scanner = new Scanner(new File(inputCtl));
        while (scanner.hasNext()) {
            String fileName = scanner.next();
            String inputFile = inputFolder + "/" + fileName + ".wav";
            String outputFile = outputFolder + "/" + fileName + ".mfc";
            this.processFile(inputFile);
            if (format.equals("binary")) {
                this.dumpBinary(outputFile);
                continue;
            }
            if (format.equals("ascii")) {
                this.dumpAscii(outputFile);
                continue;
            }
            System.out.println("ERROR: unknown output format: " + format);
        }
        scanner.close();
    }
}

