/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.batch;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.util.StreamCepstrumSource;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.frontend.util.StreamHTKCepstrum;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.BatchItem;
import edu.cmu.sphinx.util.BatchManager;
import edu.cmu.sphinx.util.CommandInterface;
import edu.cmu.sphinx.util.CommandInterpreter;
import edu.cmu.sphinx.util.PooledBatchManager;
import edu.cmu.sphinx.util.SimpleBatchManager;
import edu.cmu.sphinx.util.StatisticsVariable;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class BatchModeRecognizer
implements Configurable {
    @S4Integer(defaultValue=0)
    public static final String PROP_SKIP = "skip";
    @S4Integer(defaultValue=1000000)
    public static final String PROP_COUNT = "count";
    @S4Integer(defaultValue=0)
    public static final String PROP_WHICH_BATCH = "whichBatch";
    @S4Integer(defaultValue=1)
    public static final String PROP_TOTAL_BATCHES = "totalBatches";
    @S4Boolean(defaultValue=false)
    public static final String PROP_USE_POOLED_BATCH_MANAGER = "usePooledBatchManager";
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4ComponentList(type=BaseDataProcessor.class)
    public static final String PROP_INPUT_DATA_PROCESSORS = "inputDataProcessors";
    protected String name;
    protected List<DataProcessor> inputDataProcessors;
    protected int skip;
    protected int utteranceId;
    protected int whichBatch;
    protected int totalBatches;
    protected boolean usePooledBatchManager;
    protected BatchManager batchManager;
    protected Recognizer recognizer;
    protected Logger logger;
    protected BatchItem curBatchItem;
    protected ConfigurationManager cm;
    int count;

    public BatchModeRecognizer(Recognizer recognizer, List<DataProcessor> inputDataProcessors, int skip, int utteranceId, int whichBatch, int totalBatches, boolean usePooledBatchManager) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.cm = null;
        this.skip = skip;
        this.utteranceId = utteranceId;
        this.whichBatch = whichBatch;
        this.totalBatches = totalBatches;
        this.usePooledBatchManager = usePooledBatchManager;
        this.recognizer = recognizer;
        this.inputDataProcessors = inputDataProcessors;
    }

    public BatchModeRecognizer() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.cm = ConfigurationManagerUtils.getPropertyManager(ps);
        this.skip = ps.getInt(PROP_SKIP);
        this.utteranceId = ps.getInt(PROP_COUNT);
        if (this.utteranceId <= 0) {
            this.utteranceId = Integer.MAX_VALUE;
        }
        this.whichBatch = ps.getInt(PROP_WHICH_BATCH);
        this.totalBatches = ps.getInt(PROP_TOTAL_BATCHES);
        this.usePooledBatchManager = ps.getBoolean(PROP_USE_POOLED_BATCH_MANAGER);
        this.recognizer = (Recognizer)ps.getComponent(PROP_RECOGNIZER);
        this.inputDataProcessors = ps.getComponentList(PROP_INPUT_DATA_PROCESSORS, DataProcessor.class);
    }

    public void setBatchFile(String batchFile) throws IOException {
        this.batchManager = this.usePooledBatchManager ? new PooledBatchManager(batchFile, this.skip) : new SimpleBatchManager(batchFile, this.skip, this.whichBatch, this.totalBatches);
    }

    public void decode(String batchFile) throws IOException {
        int count;
        try {
            BatchItem batchItem;
            this.recognizer.allocate();
            this.setBatchFile(batchFile);
            this.batchManager.start();
            this.logger.info("BatchDecoder: decoding files in " + this.batchManager.getFilename());
            for (count = 0; count < this.utteranceId && (batchItem = this.batchManager.getNextItem()) != null; ++count) {
                this.setInputStream(batchItem.getFilename());
                Result result = this.recognizer.recognize(batchItem.getTranscript());
                this.logger.info("File  : " + batchItem.getFilename());
                this.logger.info("Result: " + result);
            }
            this.batchManager.stop();
            this.recognizer.deallocate();
        }
        catch (IOException io) {
            this.logger.severe("I/O error during decoding: " + io.getMessage());
            throw io;
        }
        this.logger.info("BatchDecoder: " + count + " files decoded");
    }

    void setInputStream(String filename) throws IOException {
        for (DataProcessor dataSource : this.inputDataProcessors) {
            InputStream is;
            block5: {
                try {
                    File file = new File(filename);
                    this.logger.info(AudioSystem.getAudioFileFormat(file).toString());
                    is = AudioSystem.getAudioInputStream(file);
                }
                catch (UnsupportedAudioFileException uafe) {
                    this.logger.info("Reading " + filename + " as raw audio file.");
                    is = new FileInputStream(filename);
                    if (!filename.toLowerCase().endsWith(".sph")) break block5;
                    this.logger.info("Skipping 1024-byte Sphere header.");
                    is.skip(1024L);
                }
            }
            if (dataSource instanceof StreamDataSource) {
                ((StreamDataSource)dataSource).setInputStream(is);
                continue;
            }
            if (dataSource instanceof StreamCepstrumSource) {
                boolean isBigEndian = Utilities.isCepstraFileBigEndian(filename);
                StreamCepstrumSource cepstrumSource = (StreamCepstrumSource)dataSource;
                cepstrumSource.setInputStream(is, isBigEndian);
                continue;
            }
            if (!(dataSource instanceof StreamHTKCepstrum)) continue;
            StreamHTKCepstrum cepstrumSource = (StreamHTKCepstrum)dataSource;
            cepstrumSource.setInputStream(is);
        }
    }

    void addCommands(CommandInterpreter ci) {
        ci.add("ls", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length != 1) {
                    ci.putResponse("Usage: ls");
                } else {
                    for (String name : BatchModeRecognizer.this.cm.getInstanceNames(Configurable.class)) {
                        ci.putResponse(name);
                    }
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "list active components";
            }
        });
        ci.add("show", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length < 2) {
                    ConfigurationManagerUtils.showConfig(BatchModeRecognizer.this.cm);
                } else {
                    for (int i = 1; i < args.length; ++i) {
                        String name = args[i];
                        ConfigurationManagerUtils.showConfig(BatchModeRecognizer.this.cm, name);
                    }
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "show component configuration";
            }
        });
        ci.add("edit", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length != 2) {
                    ci.putResponse("Usage: edit component");
                } else {
                    try {
                        ConfigurationManagerUtils.editConfig(BatchModeRecognizer.this.cm, args[1]);
                    }
                    catch (Exception e) {
                        ci.putResponse("Failed to save " + e);
                    }
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "edit a  component's configuration";
            }
        });
        ci.add("save", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length != 2) {
                    ci.putResponse("Usage: save filename.xml");
                } else {
                    ConfigurationManagerUtils.save(BatchModeRecognizer.this.cm, new File(args[1]));
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "save configuration to a file";
            }
        });
        ci.add("set", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length != 4) {
                    ci.putResponse("Usage: set component property value");
                } else {
                    ConfigurationManagerUtils.setProperty(BatchModeRecognizer.this.cm, args[1], args[3], args[2]);
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "set component property to a given value";
            }
        });
        ci.add("recognize", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                Result result = null;
                if (args.length < 2) {
                    ci.putResponse("Usage: recognize audio [transcript]");
                } else {
                    String audioFile = args[1];
                    String transcript = null;
                    if (args.length > 2) {
                        transcript = args[2];
                    }
                    try {
                        BatchModeRecognizer.this.setInputStream(audioFile);
                        result = BatchModeRecognizer.this.recognizer.recognize(transcript);
                    }
                    catch (IOException io) {
                        ci.putResponse("I/O error during decoding: " + io.getMessage());
                    }
                }
                return result != null ? result.getBestResultNoFiller() : "";
            }

            @Override
            public String getHelp() {
                return "perform recognition on the given audio";
            }
        });
        ci.addAlias("recognize", "rec");
        ci.add("statsReset", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length != 1) {
                    ci.putResponse("Usage: statsReset");
                } else {
                    BatchModeRecognizer.this.recognizer.resetMonitors();
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "resets gathered statistics";
            }
        });
        ci.add("batchRecognize", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                Result result = null;
                if (args.length != 1) {
                    ci.putResponse("Usage: batchRecognize");
                } else {
                    try {
                        if (BatchModeRecognizer.this.curBatchItem == null) {
                            BatchModeRecognizer.this.batchManager.start();
                            BatchModeRecognizer.this.curBatchItem = BatchModeRecognizer.this.batchManager.getNextItem();
                        }
                        String audioFile = BatchModeRecognizer.this.curBatchItem.getFilename();
                        String transcript = BatchModeRecognizer.this.curBatchItem.getTranscript();
                        BatchModeRecognizer.this.setInputStream(audioFile);
                        result = BatchModeRecognizer.this.recognizer.recognize(transcript);
                    }
                    catch (IOException io) {
                        ci.putResponse("I/O error during decoding: " + io.getMessage());
                    }
                }
                return result != null ? result.getBestResultNoFiller() : "";
            }

            @Override
            public String getHelp() {
                return "perform recognition on the current batch item";
            }
        });
        ci.addAlias("batchRecognize", "br");
        ci.add("batchNext", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                Result result = null;
                if (args.length != 1 && args.length != 2) {
                    ci.putResponse("Usage: batchNext [norec]");
                } else {
                    try {
                        if (BatchModeRecognizer.this.curBatchItem == null) {
                            BatchModeRecognizer.this.batchManager.start();
                        }
                        BatchModeRecognizer.this.curBatchItem = BatchModeRecognizer.this.batchManager.getNextItem();
                        if (BatchModeRecognizer.this.curBatchItem == null) {
                            BatchModeRecognizer.this.batchManager.start();
                            BatchModeRecognizer.this.curBatchItem = BatchModeRecognizer.this.batchManager.getNextItem();
                        }
                        String audioFile = BatchModeRecognizer.this.curBatchItem.getFilename();
                        String transcript = BatchModeRecognizer.this.curBatchItem.getTranscript();
                        if (args.length == 2) {
                            ci.putResponse("Skipping: " + transcript);
                        } else {
                            BatchModeRecognizer.this.setInputStream(audioFile);
                            result = BatchModeRecognizer.this.recognizer.recognize(transcript);
                        }
                    }
                    catch (IOException io) {
                        ci.putResponse("I/O error during decoding: " + io.getMessage());
                    }
                }
                return result != null ? result.getBestResultNoFiller() : "";
            }

            @Override
            public String getHelp() {
                return "advance the batch and perform recognition";
            }
        });
        ci.addAlias("batchNext", "bn");
        ci.add("batchAll", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                Result result = null;
                if (args.length != 1) {
                    ci.putResponse("Usage: batchAll");
                } else {
                    try {
                        if (BatchModeRecognizer.this.curBatchItem == null) {
                            BatchModeRecognizer.this.batchManager.start();
                        }
                        while (true) {
                            BatchModeRecognizer.this.curBatchItem = BatchModeRecognizer.this.batchManager.getNextItem();
                            if (BatchModeRecognizer.this.curBatchItem == null) {
                                return "";
                            }
                            String audioFile = BatchModeRecognizer.this.curBatchItem.getFilename();
                            String transcript = BatchModeRecognizer.this.curBatchItem.getTranscript();
                            BatchModeRecognizer.this.setInputStream(audioFile);
                            result = BatchModeRecognizer.this.recognizer.recognize(transcript);
                        }
                    }
                    catch (IOException io) {
                        ci.putResponse("I/O error during decoding: " + io.getMessage());
                    }
                }
                return result != null ? result.getBestResultNoFiller() : "";
            }

            @Override
            public String getHelp() {
                return "recognize all of the remaining batch items";
            }
        });
        ci.add("batchReset", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length != 1) {
                    ci.putResponse("Usage: batchReset");
                } else {
                    try {
                        BatchModeRecognizer.this.batchManager.start();
                    }
                    catch (IOException ioe) {
                        ci.putResponse("trouble reseting batch");
                    }
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "reset the batch to the beginning";
            }
        });
        ci.add("batchLoad", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length != 2) {
                    ci.putResponse("Usage: batchReset batchfile");
                } else {
                    try {
                        BatchModeRecognizer.this.setBatchFile(args[1]);
                    }
                    catch (IOException ioe) {
                        ci.putResponse("Can't load " + args[1] + ' ' + ioe);
                    }
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "reset the batch to the beginning";
            }
        });
    }

    public void shell(String batchfile) throws IOException {
        try {
            CommandInterpreter ci = new CommandInterpreter();
            ci.setPrompt("s4> ");
            this.addCommands(ci);
            this.setBatchFile(batchfile);
            this.recognizer.allocate();
            ci.run();
            this.batchManager.stop();
            if (this.recognizer.getState() == Recognizer.State.READY) {
                this.recognizer.deallocate();
            }
        }
        catch (IOException io) {
            this.logger.severe("I/O error during decoding: " + io.getMessage());
            throw io;
        }
    }

    public static void main(String[] argv) {
        if (argv.length < 2) {
            System.out.println("Usage: BatchDecoder propertiesFile batchFile [-shell]");
            System.exit(1);
        }
        String cmFile = argv[0];
        String batchFile = argv[1];
        try {
            URL url = new File(cmFile).toURI().toURL();
            ConfigurationManager cm = new ConfigurationManager(url);
            BatchModeRecognizer bmr = (BatchModeRecognizer)cm.lookup("batch");
            if (bmr == null) {
                System.err.println("Can't find batchModeRecognizer in " + cmFile);
                return;
            }
            if (argv.length >= 3 && argv[2].equals("-shell")) {
                bmr.shell(batchFile);
            } else {
                bmr.decode(batchFile);
            }
            System.out.println("Tokens created: " + StatisticsVariable.getStatisticsVariable((String)"totalTokensScored").value);
        }
        catch (Exception e) {
            System.err.println("Error during decoding: \n  ");
            e.printStackTrace();
        }
    }

    public void start(String batchFile) throws IOException {
        this.recognizer.allocate();
        this.setBatchFile(batchFile);
        this.batchManager.start();
        this.logger.info("BatchDecoder: decoding files in " + this.batchManager.getFilename());
        this.count = 0;
    }

    public void stop() throws IOException {
        this.batchManager.stop();
        this.recognizer.deallocate();
    }

    public Result recognize() throws IOException {
        BatchItem batchItem;
        Result result = null;
        if (this.count < this.utteranceId && (batchItem = this.batchManager.getNextItem()) != null) {
            this.setInputStream(batchItem.getFilename());
            result = this.recognizer.recognize(batchItem.getTranscript());
            this.logger.info("File  : " + batchItem.getFilename());
            this.logger.info("Result: " + result);
            ++this.count;
        }
        this.logger.info("BatchDecoder: " + this.count + " files decoded");
        return result;
    }
}

