/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.batch;

import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;

public class BatchDecoderRecognizer {
    int ctlOffset = -1;
    int ctlCount = 1000000;
    String config;
    String hmm;
    String ctl;
    String hyp;
    String featDir;
    ConfigurationManager manager;
    StreamDataSource source;
    Recognizer recognizer;
    PrintWriter writer;

    void parseArgs(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-ctl")) {
                this.ctl = argv[++i];
            }
            if (argv[i].equals("-config")) {
                this.config = argv[++i];
            }
            if (argv[i].equals("-hmm")) {
                this.hmm = argv[++i];
            }
            if (argv[i].equals("-ctloffset")) {
                this.ctlOffset = Integer.parseInt(argv[++i]);
            }
            if (argv[i].equals("-ctlcount")) {
                this.ctlCount = Integer.parseInt(argv[++i]);
            }
            if (argv[i].equals("-hyp")) {
                this.hyp = argv[++i];
            }
            if (!argv[i].equals("-feat")) continue;
            this.featDir = argv[++i];
        }
    }

    void recognize() throws IOException {
        int i;
        this.init();
        this.writer = new PrintWriter(new File(this.hyp), "UTF-8");
        Scanner scanner = new Scanner(new File(this.ctl));
        for (i = 0; i < this.ctlOffset; ++i) {
            if (!scanner.hasNext()) continue;
            scanner.next();
        }
        for (i = 0; i < this.ctlCount; ++i) {
            if (!scanner.hasNext()) continue;
            String utteranceId = scanner.next();
            String inputFile = this.featDir + "/" + utteranceId + ".wav";
            this.processFile(utteranceId, inputFile);
        }
        this.writer.close();
        scanner.close();
        this.recognizer.deallocate();
    }

    private void processFile(String utteranceId, String inputFile) throws IOException {
        FileInputStream stream = new FileInputStream(inputFile);
        this.source.setInputStream(stream);
        Result result = this.recognizer.recognize();
        this.writer.println(result.getBestFinalResultNoFiller() + " (" + utteranceId + ")");
    }

    public static void main(String[] argv) throws IOException {
        BatchDecoderRecognizer batchRecognizer = new BatchDecoderRecognizer();
        batchRecognizer.parseArgs(argv);
        batchRecognizer.recognize();
    }

    private void init() throws IOException {
        this.manager = new ConfigurationManager(this.config);
        this.recognizer = (Recognizer)this.manager.lookup("recognizer");
        this.source = (StreamDataSource)this.manager.lookup("streamDataSource");
        this.recognizer.allocate();
    }
}

