/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;

public class RawWriter {
    private final OutputStream outputStream;
    private final int bytesPerSample;
    private boolean signedData;

    public RawWriter(OutputStream outputStream, AudioFormat audioFormat) {
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        this.outputStream = outputStream;
        this.bytesPerSample = audioFormat.getSampleSizeInBits() / 8;
        if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            this.signedData = true;
        } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            this.signedData = false;
        } else {
            System.err.println("Unsupported audio encoding: " + encoding);
            System.exit(-1);
        }
    }

    public void writeSample(int sample) throws IOException {
        if (this.signedData) {
            this.outputStream.write(sample >> (this.bytesPerSample - 1) * 8);
        } else {
            this.outputStream.write(sample >> (this.bytesPerSample - 1) * 8 & 0xFF);
        }
        for (int i = this.bytesPerSample - 2; i >= 0; --i) {
            this.outputStream.write(sample >> i * 8 & 0xFF);
        }
    }
}

