/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.AudioDataInputStream;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ReplicateScaleFilter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CepstrumPanel
extends JPanel {
    protected BufferedImage spectrogram;
    protected Image scaledSpectrogram;
    protected float zoom = 1.0f;
    protected double offsetFactor;
    protected AudioData audio;
    protected FrontEnd frontEnd;
    protected StreamDataSource dataSource;
    static final int HSCALE = 10;

    public CepstrumPanel() {
    }

    public CepstrumPanel(FrontEnd frontEnd, StreamDataSource dataSource, AudioData audioData) {
        this.audio = audioData;
        this.frontEnd = frontEnd;
        this.dataSource = dataSource;
        this.audio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                CepstrumPanel.this.computeCepstrum();
            }
        });
    }

    protected void computeCepstrum() {
        try {
            AudioDataInputStream is = new AudioDataInputStream(this.audio);
            this.dataSource.setInputStream(is);
            ArrayList<float[]> intensitiesList = new ArrayList<float[]>();
            float[] maxIntensity = new float[100];
            Arrays.fill(maxIntensity, Float.MIN_VALUE);
            Data spectrum = this.frontEnd.getData();
            while (!(spectrum instanceof DataEndSignal)) {
                int i;
                float[] intensities;
                Object[] spectrumData;
                if (spectrum instanceof FloatData) {
                    spectrumData = ((FloatData)spectrum).getValues();
                    intensities = new float[spectrumData.length];
                    for (i = 0; i < intensities.length; ++i) {
                        intensities[i] = spectrumData[i];
                        if (!(Math.abs(intensities[i]) > maxIntensity[i])) continue;
                        maxIntensity[i] = Math.abs(intensities[i]);
                    }
                    intensitiesList.add(intensities);
                }
                if (spectrum instanceof DoubleData) {
                    spectrumData = ((DoubleData)spectrum).getValues();
                    intensities = new float[spectrumData.length];
                    for (i = 0; i < intensities.length; ++i) {
                        intensities[i] = spectrumData[i];
                        if (!(Math.abs(intensities[i]) > maxIntensity[i])) continue;
                        maxIntensity[i] = Math.abs(intensities[i]);
                    }
                    intensitiesList.add(intensities);
                }
                spectrum = this.frontEnd.getData();
            }
            is.close();
            int width = intensitiesList.size();
            int ncep = ((float[])intensitiesList.get(0)).length;
            int height = ncep * 10;
            Dimension d = new Dimension(width, height);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
            this.spectrogram = new BufferedImage(width, height, 1);
            for (int i = 0; i < width; ++i) {
                float[] intensities = (float[])intensitiesList.get(i);
                for (int j = ncep - 1; j >= 0; --j) {
                    int grey = 127 - (int)(intensities[j] / maxIntensity[j] * 127.0f);
                    int pixel = grey << 16 & 0xFF0000 | grey << 8 & 0xFF00 | grey & 0xFF;
                    for (int k = 0; k < 10; ++k) {
                        this.spectrogram.setRGB(i, height - 1 - j * 10 - k, pixel);
                    }
                }
            }
            ReplicateScaleFilter scaleFilter = new ReplicateScaleFilter((int)(this.zoom * (float)width), height);
            this.scaledSpectrogram = this.createImage(new FilteredImageSource(this.spectrogram.getSource(), scaleFilter));
            Dimension sz = this.getSize();
            this.repaint(0L, 0, 0, sz.width - 1, sz.height - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOffsetFactor(double offsetFactor) {
        this.offsetFactor = offsetFactor;
        this.computeCepstrum();
    }

    protected void zoomSet(float zoom) {
        this.zoom = zoom;
        if (this.spectrogram != null) {
            int width = this.spectrogram.getWidth();
            int height = this.spectrogram.getHeight();
            ReplicateScaleFilter scaleFilter = new ReplicateScaleFilter((int)(zoom * (float)width), height);
            this.scaledSpectrogram = this.createImage(new FilteredImageSource(this.spectrogram.getSource(), scaleFilter));
            Dimension d = new Dimension((int)((float)width * zoom), height);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        Dimension sz = this.getSize();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, sz.width - 1, sz.height - 1);
        if (this.spectrogram != null) {
            g.drawImage(this.scaledSpectrogram, 0, 0, null);
        }
    }
}

