/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.aligner;

import edu.cmu.sphinx.api.SpeechAligner;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.util.TimeFrame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Aligner {
    private static int MIN_FILLER_LENGTH = 200;

    public static void main(String[] args) throws Exception {
        File file = new File(args[2]);
        SpeechAligner aligner = new SpeechAligner(args[0], args[1], null);
        Aligner.splitStream(file, aligner.align(file.toURI().toURL(), args[3]));
    }

    private static void splitStream(File inFile, List<WordResult> results) throws UnsupportedAudioFileException, IOException {
        System.err.println(results.size());
        ArrayList utts = new ArrayList();
        ArrayList<WordResult> currentUtt = null;
        int fillerLength = 0;
        for (WordResult result : results) {
            if (result.isFiller()) {
                if ((fillerLength = (int)((long)fillerLength + result.getTimeFrame().length())) <= MIN_FILLER_LENGTH) continue;
                if (currentUtt != null) {
                    utts.add(currentUtt);
                }
                currentUtt = null;
                continue;
            }
            fillerLength = 0;
            if (currentUtt == null) {
                currentUtt = new ArrayList<WordResult>();
            }
            currentUtt.add(result);
        }
        if (null != currentUtt) {
            utts.add(currentUtt);
        }
        int count = 0;
        for (List list : utts) {
            long startFrame = Long.MAX_VALUE;
            long endFrame = Long.MIN_VALUE;
            for (WordResult result : list) {
                TimeFrame frame = result.getTimeFrame();
                startFrame = Math.min(startFrame, frame.getStart());
                endFrame = Math.max(endFrame, frame.getEnd());
                System.out.print(result.getPronunciation().getWord());
                System.out.print(' ');
            }
            String[] basename = inFile.getName().split("\\.wav$");
            String uttId = String.format("%03d0", count);
            String outPath = String.format("%s-%s.wav", basename[0], uttId);
            System.out.println("(" + uttId + ")");
            ++count;
            Aligner.dumpStreamChunk(inFile, outPath, startFrame - (long)MIN_FILLER_LENGTH, endFrame - startFrame + (long)MIN_FILLER_LENGTH);
        }
    }

    private static void dumpStreamChunk(File file, String dstPath, long offset, long length) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(file);
        AudioInputStream inputStream = AudioSystem.getAudioInputStream(file);
        AudioFormat audioFormat = fileFormat.getFormat();
        int bitrate = Math.round((float)audioFormat.getFrameSize() * audioFormat.getFrameRate() / 1000.0f);
        inputStream.skip(offset * (long)bitrate);
        AudioInputStream chunkStream = new AudioInputStream(inputStream, audioFormat, length * (long)bitrate);
        AudioSystem.write(chunkStream, fileFormat.getType(), new File(dstPath));
        inputStream.close();
        chunkStream.close();
    }
}

