/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.trie;

import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieBitarr;
import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieModel;
import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieQuant;

public class NgramTrie {
    private MiddleNgramSet[] middles;
    private LongestNgramSet longest;
    private NgramTrieBitarr bitArr;
    private int ordersNum;
    private int quantProbBoLen;
    private int quantProbLen;

    public NgramTrie(int[] counts, int quantProbBoLen, int quantProbLen) {
        int i;
        int memLen = 0;
        int[] ngramMemSize = new int[counts.length - 1];
        for (int i2 = 1; i2 <= counts.length - 1; ++i2) {
            int tmpLen;
            int entryLen = this.requiredBits(counts[0]);
            if (i2 == counts.length - 1) {
                entryLen += quantProbLen;
            } else {
                entryLen += this.requiredBits(counts[i2 + 1]);
                entryLen += quantProbBoLen;
            }
            ngramMemSize[i2 - 1] = tmpLen = ((1 + counts[i2]) * entryLen + 7) / 8 + 8;
            memLen += tmpLen;
        }
        this.bitArr = new NgramTrieBitarr(memLen);
        this.quantProbLen = quantProbLen;
        this.quantProbBoLen = quantProbBoLen;
        this.middles = new MiddleNgramSet[counts.length - 2];
        int[] startPtrs = new int[counts.length - 2];
        int startPtr = 0;
        for (i = 0; i < counts.length - 2; ++i) {
            startPtrs[i] = startPtr;
            startPtr += ngramMemSize[i];
        }
        for (i = counts.length - 1; i >= 2; --i) {
            this.middles[i - 2] = new MiddleNgramSet(startPtrs[i - 2], quantProbBoLen, counts[i - 1], counts[0], counts[i]);
        }
        this.longest = new LongestNgramSet(startPtr, quantProbLen, counts[0]);
        this.ordersNum = this.middles.length + 1;
    }

    public byte[] getMem() {
        return this.bitArr.getArr();
    }

    private int findNgram(NgramSet ngramSet, int wordId, NgramTrieModel.TrieRange range) {
        --range.begin;
        int ptr = this.uniformFind(ngramSet, range, wordId);
        if (ptr < 0) {
            range.setFound(false);
            return -1;
        }
        if (ngramSet instanceof MiddleNgramSet) {
            ((MiddleNgramSet)ngramSet).readNextRange(ptr, range);
        }
        return ptr;
    }

    public float readNgramBackoff(int wordId, int orderMinusTwo, NgramTrieModel.TrieRange range, NgramTrieQuant quant) {
        NgramSet ngram = this.getNgram(orderMinusTwo);
        int ptr = this.findNgram(ngram, wordId, range);
        if (ptr < 0) {
            return 0.0f;
        }
        return quant.readBackoff(this.bitArr, ngram.memPtr, ngram.getNgramWeightsOffset(ptr), orderMinusTwo);
    }

    public float readNgramProb(int wordId, int orderMinusTwo, NgramTrieModel.TrieRange range, NgramTrieQuant quant) {
        NgramSet ngram = this.getNgram(orderMinusTwo);
        int ptr = this.findNgram(ngram, wordId, range);
        if (ptr < 0) {
            return 0.0f;
        }
        return quant.readProb(this.bitArr, ngram.memPtr, ngram.getNgramWeightsOffset(ptr), orderMinusTwo);
    }

    private int calculatePivot(int offset, int range, int width) {
        return (int)((long)offset * (long)width / (long)(range + 1));
    }

    private int uniformFind(NgramSet ngram, NgramTrieModel.TrieRange range, int wordId) {
        NgramTrieModel.TrieRange vocabRange = new NgramTrieModel.TrieRange(0, ngram.maxVocab);
        while (range.getWidth() > 1) {
            int pivot = range.begin + 1 + this.calculatePivot(wordId - vocabRange.begin, vocabRange.getWidth(), range.getWidth() - 1);
            int mid = ngram.readNgramWord(pivot);
            if (mid < wordId) {
                range.begin = pivot;
                vocabRange.begin = mid;
                continue;
            }
            if (mid > wordId) {
                range.end = pivot;
                vocabRange.end = mid;
                continue;
            }
            return pivot;
        }
        return -1;
    }

    private NgramSet getNgram(int orderMinusTwo) {
        if (orderMinusTwo == this.ordersNum - 1) {
            return this.longest;
        }
        return this.middles[orderMinusTwo];
    }

    private int requiredBits(int maxValue) {
        if (maxValue == 0) {
            return 0;
        }
        int res = 1;
        while ((maxValue >>= 1) != 0) {
            ++res;
        }
        return res;
    }

    class LongestNgramSet
    extends NgramSet {
        LongestNgramSet(int memPtr, int quantBits, int maxVocab) {
            super(memPtr, maxVocab, quantBits);
        }

        @Override
        int getQuantBits() {
            return NgramTrie.this.quantProbLen;
        }
    }

    class MiddleNgramSet
    extends NgramSet {
        int nextMask;
        int nextOrderMemPtr;

        MiddleNgramSet(int memPtr, int quantBits, int entries, int maxVocab, int maxNext) {
            super(memPtr, maxVocab, quantBits + NgramTrie.this.requiredBits(maxNext));
            this.nextMask = (1 << NgramTrie.this.requiredBits(maxNext)) - 1;
            if (entries + 1 >= 0x2000000 || maxNext >= 0x2000000) {
                throw new Error("Sorry, current implementation doesn't support more than 33554432 n-grams of particular order");
            }
        }

        void readNextRange(int ngramIdx, NgramTrieModel.TrieRange range) {
            int offset = ngramIdx * this.totalBits;
            offset += this.wordBits;
            range.begin = NgramTrie.this.bitArr.readInt(this.memPtr, offset += this.getQuantBits(), this.nextMask);
            range.end = NgramTrie.this.bitArr.readInt(this.memPtr, offset += this.totalBits, this.nextMask);
        }

        @Override
        int getQuantBits() {
            return NgramTrie.this.quantProbBoLen;
        }
    }

    abstract class NgramSet {
        int memPtr;
        int wordBits;
        int wordMask;
        int totalBits;
        int insertIdx;
        int maxVocab;

        NgramSet(int memPtr, int maxVocab, int remainingBits) {
            this.maxVocab = maxVocab;
            this.memPtr = memPtr;
            this.wordBits = NgramTrie.this.requiredBits(maxVocab);
            if (this.wordBits > 25) {
                throw new Error("Sorry, word indices more than33554432 are not implemented");
            }
            this.totalBits = this.wordBits + remainingBits;
            this.wordMask = (1 << this.wordBits) - 1;
            this.insertIdx = 0;
        }

        int readNgramWord(int ngramIdx) {
            int offset = ngramIdx * this.totalBits;
            return NgramTrie.this.bitArr.readInt(this.memPtr, offset, this.wordMask);
        }

        int getNgramWeightsOffset(int ngramIdx) {
            return ngramIdx * this.totalBits + this.wordBits;
        }

        abstract int getQuantBits();
    }
}

