/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.large;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.linguist.language.ngram.large.BinaryLoader;
import edu.cmu.sphinx.linguist.language.ngram.large.BinaryStreamLoader;
import edu.cmu.sphinx.linguist.language.ngram.large.NGramBuffer;
import edu.cmu.sphinx.linguist.language.ngram.large.NGramProbability;
import edu.cmu.sphinx.linguist.language.ngram.large.NMaxGramBuffer;
import edu.cmu.sphinx.linguist.language.ngram.large.UnigramProbability;
import edu.cmu.sphinx.linguist.util.LRUCache;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LargeNGramModel
implements LanguageModel {
    @S4String(mandatory=false)
    public static final String PROP_QUERY_LOG_FILE = "queryLogFile";
    @S4Integer(defaultValue=100000)
    public static final String PROP_NGRAM_CACHE_SIZE = "ngramCacheSize";
    @S4Boolean(defaultValue=false)
    public static final String PROP_CLEAR_CACHES_AFTER_UTTERANCE = "clearCachesAfterUtterance";
    @S4Double(defaultValue=1.0)
    public static final String PROP_LANGUAGE_WEIGHT = "languageWeight";
    @S4Boolean(defaultValue=false)
    public static final String PROP_APPLY_LANGUAGE_WEIGHT_AND_WIP = "applyLanguageWeightAndWip";
    @S4Double(defaultValue=1.0)
    public static final String PROP_WORD_INSERTION_PROBABILITY = "wordInsertionProbability";
    @S4Boolean(defaultValue=false)
    public static final String PROP_FULL_SMEAR = "fullSmear";
    public static final int BYTES_PER_NGRAM = 4;
    public static final int BYTES_PER_NMAXGRAM = 2;
    private static final int SMEAR_MAGIC = -1060454374;
    URL location;
    protected Logger logger;
    protected LogMath logMath;
    protected int maxDepth;
    protected int ngramCacheSize;
    protected boolean clearCacheAfterUtterance;
    protected boolean fullSmear;
    protected Dictionary dictionary;
    protected String format;
    protected boolean applyLanguageWeightAndWip;
    protected float languageWeight;
    protected float unigramWeight;
    protected double wip;
    private int ngramMisses;
    private int ngramHits;
    private int smearTermCount;
    protected String ngramLogFile;
    private BinaryLoader loader;
    private PrintWriter logFile;
    private Map<Word, UnigramProbability> unigramIDMap;
    private Map<WordSequence, NGramBuffer>[] loadedNGramBuffers;
    private LRUCache<WordSequence, Float> ngramProbCache;
    private Map<Long, Float> bigramSmearMap;
    private NGramBuffer[] loadedBigramBuffers;
    private UnigramProbability[] unigrams;
    private int[][] ngramSegmentTable;
    private float[][] ngramProbTable;
    private float[][] ngramBackoffTable;
    private float[] unigramSmearTerm;
    int smearCount;
    int smearBigramHit;

    public LargeNGramModel(String format, URL location, String ngramLogFile, int maxNGramCacheSize, boolean clearCacheAfterUtterance, int maxDepth, Dictionary dictionary, boolean applyLanguageWeightAndWip, float languageWeight, double wip, float unigramWeight, boolean fullSmear) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.format = format;
        this.location = location;
        this.ngramLogFile = ngramLogFile;
        this.ngramCacheSize = maxNGramCacheSize;
        this.clearCacheAfterUtterance = clearCacheAfterUtterance;
        this.maxDepth = maxDepth;
        this.logMath = LogMath.getLogMath();
        this.dictionary = dictionary;
        this.applyLanguageWeightAndWip = applyLanguageWeightAndWip;
        this.languageWeight = languageWeight;
        this.wip = wip;
        this.unigramWeight = unigramWeight;
        this.fullSmear = fullSmear;
    }

    public LargeNGramModel() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.location = ConfigurationManagerUtils.getResource("location", ps);
        this.ngramLogFile = ps.getString(PROP_QUERY_LOG_FILE);
        this.ngramCacheSize = ps.getInt(PROP_NGRAM_CACHE_SIZE);
        this.clearCacheAfterUtterance = ps.getBoolean(PROP_CLEAR_CACHES_AFTER_UTTERANCE);
        this.maxDepth = ps.getInt("maxDepth");
        this.dictionary = (Dictionary)ps.getComponent("dictionary");
        this.applyLanguageWeightAndWip = ps.getBoolean(PROP_APPLY_LANGUAGE_WEIGHT_AND_WIP);
        this.languageWeight = ps.getFloat(PROP_LANGUAGE_WEIGHT);
        this.wip = ps.getDouble(PROP_WORD_INSERTION_PROBABILITY);
        this.unigramWeight = ps.getFloat("unigramWeight");
        this.fullSmear = ps.getBoolean(PROP_FULL_SMEAR);
    }

    @Override
    public void allocate() throws IOException {
        int i;
        TimerPool.getTimer(this, "Load LM").start();
        this.logger.info("Loading n-gram language model from: " + this.location);
        if (this.ngramLogFile != null) {
            this.logFile = new PrintWriter(new FileOutputStream(this.ngramLogFile));
        }
        if (this.location.getProtocol() == null || this.location.getProtocol().equals("file")) {
            try {
                this.loader = new BinaryLoader(new File(this.location.toURI()), this.format, this.applyLanguageWeightAndWip, this.languageWeight, this.wip, this.unigramWeight);
            }
            catch (Exception e) {
                this.loader = new BinaryLoader(new File(this.location.getPath()), this.format, this.applyLanguageWeightAndWip, this.languageWeight, this.wip, this.unigramWeight);
            }
        } else {
            this.loader = new BinaryStreamLoader(this.location, this.format, this.applyLanguageWeightAndWip, this.languageWeight, this.wip, this.unigramWeight);
        }
        this.unigramIDMap = new HashMap<Word, UnigramProbability>();
        this.unigrams = this.loader.getUnigrams();
        this.loadedNGramBuffers = new Map[this.loader.getMaxDepth()];
        this.ngramProbTable = new float[this.loader.getMaxDepth()][];
        this.ngramBackoffTable = new float[this.loader.getMaxDepth()][];
        this.ngramSegmentTable = new int[this.loader.getMaxDepth()][];
        for (i = 1; i <= this.loader.getMaxDepth(); ++i) {
            this.loadedNGramBuffers[i - 1] = new HashMap<WordSequence, NGramBuffer>();
            if (i >= 2) {
                this.ngramProbTable[i - 1] = this.loader.getNGramProbabilities(i);
            }
            if (i <= 2) continue;
            this.ngramBackoffTable[i - 1] = this.loader.getNGramBackoffWeights(i);
            this.ngramSegmentTable[i - 1] = this.loader.getNGramSegments(i);
        }
        this.ngramProbCache = new LRUCache(this.ngramCacheSize);
        if (this.dictionary != null) {
            this.buildUnigramIDMap(this.dictionary);
        } else {
            this.buildUnigramIDMap();
        }
        this.loadedBigramBuffers = new NGramBuffer[this.unigrams.length];
        if (this.maxDepth <= 0 || this.maxDepth > this.loader.getMaxDepth()) {
            this.maxDepth = this.loader.getMaxDepth();
        }
        for (i = 1; i <= this.loader.getMaxDepth(); ++i) {
            this.logger.info(Integer.toString(i) + "-grams: " + this.loader.getNumberNGrams(i));
        }
        if (this.fullSmear) {
            System.out.println("Full Smear");
            try {
                System.out.println("... Reading ...");
                this.readSmearInfo("smear.dat");
                System.out.println("... Done ");
            }
            catch (IOException e) {
                System.out.println("... " + e);
                System.out.println("... Calculating");
                this.buildSmearInfo();
                System.out.println("... Writing");
                System.out.println("... Done");
            }
        }
        TimerPool.getTimer(this, "Load LM").stop();
    }

    @Override
    public void deallocate() throws IOException {
        this.loader.deallocate();
    }

    private void buildUnigramIDMap(Dictionary dictionary) {
        int missingWords = 0;
        String[] words = this.loader.getWords();
        for (int i = 0; i < words.length; ++i) {
            Word word = dictionary.getWord(words[i]);
            if (word == null) {
                this.logger.warning("The dictionary is missing a phonetic transcription for the word '" + words[i] + "'");
                ++missingWords;
            }
            this.unigramIDMap.put(word, this.unigrams[i]);
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("Word: " + word);
        }
        if (missingWords > 0) {
            this.logger.warning("Dictionary is missing " + missingWords + " words that are contained in the language model.");
        }
    }

    private void buildUnigramIDMap() {
        String[] words = this.loader.getWords();
        for (int i = 0; i < words.length; ++i) {
            Word word = new Word(words[i], null, false);
            this.unigramIDMap.put(word, this.unigrams[i]);
        }
    }

    @Override
    public void onUtteranceEnd() {
        this.clearCache();
        if (this.logFile != null) {
            this.logFile.println("<END_UTT>");
            this.logFile.flush();
        }
    }

    private void clearCache() {
        int i;
        for (i = 0; i < this.loadedBigramBuffers.length; ++i) {
            NGramBuffer buffer = this.loadedBigramBuffers[i];
            if (buffer == null) continue;
            if (!buffer.getUsed()) {
                this.loadedBigramBuffers[i] = null;
                continue;
            }
            buffer.setUsed(false);
        }
        this.loadedBigramBuffers = new NGramBuffer[this.unigrams.length];
        for (i = 2; i <= this.loader.getMaxDepth(); ++i) {
            this.loadedNGramBuffers[i - 1] = new HashMap<WordSequence, NGramBuffer>();
        }
        this.logger.info("LM Cache Size: " + this.ngramProbCache.size() + " Hits: " + this.ngramHits + " Misses: " + this.ngramMisses);
        if (this.clearCacheAfterUtterance) {
            this.ngramProbCache = new LRUCache(this.ngramCacheSize);
        }
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        Float probability;
        int numberWords = wordSequence.size();
        if (numberWords > this.maxDepth) {
            throw new Error("Unsupported NGram: " + wordSequence.size());
        }
        if (numberWords == this.maxDepth) {
            probability = (Float)this.ngramProbCache.get(wordSequence);
            if (probability != null) {
                ++this.ngramHits;
                return probability.floatValue();
            }
            ++this.ngramMisses;
        }
        probability = this.getNGramProbability(wordSequence);
        if (numberWords == this.maxDepth) {
            this.ngramProbCache.put(wordSequence, probability);
        }
        if (this.logFile != null && probability != null) {
            this.logFile.println(wordSequence.toString().replace("][", " ") + " : " + Float.toString(probability.floatValue()));
        }
        return probability.floatValue();
    }

    private Float getNGramProbability(WordSequence wordSequence) {
        int numberWords = wordSequence.size();
        Word firstWord = wordSequence.getWord(0);
        if (this.loader.getNumberNGrams(numberWords) == 0 || !this.hasUnigram(firstWord)) {
            return this.getNGramProbability(wordSequence.getNewest());
        }
        if (numberWords < 2) {
            return Float.valueOf(this.getUnigramProbability(wordSequence));
        }
        NGramProbability nGProbability = this.findNGram(wordSequence);
        if (nGProbability != null) {
            return Float.valueOf(this.ngramProbTable[numberWords - 1][nGProbability.getProbabilityID()]);
        }
        if (numberWords == 2) {
            UnigramProbability unigramProb = this.getUnigram(firstWord);
            UnigramProbability unigramProb1 = this.getUnigram(wordSequence.getWord(1));
            return Float.valueOf(unigramProb.getLogBackoff() + unigramProb1.getLogProbability());
        }
        NGramProbability nMinus1Gram = this.findNGram(wordSequence.getOldest());
        if (nMinus1Gram != null) {
            return Float.valueOf(this.ngramBackoffTable[numberWords - 1][nMinus1Gram.getBackoffID()] + this.getProbability(wordSequence.getNewest()));
        }
        return Float.valueOf(this.getProbability(wordSequence.getNewest()));
    }

    private NGramProbability findNGram(WordSequence wordSequence) {
        int numberWords = wordSequence.size();
        NGramProbability nGram = null;
        WordSequence oldest = wordSequence.getOldest();
        NGramBuffer nGramBuffer = this.loadedNGramBuffers[numberWords - 1].get(oldest);
        if (nGramBuffer == null && (nGramBuffer = this.getNGramBuffer(oldest)) != null) {
            this.loadedNGramBuffers[numberWords - 1].put(oldest, nGramBuffer);
        }
        if (nGramBuffer != null) {
            int nthWordID = this.getWordID(wordSequence.getWord(numberWords - 1));
            nGram = nGramBuffer.findNGram(nthWordID);
        }
        return nGram;
    }

    private boolean is32bits() {
        return this.loader.getBytesPerField() == 4;
    }

    private NGramBuffer loadNGramBuffer(WordSequence ws) {
        int firstWordID = this.getWordID(ws.getWord(0));
        int firstCurrentNGramEntry = 0;
        int numberNGrams = 0;
        int size = 0;
        long position = 0L;
        int orderBuffer = ws.size() + 1;
        NGramBuffer currentBuffer = null;
        NGramBuffer nMinus1Buffer = null;
        firstCurrentNGramEntry = this.unigrams[firstWordID].getFirstBigramEntry();
        numberNGrams = this.getNumberBigramFollowers(firstWordID) + 1;
        if (numberNGrams == 1) {
            return null;
        }
        if (orderBuffer == 2) {
            size = numberNGrams * (this.loader.getMaxDepth() == orderBuffer ? 2 : 4) * this.loader.getBytesPerField();
            position = this.loader.getNGramOffset(orderBuffer) + (long)(firstCurrentNGramEntry * (this.loader.getMaxDepth() == orderBuffer ? 2 : 4) * this.loader.getBytesPerField());
        } else {
            int lastWordId = this.getWordID(ws.getWord(ws.size() - 1));
            nMinus1Buffer = this.getNGramBuffer(ws.getOldest());
            int index = nMinus1Buffer.findNGramIndex(lastWordId);
            if (index == -1) {
                return null;
            }
            int firstNMinus1GramEntry = nMinus1Buffer.getFirstNGramEntry();
            firstCurrentNGramEntry = this.getFirstNGramEntry(nMinus1Buffer.getNGramProbability(index), firstNMinus1GramEntry, orderBuffer);
            int firstNextNGramEntry = this.getFirstNGramEntry(nMinus1Buffer.getNGramProbability(index + 1), firstNMinus1GramEntry, orderBuffer);
            numberNGrams = firstNextNGramEntry - firstCurrentNGramEntry;
            if (numberNGrams == 0) {
                return null;
            }
            if (this.loader.getMaxDepth() != orderBuffer) {
                ++numberNGrams;
            }
            size = numberNGrams * (this.loader.getMaxDepth() == orderBuffer ? 2 : 4) * this.loader.getBytesPerField();
            position = this.loader.getNGramOffset(orderBuffer) + (long)firstCurrentNGramEntry * (long)(this.loader.getMaxDepth() == orderBuffer ? 2 : 4) * (long)this.loader.getBytesPerField();
        }
        try {
            byte[] buffer = this.loader.loadBuffer(position, size);
            currentBuffer = this.loader.getMaxDepth() == orderBuffer ? new NMaxGramBuffer(buffer, numberNGrams, this.loader.getBigEndian(), this.is32bits(), orderBuffer, firstCurrentNGramEntry) : new NGramBuffer(buffer, numberNGrams, this.loader.getBigEndian(), this.is32bits(), orderBuffer, firstCurrentNGramEntry);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new Error("Error loading " + orderBuffer + "-Grams.");
        }
        return currentBuffer;
    }

    private NGramBuffer getNGramBuffer(WordSequence wordSequence) {
        NGramBuffer nGramBuffer = null;
        int order = wordSequence.size();
        if (order > 1) {
            nGramBuffer = this.loadedNGramBuffers[order - 1].get(wordSequence);
        }
        if (nGramBuffer == null && (nGramBuffer = this.loadNGramBuffer(wordSequence)) != null) {
            this.loadedNGramBuffers[order - 1].put(wordSequence, nGramBuffer);
        }
        return nGramBuffer;
    }

    private int getFirstNGramEntry(NGramProbability nMinus1Gram, int firstNMinus1GramEntry, int n) {
        int firstNGramEntry = this.ngramSegmentTable[n - 1][firstNMinus1GramEntry + nMinus1Gram.getWhichFollower() >> this.loader.getLogNGramSegmentSize()] + nMinus1Gram.getFirstNPlus1GramEntry();
        return firstNGramEntry;
    }

    private float getUnigramProbability(WordSequence wordSequence) {
        Word unigram = wordSequence.getWord(0);
        UnigramProbability unigramProb = this.getUnigram(unigram);
        if (unigramProb == null) {
            throw new Error("Unigram not in LM: " + unigram);
        }
        return unigramProb.getLogProbability();
    }

    private UnigramProbability getUnigram(Word unigram) {
        return this.unigramIDMap.get(unigram);
    }

    private boolean hasUnigram(Word unigram) {
        return this.unigramIDMap.get(unigram) != null;
    }

    public final int getWordID(Word word) {
        UnigramProbability probability = this.getUnigram(word);
        if (probability == null) {
            throw new IllegalArgumentException("No word ID: " + word);
        }
        return probability.getWordID();
    }

    public boolean hasWord(Word w) {
        return this.unigramIDMap.get(new Word(w.toString(), null, false)) != null;
    }

    public float getSmearOld(WordSequence wordSequence) {
        int length;
        float smearTerm = 0.0f;
        if (this.fullSmear && (length = wordSequence.size()) > 0) {
            int wordID = this.getWordID(wordSequence.getWord(length - 1));
            smearTerm = this.unigramSmearTerm[wordID];
        }
        if (this.fullSmear && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("SmearTerm: " + smearTerm);
        }
        return smearTerm;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        float smearTerm = 0.0f;
        if (this.fullSmear) {
            ++this.smearCount;
            int length = wordSequence.size();
            if (length == 1) {
                int wordID = this.getWordID(wordSequence.getWord(0));
                smearTerm = this.unigramSmearTerm[wordID];
            } else if (length >= 2) {
                int wordID2;
                int size = wordSequence.size();
                int wordID1 = this.getWordID(wordSequence.getWord(size - 2));
                Float st = this.getSmearTerm(wordID1, wordID2 = this.getWordID(wordSequence.getWord(size - 1)));
                if (st == null) {
                    smearTerm = this.unigramSmearTerm[wordID2];
                } else {
                    smearTerm = st.floatValue();
                    ++this.smearBigramHit;
                }
            }
            if (this.smearCount % 100000 == 0) {
                System.out.println("Smear hit: " + this.smearBigramHit + " tot: " + this.smearCount);
            }
        }
        if (this.fullSmear && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("SmearTerm: " + smearTerm);
        }
        return smearTerm;
    }

    private int getNumberBigramFollowers(int wordID) {
        if (wordID == this.unigrams.length - 1) {
            return 0;
        }
        return this.unigrams[wordID + 1].getFirstBigramEntry() - this.unigrams[wordID].getFirstBigramEntry();
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public Set<String> getVocabulary() {
        HashSet<String> vocabulary = new HashSet<String>(Arrays.asList(this.loader.getWords()));
        return Collections.unmodifiableSet(vocabulary);
    }

    public int getNGramMisses() {
        return this.ngramMisses;
    }

    public int getNGramHits() {
        return this.ngramHits;
    }

    private NGramBuffer getBigramBuffer(int firstWordID) {
        Word[] wd = new Word[]{this.dictionary.getWord(this.loader.getWords()[firstWordID])};
        WordSequence ws = new WordSequence(wd);
        return this.loadNGramBuffer(ws);
    }

    private NGramBuffer loadTrigramBuffer(int firstWordID, int secondWordID) {
        Word[] wd = new Word[]{this.dictionary.getWord(this.loader.getWords()[firstWordID]), this.dictionary.getWord(this.loader.getWords()[secondWordID])};
        WordSequence ws = new WordSequence(wd);
        return this.loadNGramBuffer(ws);
    }

    private void buildSmearInfo() throws IOException {
        int i;
        double S0 = 0.0;
        double R0 = 0.0;
        this.bigramSmearMap = new HashMap<Long, Float>();
        double[] ugNumerator = new double[this.unigrams.length];
        double[] ugDenominator = new double[this.unigrams.length];
        double[] ugAvgLogProb = new double[this.unigrams.length];
        this.unigramSmearTerm = new float[this.unigrams.length];
        for (UnigramProbability unigram : this.unigrams) {
            float logp = unigram.getLogProbability();
            double p = this.logMath.logToLinear(logp);
            S0 += p * (double)logp;
            R0 += p * (double)logp * (double)logp;
        }
        System.out.println("R0 S0 " + R0 + ' ' + S0);
        for (i = 0; i < this.loadedBigramBuffers.length; ++i) {
            NGramBuffer bigram = this.getBigramBuffer(i);
            if (bigram == null) {
                this.unigramSmearTerm[i] = 0.0f;
                continue;
            }
            ugNumerator[i] = 0.0;
            ugDenominator[i] = 0.0;
            ugAvgLogProb[i] = 0.0;
            float logugbackoff = this.unigrams[i].getLogBackoff();
            double ugbackoff = this.logMath.logToLinear(logugbackoff);
            for (int j = 0; j < bigram.getNumberNGrams(); ++j) {
                int wordID = bigram.getWordID(j);
                NGramProbability bgProb = bigram.getNGramProbability(j);
                float logugprob = this.unigrams[wordID].getLogProbability();
                float logbgprob = this.ngramProbTable[1][bgProb.getProbabilityID()];
                double ugprob = this.logMath.logToLinear(logugprob);
                double bgprob = this.logMath.logToLinear(logbgprob);
                double backoffbgprob = ugbackoff * ugprob;
                double logbackoffbgprob = this.logMath.linearToLog(backoffbgprob);
                int n = i;
                ugNumerator[n] = ugNumerator[n] + (bgprob * (double)logbgprob - backoffbgprob * logbackoffbgprob) * (double)logugprob;
                int n2 = i;
                ugDenominator[n2] = ugDenominator[n2] + (bgprob - backoffbgprob) * (double)logugprob;
            }
            int n = i;
            ugNumerator[n] = ugNumerator[n] + ugbackoff * ((double)logugbackoff * S0 + R0);
            ugAvgLogProb[i] = ugDenominator[i] + ugbackoff * S0;
            int n3 = i;
            ugDenominator[n3] = ugDenominator[n3] + ugbackoff * R0;
            this.unigramSmearTerm[i] = (float)(ugNumerator[i] / ugDenominator[i]);
        }
        for (i = 0; i < this.loadedBigramBuffers.length; ++i) {
            System.out.println("Processed " + i + " of " + this.loadedBigramBuffers.length);
            NGramBuffer bigram = this.getBigramBuffer(i);
            if (bigram == null) continue;
            for (int j = 0; j < bigram.getNumberNGrams(); ++j) {
                float smearTerm;
                NGramProbability bgProb = bigram.getNGramProbability(j);
                float logbgbackoff = this.ngramBackoffTable[2][bgProb.getBackoffID()];
                double bgbackoff = this.logMath.logToLinear(logbgbackoff);
                int k = bigram.getWordID(j);
                NGramBuffer trigram = this.loadTrigramBuffer(i, k);
                if (trigram == null) {
                    smearTerm = this.unigramSmearTerm[k];
                } else {
                    double bg_numerator = 0.0;
                    double bg_denominator = 0.0;
                    for (int l = 0; l < trigram.getNumberNGrams(); ++l) {
                        int m = trigram.getWordID(l);
                        float logtgprob = this.ngramProbTable[2][trigram.getProbabilityID(l)];
                        double tgprob = this.logMath.logToLinear(logtgprob);
                        float logbgprob = this.getBigramProb(k, m);
                        double bgprob = this.logMath.logToLinear(logbgprob);
                        float logugprob = this.unigrams[m].getLogProbability();
                        double backofftgprob = bgbackoff * bgprob;
                        double logbackofftgprob = this.logMath.linearToLog(backofftgprob);
                        bg_numerator += (tgprob * (double)logtgprob - backofftgprob * logbackofftgprob) * (double)logugprob;
                        bg_denominator += (tgprob - backofftgprob) * (double)logugprob * (double)logugprob;
                    }
                    smearTerm = (float)((bg_numerator += bgbackoff * ((double)logbgbackoff * ugAvgLogProb[k] - ugNumerator[k])) / (bg_denominator += bgbackoff * ugDenominator[k]));
                    ++this.smearTermCount;
                }
                this.putSmearTerm(i, k, smearTerm);
            }
        }
        System.out.println("Smear count is " + this.smearTermCount);
    }

    private void dumpProbs(double[] ugNumerator, double[] ugDenominator, int i, int j, float logugprob, float logbgprob, double ugprob, double bgprob, double backoffbgprob, double logbackoffbgprob) {
        System.out.println("ubo " + ugprob + ' ' + bgprob + ' ' + backoffbgprob);
        System.out.println("logubo " + logugprob + ' ' + logbgprob + ' ' + logbackoffbgprob);
        System.out.println("n/d " + j + ' ' + ugNumerator[i] + ' ' + ugDenominator[i]);
        System.out.print(ugprob + " " + bgprob + ' ' + backoffbgprob);
        System.out.print(" " + logugprob + ' ' + logbgprob + ' ' + logbackoffbgprob);
        System.out.println("  " + ugNumerator[i] + ' ' + ugDenominator[i]);
    }

    private void writeSmearInfo(String filename) throws IOException {
        int i;
        DataOutputStream out = new DataOutputStream(new FileOutputStream(filename));
        out.writeInt(-1060454374);
        System.out.println("writing " + this.unigrams.length);
        out.writeInt(this.unigrams.length);
        for (i = 0; i < this.unigrams.length; ++i) {
            out.writeFloat(this.unigramSmearTerm[i]);
        }
        for (i = 0; i < this.unigrams.length; ++i) {
            System.out.println("Writing " + i + " of " + this.unigrams.length);
            NGramBuffer bigram = this.getBigramBuffer(i);
            if (bigram == null) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(bigram.getNumberNGrams());
            for (int j = 0; j < bigram.getNumberNGrams(); ++j) {
                int k = bigram.getWordID(j);
                Float smearTerm = this.getSmearTerm(i, k);
                out.writeInt(k);
                out.writeFloat(smearTerm.floatValue());
            }
        }
        out.close();
    }

    private void readSmearInfo(String filename) throws IOException {
        int i;
        DataInputStream in = new DataInputStream(new FileInputStream(filename));
        if (in.readInt() != -1060454374) {
            in.close();
            throw new IOException("Bad smear format for " + filename);
        }
        if (in.readInt() != this.unigrams.length) {
            in.close();
            throw new IOException("Bad unigram length in " + filename);
        }
        this.bigramSmearMap = new HashMap<Long, Float>();
        this.unigramSmearTerm = new float[this.unigrams.length];
        System.out.println("Reading " + this.unigrams.length);
        for (i = 0; i < this.unigrams.length; ++i) {
            this.unigramSmearTerm[i] = in.readFloat();
        }
        for (i = 0; i < this.unigrams.length; ++i) {
            System.out.println("Processed " + i + " of " + this.loadedBigramBuffers.length);
            int numBigrams = in.readInt();
            NGramBuffer bigram = this.getBigramBuffer(i);
            if (bigram.getNumberNGrams() != numBigrams) {
                in.close();
                throw new IOException("Bad ngrams for unigram " + i + " Found " + numBigrams + " expected " + bigram.getNumberNGrams());
            }
            for (int j = 0; j < numBigrams; ++j) {
                int k = bigram.getWordID(j);
                this.putSmearTerm(i, k, in.readFloat());
            }
        }
        in.close();
    }

    private void putSmearTerm(int word1, int word2, float smearTerm) {
        long bigramID = (long)word1 << 32 | (long)word2;
        this.bigramSmearMap.put(bigramID, Float.valueOf(smearTerm));
    }

    private Float getSmearTerm(int word1, int word2) {
        long bigramID = (long)word1 << 32 | (long)word2;
        return this.bigramSmearMap.get(bigramID);
    }

    private float getBigramProb(int word1, int word2) {
        NGramBuffer bigram = this.getBigramBuffer(word1);
        NGramProbability bigramProbability = bigram.findNGram(word2);
        return this.ngramProbTable[1][bigramProbability.getProbabilityID()];
    }
}

