/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.classes;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.classes.ClassMap;
import edu.cmu.sphinx.linguist.language.classes.ClassProbability;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ClassBasedLanguageModel
implements LanguageModel {
    @S4Component(type=LanguageModel.class)
    public static final String PROP_CLASS_LANGUAGE_MODEL = "classLanguageModel";
    @S4Component(type=ClassMap.class)
    public static final String PROP_CLASS_MAP = "classMap";
    private LanguageModel classLM;
    private Set<String> vocabulary;
    private boolean allocated = false;
    private ClassMap classMap;

    public ClassBasedLanguageModel(ClassMap classMap, LanguageModel classLM) {
        this.classMap = classMap;
        this.classLM = classLM;
    }

    public ClassBasedLanguageModel() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        if (this.allocated) {
            throw new PropertyException(ClassBasedLanguageModel.class.getName(), null, "Can't change properties after allocation");
        }
        this.classMap = (ClassMap)ps.getComponent(PROP_CLASS_MAP);
        this.classLM = (LanguageModel)ps.getComponent(PROP_CLASS_LANGUAGE_MODEL);
    }

    @Override
    public void allocate() throws IOException {
        if (!this.allocated) {
            this.allocated = true;
            this.classMap.allocate();
            this.classLM.allocate();
            this.makeVocabulary();
        }
    }

    @Override
    public void deallocate() throws IOException {
        this.allocated = false;
        this.classLM.deallocate();
        this.classMap.deallocate();
        this.vocabulary = null;
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        Word[] classes = new Word[wordSequence.size()];
        float wordToClassProb = 0.0f;
        for (int i = 0; i < classes.length; ++i) {
            Word sourceWord = wordSequence.getWord(i);
            ClassProbability classProbability = this.classMap.getClassProbability(sourceWord.getSpelling());
            Word word = classes[i] = classProbability == null ? sourceWord : this.classMap.getClassAsWord(classProbability.getClassName());
            if (i != classes.length - 1 || classProbability == null) continue;
            wordToClassProb = classProbability.getLogProbability();
        }
        float classBasedProbability = this.classLM.getProbability(new WordSequence(classes));
        return classBasedProbability + wordToClassProb;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 0.0f;
    }

    @Override
    public Set<String> getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public int getMaxDepth() {
        return this.classLM.getMaxDepth();
    }

    @Override
    public void onUtteranceEnd() {
    }

    private void makeVocabulary() {
        this.vocabulary = new HashSet<String>();
        for (String name : this.classLM.getVocabulary()) {
            Set<String> wordsInClass = this.classMap.getWordsInClass(name);
            if (wordsInClass == null) {
                this.vocabulary.add(name);
                continue;
            }
            this.vocabulary.addAll(wordsInClass);
        }
    }
}

