/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.flat.AlternativeState;
import edu.cmu.sphinx.linguist.flat.GrammarState;
import edu.cmu.sphinx.linguist.flat.PronunciationState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.linguist.flat.UnitState;
import edu.cmu.sphinx.linguist.flat.WordState;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import java.util.ArrayList;
import java.util.List;

public class GrammarPoint {
    private GrammarNode node;
    private int alternativeIndex;
    private int wordIndex;
    private int pronunciationIndex;
    private int unitIndex;
    private static boolean bounded;

    public GrammarPoint(SentenceHMMState state) {
        while (state != null) {
            if (state instanceof UnitState) {
                this.unitIndex = state.getWhich();
            } else if (state instanceof PronunciationState) {
                this.pronunciationIndex = state.getWhich();
            } else if (state instanceof WordState) {
                this.wordIndex = state.getWhich();
            } else if (state instanceof AlternativeState) {
                this.alternativeIndex = state.getWhich();
            } else if (state instanceof GrammarState) {
                this.node = ((GrammarState)state).getGrammarNode();
            }
            state = state.getParent();
        }
        assert (this.node != null);
    }

    public GrammarPoint(GrammarNode node) {
        this(node, -1, 0, 0, 0);
    }

    public GrammarPoint(PronunciationState state, int which) {
        this(state);
        this.unitIndex = which;
    }

    public GrammarPoint(GrammarNode node, int alternativeIndex, int wordIndex, int pronunciationIndex, int unitIndex) {
        assert (node != null);
        this.node = node;
        this.alternativeIndex = alternativeIndex;
        this.wordIndex = wordIndex;
        this.pronunciationIndex = pronunciationIndex;
        this.unitIndex = unitIndex;
    }

    private Unit getUnit() {
        Unit[] units;
        Pronunciation[] pronunciations;
        Word[] words;
        Unit unit = null;
        Word[][] alternatives = this.node.getAlternatives();
        if (this.alternativeIndex != -1 && this.alternativeIndex < alternatives.length && this.wordIndex < (words = alternatives[this.alternativeIndex]).length && this.pronunciationIndex < (pronunciations = words[this.wordIndex].getPronunciations()).length && this.unitIndex < (units = pronunciations[this.pronunciationIndex].getUnits()).length) {
            unit = units[this.unitIndex];
        }
        return unit;
    }

    private Unit getUnitOrFill() {
        Unit unit = this.getUnit();
        if (unit == null) {
            unit = UnitManager.SILENCE;
        }
        return unit;
    }

    public List<Unit[]> getRightContexts(int size, boolean startWithCurrent, int maxContexts) {
        ArrayList<Unit[]> contexts = new ArrayList<Unit[]>();
        List<GrammarPoint> nextPoints = this.getNextGrammarPoints(startWithCurrent);
        if (nextPoints.isEmpty()) {
            Unit[] units = Unit.getEmptyContext(size);
            this.addContext(contexts, units);
        } else {
            for (GrammarPoint gp : nextPoints) {
                if (size == 1) {
                    Unit[] units = new Unit[size];
                    units[0] = gp.getUnitOrFill();
                    this.addContext(contexts, units);
                } else {
                    List<Unit[]> rc = gp.getRightContexts(size - 1, false, maxContexts - contexts.size());
                    for (Unit[] rcUnits : rc) {
                        Unit[] units = Unit.getEmptyContext(rcUnits.length + 1);
                        units[0] = gp.getUnitOrFill();
                        System.arraycopy(rcUnits, 0, units, 1, rcUnits.length);
                        this.addContext(contexts, units);
                    }
                }
                if (contexts.size() < maxContexts) continue;
                break;
            }
        }
        return contexts;
    }

    private void addContext(List<Unit[]> contexts, Unit[] units) {
        for (Unit[] onList : contexts) {
            if (!Unit.isContextMatch(onList, units)) continue;
            return;
        }
        contexts.add(units);
    }

    private List<GrammarPoint> getNextGrammarPoints(boolean startWithCurrent) {
        ArrayList<GrammarPoint> nextPoints = new ArrayList<GrammarPoint>();
        int unitsLength = 0;
        if (this.alternativeIndex == -1 && this.node.getAlternatives().length > 0) {
            for (int i = 0; i < this.node.getAlternatives().length; ++i) {
                GrammarPoint gp = new GrammarPoint(this.node, i, 0, 0, 0);
                nextPoints.add(gp);
            }
        } else if (this.node.getAlternatives().length == 0) {
            GrammarPoint.addNextGrammarPointsWithWords(this.node, nextPoints);
        } else {
            GrammarPoint next = startWithCurrent ? this : new GrammarPoint(this.node, this.alternativeIndex, this.wordIndex, this.pronunciationIndex, this.unitIndex + 1);
            Pronunciation[] pronunciations = this.node.getAlternatives()[this.alternativeIndex][this.wordIndex].getPronunciations();
            unitsLength = pronunciations[this.pronunciationIndex].getUnits().length;
            if (next.unitIndex < unitsLength) {
                nextPoints.add(next);
            } else {
                next.unitIndex = 0;
                Word[] alternative = next.node.getAlternatives()[this.alternativeIndex];
                if (++next.wordIndex < alternative.length) {
                    Word word = alternative[next.wordIndex];
                    for (int i = 0; i < word.getPronunciations().length; ++i) {
                        GrammarPoint newGP = new GrammarPoint(next.node, next.alternativeIndex, next.wordIndex, i, 0);
                        nextPoints.add(newGP);
                    }
                } else if (!bounded) {
                    GrammarPoint.addNextGrammarPointsWithWords(next.node, nextPoints);
                }
            }
        }
        return nextPoints;
    }

    private static List<GrammarNode> getNextGrammarNodesWithWords(GrammarNode node) {
        ArrayList<GrammarNode> list = new ArrayList<GrammarNode>();
        for (GrammarArc arc : node.getSuccessors()) {
            GrammarNode gnode = arc.getGrammarNode();
            if (gnode.getAlternatives().length == 0) {
                if (gnode.isFinalNode()) {
                    list.add(gnode);
                    continue;
                }
                list.addAll(GrammarPoint.getNextGrammarNodesWithWords(gnode));
                continue;
            }
            list.add(gnode);
        }
        return list;
    }

    private static void addNextGrammarPointsWithWords(GrammarNode node, List<GrammarPoint> nextPoints) {
        for (GrammarNode nextNode : GrammarPoint.getNextGrammarNodesWithWords(node)) {
            for (int j = 0; j < nextNode.getAlternatives().length; ++j) {
                GrammarPoint gp = new GrammarPoint(nextNode, j, 0, 0, 0);
                nextPoints.add(gp);
            }
        }
    }

    static void setBounded(boolean state) {
        bounded = state;
    }
}

