/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.dflat;

import edu.cmu.sphinx.decoder.scorer.ScoreProvider;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import java.util.ArrayList;
import java.util.Iterator;

public class OutOfGrammarGraph {
    private final AcousticModel acousticModel;
    private final float logOutOfGrammarBranchProbability;
    private final float logPhoneInsertionProbability;
    private static final SearchStateArc[] EMPTY_ARCS = new SearchStateArc[0];
    private final FirstBranchState fbs;
    private final LastBranchState lbs;
    private final UnknownWordState uws;
    private final SearchStateArc[] lbsArcSet;

    public OutOfGrammarGraph(AcousticModel model, float logOutOfGrammarBranchProbability, float logPhoneInsertionProbability) {
        this.acousticModel = model;
        this.logOutOfGrammarBranchProbability = logOutOfGrammarBranchProbability;
        this.logPhoneInsertionProbability = logPhoneInsertionProbability;
        this.fbs = new FirstBranchState();
        this.lbs = new LastBranchState();
        this.uws = new UnknownWordState();
        this.lbsArcSet = new SearchStateArc[1];
        this.lbsArcSet[0] = this.lbs;
    }

    public SearchStateArc getOutOfGrammarGraph() {
        return this.uws;
    }

    abstract class OogSearchState
    implements SearchState,
    SearchStateArc {
        static final int ANY = 0;

        OogSearchState() {
        }

        @Override
        public abstract SearchStateArc[] getSuccessors();

        @Override
        public abstract String getSignature();

        @Override
        public abstract int getOrder();

        @Override
        public boolean isEmitting() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public Object getLexState() {
            return null;
        }

        @Override
        public String toPrettyString() {
            return this.toString();
        }

        public String toString() {
            return this.getSignature();
        }

        @Override
        public WordSequence getWordHistory() {
            return null;
        }

        @Override
        public SearchState getState() {
            return this;
        }

        @Override
        public float getProbability() {
            return this.getLanguageProbability() + this.getInsertionProbability();
        }

        @Override
        public float getLanguageProbability() {
            return 0.0f;
        }

        @Override
        public float getInsertionProbability() {
            return 0.0f;
        }
    }

    class FinalState
    extends OogSearchState {
        FinalState() {
        }

        @Override
        public int getOrder() {
            return 2;
        }

        @Override
        public String getSignature() {
            return "oogFinal";
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            return EMPTY_ARCS;
        }
    }

    class LastBranchState
    extends OogSearchState {
        private final SearchStateArc[] successors = new SearchStateArc[2];

        LastBranchState() {
            this.successors[0] = OutOfGrammarGraph.this.fbs;
            this.successors[1] = new FinalState();
        }

        @Override
        public int getOrder() {
            return 1;
        }

        @Override
        public String getSignature() {
            return "oogLBS";
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            return this.successors;
        }
    }

    class OogHMMState
    extends OogSearchState
    implements HMMSearchState,
    ScoreProvider {
        final HMMState hmmState;
        final float logProbability;

        OogHMMState(HMMState hmmState, float logProbability) {
            this.hmmState = hmmState;
            this.logProbability = logProbability;
        }

        @Override
        public String getSignature() {
            return "oog-" + this.hmmState;
        }

        @Override
        public HMMState getHMMState() {
            return this.hmmState;
        }

        @Override
        public boolean isEmitting() {
            return this.hmmState.isEmitting();
        }

        public int hashCode() {
            return 191 + this.hmmState.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof OogHMMState) {
                OogHMMState other = (OogHMMState)o;
                return other.hmmState == this.hmmState;
            }
            return false;
        }

        @Override
        public int getOrder() {
            return this.isEmitting() ? 4 : 0;
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            if (this.hmmState.isExitState()) {
                return OutOfGrammarGraph.this.lbsArcSet;
            }
            HMMStateArc[] arcs = this.hmmState.getSuccessors();
            SearchStateArc[] successors = new SearchStateArc[arcs.length];
            for (int i = 0; i < arcs.length; ++i) {
                successors[i] = new OogHMMState(arcs[i].getHMMState(), arcs[i].getLogProbability());
            }
            return successors;
        }

        @Override
        public float getScore(Data data) {
            return this.hmmState.getScore(data);
        }

        @Override
        public float[] getComponentScore(Data data) {
            return this.hmmState.calculateComponentScore(data);
        }
    }

    class OogHMM
    extends OogSearchState
    implements UnitSearchState {
        private final HMM hmm;
        private final SearchStateArc[] successors;

        OogHMM(Unit unit) {
            this.hmm = OutOfGrammarGraph.this.acousticModel.lookupNearestHMM(unit, HMMPosition.UNDEFINED, false);
            this.successors = new SearchStateArc[1];
            this.successors[0] = new OogHMMState(this.hmm.getInitialState(), 0.0f);
        }

        @Override
        public Unit getUnit() {
            return this.hmm.getBaseUnit();
        }

        @Override
        public int getOrder() {
            return 3;
        }

        @Override
        public String getSignature() {
            return "oogHMM-" + this.getUnit();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            return this.successors;
        }

        @Override
        public float getInsertionProbability() {
            return OutOfGrammarGraph.this.logPhoneInsertionProbability;
        }
    }

    class FirstBranchState
    extends OogSearchState {
        private final SearchStateArc[] successors;

        FirstBranchState() {
            ArrayList<OogHMM> successorList = new ArrayList<OogHMM>();
            Iterator<Unit> i = OutOfGrammarGraph.this.acousticModel.getContextIndependentUnitIterator();
            while (i.hasNext()) {
                Unit unit = i.next();
                OogHMM hmm = new OogHMM(unit);
                successorList.add(hmm);
            }
            this.successors = successorList.toArray(new SearchStateArc[successorList.size()]);
        }

        @Override
        public int getOrder() {
            return 2;
        }

        @Override
        public String getSignature() {
            return "oogFBS";
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            return this.successors;
        }
    }

    class UnknownWordState
    extends OogSearchState
    implements WordSearchState {
        private final SearchStateArc[] successors = new SearchStateArc[1];

        UnknownWordState() {
            this.successors[0] = OutOfGrammarGraph.this.fbs;
        }

        @Override
        public Pronunciation getPronunciation() {
            return Word.UNKNOWN.getPronunciations()[0];
        }

        @Override
        public int getOrder() {
            return 1;
        }

        @Override
        public String getSignature() {
            return "oogUNK";
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            return this.successors;
        }

        @Override
        public float getLanguageProbability() {
            return OutOfGrammarGraph.this.logOutOfGrammarBranchProbability;
        }

        @Override
        public boolean isWordStart() {
            return true;
        }
    }
}

