/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.allphone;

import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.allphone.AllphoneLinguist;
import edu.cmu.sphinx.linguist.allphone.PhoneHmmSearchState;
import edu.cmu.sphinx.linguist.allphone.PhoneNonEmittingSearchState;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import java.util.ArrayList;

public class PhoneWordSearchState
extends PhoneNonEmittingSearchState
implements WordSearchState {
    public PhoneWordSearchState(Unit unit, AllphoneLinguist linguist, float insertionProb, float languageProb) {
        super(unit, linguist, insertionProb, languageProb);
    }

    @Override
    public SearchStateArc[] getSuccessors() {
        ArrayList<PhoneHmmSearchState> result = new ArrayList<PhoneHmmSearchState>();
        Unit rc = UnitManager.SILENCE;
        Unit base = this.unit.getBaseUnit();
        if (this.unit.isContextDependent()) {
            rc = ((LeftRightContext)this.unit.getContext()).getRightContext()[0];
        }
        ArrayList<HMM> successors = this.linguist.useContextDependentPhones() ? this.linguist.getCDSuccessors(base, rc) : this.linguist.getCISuccessors();
        for (HMM successor : successors) {
            result.add(new PhoneHmmSearchState(successor.getInitialState(), this.linguist, this.linguist.getPhoneInsertionProb(), 0.0f));
        }
        return result.toArray(new SearchStateArc[result.size()]);
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public Pronunciation getPronunciation() {
        Unit[] pronUnits = new Unit[]{this.unit};
        Pronunciation p = new Pronunciation(pronUnits, "", 1.0f);
        p.setWord(new Word(this.unit.getName(), null, false));
        return p;
    }

    @Override
    public boolean isWordStart() {
        return false;
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PhoneWordSearchState)) {
            return false;
        }
        boolean haveSameBaseId = ((PhoneWordSearchState)obj).unit.getBaseID() == this.unit.getBaseID();
        boolean haveSameContex = ((PhoneWordSearchState)obj).unit.getContext().equals(this.unit.getContext());
        return haveSameBaseId && haveSameContex;
    }

    @Override
    public int hashCode() {
        return this.unit.getContext().hashCode() * 91 + this.unit.getBaseID();
    }
}

