/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.util.LogMath;

public class PrunableMixtureComponent
extends MixtureComponent {
    private float score = -3.4028235E38f;
    private float partScore = -3.4028235E38f;
    private int id;

    public PrunableMixtureComponent(float[] mean, float[][] meanTransformationMatrix, float[] meanTransformationVector, float[] variance, float[][] varianceTransformationMatrix, float[] varianceTransformationVector, float distFloor, float varianceFloor, int id) {
        super(mean, meanTransformationMatrix, meanTransformationVector, variance, varianceTransformationMatrix, varianceTransformationVector, distFloor, varianceFloor);
        this.id = id;
    }

    private float convertScore(float val) {
        val = LogMath.getLogMath().lnToLog(val);
        if (Float.isNaN(val)) {
            System.out.println("gs is Nan, converting to 0");
            val = -3.4028235E38f;
        }
        if (val < this.distFloor) {
            val = this.distFloor;
        }
        return val;
    }

    public boolean isTopComponent(float[] feature, float threshold) {
        float logDval = this.logPreComputedGaussianFactor;
        for (int i = 0; i < feature.length; ++i) {
            float logDiff = feature[i] - this.meanTransformed[i];
            if (!((logDval += logDiff * logDiff * this.precisionTransformed[i]) < threshold)) continue;
            return false;
        }
        this.partScore = logDval;
        this.score = this.convertScore(logDval);
        return true;
    }

    public void updateScore(float[] feature) {
        float logDval = this.logPreComputedGaussianFactor;
        for (int i = 0; i < feature.length; ++i) {
            float logDiff = feature[i] - this.meanTransformed[i];
            logDval += logDiff * logDiff * this.precisionTransformed[i];
        }
        this.partScore = logDval;
        this.score = this.convertScore(logDval);
    }

    public float getStoredScore() {
        return this.score;
    }

    public float getPartialScore() {
        return this.partScore;
    }

    public int getId() {
        return this.id;
    }
}

