/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.CompositeSenone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TiedStateAcousticModel
implements AcousticModel {
    @S4Component(type=Loader.class)
    public static final String PROP_LOADER = "loader";
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4Boolean(defaultValue=true)
    public static final String PROP_USE_COMPOSITES = "useComposites";
    protected String name;
    protected Logger logger;
    protected Loader loader;
    protected UnitManager unitManager;
    private boolean useComposites;
    private Properties properties;
    private final transient Map<String, SenoneSequence> compositeSenoneSequenceCache = new HashMap<String, SenoneSequence>();
    private boolean allocated;

    public TiedStateAcousticModel(Loader loader, UnitManager unitManager, boolean useComposites) {
        this.loader = loader;
        this.unitManager = unitManager;
        this.useComposites = useComposites;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public TiedStateAcousticModel() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.loader = (Loader)ps.getComponent(PROP_LOADER);
        this.unitManager = (UnitManager)ps.getComponent(PROP_UNIT_MANAGER);
        this.useComposites = ps.getBoolean(PROP_USE_COMPOSITES);
        this.logger = ps.getLogger();
    }

    @Override
    public void allocate() throws IOException {
        if (!this.allocated) {
            this.loader.load();
            this.logInfo();
            this.allocated = true;
        }
    }

    @Override
    public void deallocate() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    private HMM getCompositeHMM(Unit unit, HMMPosition position) {
        Unit ciUnit = this.unitManager.getUnit(unit.getName(), unit.isFiller(), Context.EMPTY_CONTEXT);
        SenoneSequence compositeSequence = this.getCompositeSenoneSequence(unit, position);
        SenoneHMM contextIndependentHMM = (SenoneHMM)this.lookupNearestHMM(ciUnit, HMMPosition.UNDEFINED, true);
        float[][] tmat = contextIndependentHMM.getTransitionMatrix();
        return new SenoneHMM(unit, compositeSequence, tmat, position);
    }

    @Override
    public HMM lookupNearestHMM(Unit unit, HMMPosition position, boolean exactMatch) {
        if (exactMatch) {
            return this.lookupHMM(unit, position);
        }
        HMMManager mgr = this.loader.getHMMManager();
        HMM hmm = mgr.get(position, unit);
        if (hmm != null) {
            return hmm;
        }
        if (this.useComposites && hmm == null && this.isComposite(unit) && (hmm = this.getCompositeHMM(unit, position)) != null) {
            mgr.put(hmm);
        }
        if (hmm == null) {
            hmm = this.getHMMAtAnyPosition(unit);
        }
        if (hmm == null) {
            hmm = this.getHMMInSilenceContext(unit, position);
        }
        if (hmm == null) {
            Unit ciUnit = this.lookupUnit(unit.getName());
            assert (unit.isContextDependent());
            if (ciUnit == null) {
                this.logger.severe("Can't find HMM for " + unit.getName());
            }
            assert (ciUnit != null);
            assert (!ciUnit.isContextDependent());
            hmm = mgr.get(HMMPosition.UNDEFINED, ciUnit);
        }
        assert (hmm != null);
        return hmm;
    }

    private boolean isComposite(Unit unit) {
        if (unit.isFiller()) {
            return false;
        }
        Context context = unit.getContext();
        if (context instanceof LeftRightContext) {
            LeftRightContext lrContext = (LeftRightContext)context;
            if (lrContext.getRightContext() == null) {
                return true;
            }
            if (lrContext.getLeftContext() == null) {
                return true;
            }
        }
        return false;
    }

    private Unit lookupUnit(String name) {
        return this.loader.getContextIndependentUnits().get(name);
    }

    @Override
    public Iterator<HMM> getHMMIterator() {
        return this.loader.getHMMManager().iterator();
    }

    @Override
    public Iterator<Unit> getContextIndependentUnitIterator() {
        return this.loader.getContextIndependentUnits().values().iterator();
    }

    public SenoneSequence getCompositeSenoneSequence(Unit unit, HMMPosition position) {
        String unitStr = unit.toString();
        SenoneSequence compositeSenoneSequence = this.compositeSenoneSequenceCache.get(unitStr);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("getCompositeSenoneSequence: " + unit + compositeSenoneSequence == null ? "" : "Cached");
        }
        if (compositeSenoneSequence != null) {
            return compositeSenoneSequence;
        }
        Context context = unit.getContext();
        ArrayList<SenoneSequence> senoneSequenceList = new ArrayList<SenoneSequence>();
        Iterator<HMM> i = this.getHMMIterator();
        while (i.hasNext()) {
            Unit hmmUnit;
            SenoneHMM hmm = (SenoneHMM)i.next();
            if (hmm.getPosition() != position || !(hmmUnit = hmm.getUnit()).isPartialMatch(unit.getName(), context)) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("collected: " + hmm.getUnit());
            }
            senoneSequenceList.add(hmm.getSenoneSequence());
        }
        if (senoneSequenceList.isEmpty()) {
            Unit ciUnit = this.unitManager.getUnit(unit.getName(), unit.isFiller());
            SenoneHMM baseHMM = this.lookupHMM(ciUnit, HMMPosition.UNDEFINED);
            senoneSequenceList.add(baseHMM.getSenoneSequence());
        }
        int longestSequence = 0;
        for (SenoneSequence ss : senoneSequenceList) {
            if (ss.getSenones().length <= longestSequence) continue;
            longestSequence = ss.getSenones().length;
        }
        ArrayList<CompositeSenone> compositeSenones = new ArrayList<CompositeSenone>();
        float logWeight = 0.0f;
        for (int i2 = 0; i2 < longestSequence; ++i2) {
            HashSet<Senone> compositeSenoneSet = new HashSet<Senone>();
            for (SenoneSequence senoneSequence : senoneSequenceList) {
                if (i2 >= senoneSequence.getSenones().length) continue;
                Senone senone = senoneSequence.getSenones()[i2];
                compositeSenoneSet.add(senone);
            }
            compositeSenones.add(CompositeSenone.create(compositeSenoneSet, logWeight));
        }
        compositeSenoneSequence = SenoneSequence.create(compositeSenones);
        this.compositeSenoneSequenceCache.put(unit.toString(), compositeSenoneSequence);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(unit + " consists of " + compositeSenones.size() + " composite senones");
            if (this.logger.isLoggable(Level.FINEST)) {
                compositeSenoneSequence.dump("am");
            }
        }
        return compositeSenoneSequence;
    }

    @Override
    public int getLeftContextSize() {
        return this.loader.getLeftContextSize();
    }

    @Override
    public int getRightContextSize() {
        return this.loader.getRightContextSize();
    }

    private SenoneHMM lookupHMM(Unit unit, HMMPosition position) {
        return (SenoneHMM)this.loader.getHMMManager().get(position, unit);
    }

    public Senone getSenone(long id) {
        return this.loader.getSenonePool().get((int)id);
    }

    protected void logInfo() {
        if (this.loader != null) {
            this.loader.logInfo();
        }
        this.logger.info("CompositeSenoneSequences: " + this.compositeSenoneSequenceCache.size());
    }

    private SenoneHMM getHMMAtAnyPosition(Unit unit) {
        HMMManager mgr = this.loader.getHMMManager();
        for (HMMPosition pos : HMMPosition.values()) {
            SenoneHMM hmm = (SenoneHMM)mgr.get(pos, unit);
            if (hmm == null) continue;
            return hmm;
        }
        return null;
    }

    private SenoneHMM getHMMInSilenceContext(Unit unit, HMMPosition position) {
        SenoneHMM hmm = null;
        HMMManager mgr = this.loader.getHMMManager();
        Context context = unit.getContext();
        if (context instanceof LeftRightContext) {
            LeftRightContext lrContext = (LeftRightContext)context;
            Unit[] lc = lrContext.getLeftContext();
            Unit[] rc = lrContext.getRightContext();
            Unit[] nlc = this.hasNonSilenceFiller(lc) ? this.replaceNonSilenceFillerWithSilence(lc) : lc;
            Unit[] nrc = this.hasNonSilenceFiller(rc) ? this.replaceNonSilenceFillerWithSilence(rc) : rc;
            if (nlc != lc || nrc != rc) {
                LeftRightContext newContext = LeftRightContext.get(nlc, nrc);
                Unit newUnit = this.unitManager.getUnit(unit.getName(), unit.isFiller(), newContext);
                hmm = (SenoneHMM)mgr.get(position, newUnit);
                if (hmm == null) {
                    hmm = this.getHMMAtAnyPosition(newUnit);
                }
            }
        }
        return hmm;
    }

    private boolean hasNonSilenceFiller(Unit[] units) {
        if (units == null) {
            return false;
        }
        for (Unit unit : units) {
            if (!unit.isFiller() || unit.equals(UnitManager.SILENCE)) continue;
            return true;
        }
        return false;
    }

    private Unit[] replaceNonSilenceFillerWithSilence(Unit[] context) {
        Unit[] replacementContext = new Unit[context.length];
        for (int i = 0; i < context.length; ++i) {
            replacementContext[i] = context[i].isFiller() && !context[i].equals(UnitManager.SILENCE) ? UnitManager.SILENCE : context[i];
        }
        return replacementContext;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                this.properties.load(TiedStateAcousticModel.class.getResource("model.props").openStream());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return this.properties;
    }
}

