/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.HMMSet;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.HMMState;

public class SingleHMM {
    private final HMMState[] states;
    private String name = "";
    public float[][] trans;
    private int transidx = -1;
    public int trIdx = -1;
    private int nbEmittingStates;
    public HMMSet hmmset;

    public SingleHMM(int nbStates) {
        this.states = new HMMState[nbStates];
        this.nbEmittingStates = 0;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        String b;
        int m = this.name.indexOf(45);
        if (m < 0) {
            m = -1;
        }
        if ((m = (b = this.name.substring(m + 1)).indexOf(43)) < 0) {
            m = b.length();
        }
        return b.substring(0, m);
    }

    public String getLeft() {
        int m = this.name.indexOf(45);
        if (m < 0) {
            return "-";
        }
        return this.name.substring(0, m);
    }

    public String getRight() {
        int m = this.name.indexOf(43);
        if (m < 0) {
            return "-";
        }
        return this.name.substring(m + 1);
    }

    public void setState(int idx, HMMState st) {
        if (this.states[idx] == null && st != null) {
            ++this.nbEmittingStates;
        }
        this.states[idx] = st;
    }

    public boolean isEmitting(int idx) {
        return this.states[idx] != null;
    }

    public void setTrans(float[][] tr) {
        this.trans = tr;
    }

    public void setTrans(int i) {
        this.trans = null;
        this.transidx = i;
    }

    public int getTransIdx() {
        return this.transidx;
    }

    public float getTrans(int i, int j) {
        if (this.trans == null) {
            this.trans = this.hmmset.transitions.get(this.transidx);
        }
        return this.trans[i][j];
    }

    public HMMState getState(int idx) {
        return this.states[idx];
    }

    public int getNstates() {
        return this.states.length;
    }

    public int getNbEmittingStates() {
        return this.nbEmittingStates;
    }
}

