/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import java.util.Arrays;

public class Unit {
    public static final Unit[] EMPTY_ARRAY = new Unit[0];
    private final String name;
    private final boolean filler;
    private final boolean silence;
    private final int baseID;
    private final Unit baseUnit;
    private final Context context;
    private volatile String key;

    Unit(String name, boolean filler, int id) {
        this.name = name;
        this.filler = filler;
        this.silence = name.equals("SIL");
        this.baseID = id;
        this.baseUnit = this;
        this.context = Context.EMPTY_CONTEXT;
    }

    Unit(Unit baseUnit, boolean filler, Context context) {
        this.name = baseUnit.getName();
        this.filler = filler;
        this.silence = this.name.equals("SIL");
        this.baseID = baseUnit.getBaseID();
        this.baseUnit = baseUnit;
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFiller() {
        return this.filler;
    }

    public boolean isSilence() {
        return this.silence;
    }

    public int getBaseID() {
        return this.baseID;
    }

    public Unit getBaseUnit() {
        return this.baseUnit;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isContextDependent() {
        return this.getContext() != Context.EMPTY_CONTEXT;
    }

    private String getKey() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Unit) {
            Unit otherUnit = (Unit)o;
            return this.getKey().equals(otherUnit.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        if (this.key == null) {
            this.key = this.context == Context.EMPTY_CONTEXT ? (this.filler ? "*" : "") + this.name : (this.filler ? "*" : "") + this.name + '[' + this.context + ']';
        }
        return this.key;
    }

    public boolean isPartialMatch(String name, Context context) {
        return this.getName().equals(name) && context.isPartialMatch(this.context);
    }

    public static Unit[] getEmptyContext(int size) {
        Object[] context = new Unit[size];
        Arrays.fill(context, UnitManager.SILENCE);
        return context;
    }

    public static boolean isContextMatch(Unit[] a, Unit[] b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].getName().equals(b[i].getName())) continue;
            return false;
        }
        return true;
    }
}

