/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class WordSequence
implements Comparable<WordSequence> {
    public static final Comparator<WordSequence> OLDEST_COMPARATOR = new Comparator<WordSequence>(){

        @Override
        public int compare(WordSequence o1, WordSequence o2) {
            return o1.getOldest().compareTo(o2.getOldest());
        }
    };
    public static final WordSequence EMPTY = new WordSequence(0);
    private final Word[] words;
    private transient int hashCode = -1;

    public static WordSequence asWordSequence(Dictionary dictionary, String ... words) {
        Word[] dictWords = new Word[words.length];
        for (int i = 0; i < words.length; ++i) {
            dictWords[i] = dictionary.getWord(words[i]);
        }
        return new WordSequence(dictWords);
    }

    private WordSequence(int size) {
        this.words = new Word[size];
    }

    public WordSequence(Word ... words) {
        this(Arrays.asList(words));
    }

    public WordSequence(List<Word> list) {
        this.words = list.toArray(new Word[list.size()]);
        this.check();
    }

    private void check() {
        for (Word word : this.words) {
            if (word != null) continue;
            throw new Error("WordSequence should not have null Words.");
        }
    }

    public WordSequence addWord(Word word, int maxSize) {
        if (maxSize <= 0) {
            return EMPTY;
        }
        int nextSize = this.size() + 1 > maxSize ? maxSize : this.size() + 1;
        WordSequence next = new WordSequence(nextSize);
        int nextIndex = nextSize - 1;
        int thisIndex = this.size() - 1;
        next.words[nextIndex--] = word;
        while (nextIndex >= 0 && thisIndex >= 0) {
            next.words[nextIndex--] = this.words[thisIndex--];
        }
        next.check();
        return next;
    }

    public WordSequence getOldest() {
        WordSequence next = EMPTY;
        if (this.size() >= 1) {
            next = new WordSequence(this.words.length - 1);
            System.arraycopy(this.words, 0, next.words, 0, next.words.length);
        }
        return next;
    }

    public WordSequence getNewest() {
        WordSequence next = EMPTY;
        if (this.size() >= 1) {
            next = new WordSequence(this.words.length - 1);
            System.arraycopy(this.words, 1, next.words, 0, next.words.length);
        }
        return next;
    }

    public WordSequence trim(int maxSize) {
        if (maxSize <= 0 || this.size() == 0) {
            return EMPTY;
        }
        if (maxSize == this.size()) {
            return this;
        }
        if (maxSize > this.size()) {
            maxSize = this.size();
        }
        WordSequence next = new WordSequence(maxSize);
        int thisIndex = this.words.length - 1;
        int nextIndex = next.words.length - 1;
        for (int i = 0; i < maxSize; ++i) {
            next.words[nextIndex--] = this.words[thisIndex--];
        }
        return next;
    }

    public Word getWord(int n) {
        assert (n < this.words.length);
        return this.words[n];
    }

    public int size() {
        return this.words.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Word word : this.words) {
            sb.append('[').append(word).append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int code = 123;
            for (int i = 0; i < this.words.length; ++i) {
                code += this.words[i].hashCode() * (2 * i + 1);
            }
            this.hashCode = code;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WordSequence)) {
            return false;
        }
        return Arrays.equals(this.words, ((WordSequence)object).words);
    }

    public WordSequence getSubSequence(int startIndex, int stopIndex) {
        ArrayList<Word> subseqWords = new ArrayList<Word>();
        for (int i = startIndex; i < stopIndex; ++i) {
            subseqWords.add(this.getWord(i));
        }
        return new WordSequence(subseqWords);
    }

    public Word[] getWords() {
        return this.getSubSequence((int)0, (int)this.size()).words;
    }

    @Override
    public int compareTo(WordSequence other) {
        int n = Math.min(this.words.length, other.words.length);
        for (int i = 0; i < n; ++i) {
            if (this.words[i].equals(other.words[i])) continue;
            return this.words[i].compareTo(other.words[i]);
        }
        return this.words.length - other.words.length;
    }
}

