/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf.rule;

import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import java.util.List;

public class JSGFRuleAlternatives
extends JSGFRule {
    protected List<JSGFRule> rules;
    protected List<Float> weights;

    public JSGFRuleAlternatives() {
    }

    public JSGFRuleAlternatives(List<JSGFRule> rules) {
        this.setRules(rules);
        this.weights = null;
    }

    public JSGFRuleAlternatives(List<JSGFRule> rules, List<Float> weights) throws IllegalArgumentException {
        assert (rules.size() == weights.size());
        this.setRules(rules);
        this.setWeights(weights);
    }

    public void append(JSGFRule rule) {
        assert (rule != null);
        this.rules.add(rule);
        if (this.weights != null) {
            this.weights.add(Float.valueOf(1.0f));
        }
    }

    public List<JSGFRule> getRules() {
        return this.rules;
    }

    public List<Float> getWeights() {
        return this.weights;
    }

    public void setRules(List<JSGFRule> rules) {
        if (this.weights != null && rules.size() != this.weights.size()) {
            this.weights = null;
        }
        this.rules = rules;
    }

    public void setWeights(List<Float> newWeights) throws IllegalArgumentException {
        if (newWeights == null || newWeights.size() == 0) {
            this.weights = null;
            return;
        }
        if (newWeights.size() != this.rules.size()) {
            throw new IllegalArgumentException("weights/rules array length mismatch");
        }
        float f = 0.0f;
        for (Float w : newWeights) {
            if (Float.isNaN(w.floatValue())) {
                throw new IllegalArgumentException("illegal weight value: NaN");
            }
            if (Float.isInfinite(w.floatValue())) {
                throw new IllegalArgumentException("illegal weight value: infinite");
            }
            if ((double)w.floatValue() < 0.0) {
                throw new IllegalArgumentException("illegal weight value: negative");
            }
            f += w.floatValue();
        }
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException("illegal weight values: all zero");
        }
        this.weights = newWeights;
    }

    @Override
    public String toString() {
        if (this.rules == null || this.rules.size() == 0) {
            return "<VOID>";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.rules.size(); ++i) {
            if (i > 0) {
                sb.append(" | ");
            }
            if (this.weights != null) {
                sb.append("/" + this.weights.get(i) + "/ ");
            }
            JSGFRule r = this.rules.get(i);
            if (this.rules.get(i) instanceof JSGFRuleAlternatives) {
                sb.append("( ").append(r).append(" )");
                continue;
            }
            sb.append(r);
        }
        return sb.toString();
    }
}

