/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf.parser;

import edu.cmu.sphinx.jsgf.JSGFGrammarParseException;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammar;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammarFactory;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammarManager;
import edu.cmu.sphinx.jsgf.parser.JSGFEncoding;
import edu.cmu.sphinx.jsgf.parser.JSGFParserConstants;
import edu.cmu.sphinx.jsgf.parser.JSGFParserTokenManager;
import edu.cmu.sphinx.jsgf.parser.JavaCharStream;
import edu.cmu.sphinx.jsgf.parser.ParseException;
import edu.cmu.sphinx.jsgf.parser.Token;
import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleAlternatives;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleCount;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleName;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleSequence;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleTag;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleToken;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class JSGFParser
implements JSGFParserConstants {
    static final String version = "1.0";
    static JSGFParser parser = null;
    public JSGFParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[26];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("JSGF Parser Version 1.0:  Reading from standard input . . .");
            parser = new JSGFParser(System.in);
        } else {
            if (args.length > 0) {
                System.out.println("JSGF Parser Version 1.0:  Reading from file " + args[0] + " . . .");
                try {
                    InputStreamReader rdr;
                    URL codeBase = null;
                    File f = new File(".");
                    String path = f.getAbsolutePath() + "/" + args[0];
                    try {
                        codeBase = new URL("file:" + path);
                    }
                    catch (MalformedURLException e) {
                        System.out.println("Could not get URL for current directory " + e);
                        return;
                    }
                    BufferedInputStream i = new BufferedInputStream(codeBase.openStream(), 256);
                    JSGFEncoding encoding = JSGFParser.getJSGFEncoding(i);
                    if (encoding != null && encoding.encoding != null) {
                        System.out.println("Grammar Character Encoding \"" + encoding.encoding + "\"");
                        rdr = new InputStreamReader((InputStream)i, encoding.encoding);
                    } else {
                        if (encoding == null) {
                            System.out.println("WARNING: Grammar missing self identifying header");
                        }
                        rdr = new InputStreamReader(i);
                    }
                    parser = new JSGFParser(rdr);
                }
                catch (Exception e) {
                    System.out.println("JSGF Parser Version 1.0:  File " + args[0] + " not found.");
                    return;
                }
            }
            System.out.println("JSGF Parser Version 1.0:  Usage is one of:");
            System.out.println("         java JSGFParser < inputfile");
            System.out.println("OR");
            System.out.println("         java JSGFParser inputfile");
            return;
        }
        try {
            parser.GrammarUnit(new JSGFRuleGrammarFactory(new JSGFRuleGrammarManager()));
            System.out.println("JSGF Parser Version 1.0:  JSGF Grammar parsed successfully.");
        }
        catch (ParseException e) {
            System.out.println("JSGF Parser Version 1.0:  Encountered errors during parse." + e.getMessage());
        }
    }

    public static JSGFRuleGrammar newGrammarFromJSGF(InputStream i, JSGFRuleGrammarFactory factory) throws JSGFGrammarParseException {
        JSGFRuleGrammar grammar = null;
        if (parser == null) {
            parser = new JSGFParser(i);
        } else {
            parser.ReInit(i);
        }
        try {
            grammar = parser.GrammarUnit(factory);
            return grammar;
        }
        catch (ParseException e) {
            Token etoken = e.currentToken;
            JSGFGrammarParseException ge = new JSGFGrammarParseException(etoken.beginLine, etoken.beginColumn, "Grammar Error", e.getMessage());
            throw ge;
        }
    }

    public static JSGFRuleGrammar newGrammarFromJSGF(Reader i, JSGFRuleGrammarFactory factory) throws JSGFGrammarParseException {
        JSGFRuleGrammar grammar = null;
        if (parser == null) {
            parser = new JSGFParser(i);
        } else {
            parser.ReInit(i);
        }
        try {
            grammar = parser.GrammarUnit(factory);
            return grammar;
        }
        catch (ParseException e) {
            Token etoken = e.currentToken;
            JSGFGrammarParseException ge = new JSGFGrammarParseException(etoken.beginLine, etoken.beginColumn, "Grammar Error", e.getMessage());
            throw ge;
        }
    }

    private static JSGFEncoding getJSGFEncoding(BufferedInputStream is) {
        byte[] c;
        int i;
        block28: {
            i = 0;
            byte[] b = new byte[2];
            c = new byte[80];
            is.mark(256);
            try {
                if (is.read(b, 0, 2) != 2) {
                    is.reset();
                    return null;
                }
                if (b[0] == 35 && b[1] == 74) {
                    i = 0;
                    c[i++] = b[0];
                    c[i++] = b[1];
                    while (i < 80) {
                        if (is.read(b, 0, 1) != 1) {
                            is.reset();
                            return null;
                        }
                        if (b[0] != 10 && b[0] != 13) {
                            c[i++] = b[0];
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (b[0] == 35 && b[1] == 0) {
                    i = 0;
                    c[i++] = b[0];
                    while (i < 80) {
                        if (is.read(b, 0, 2) != 2) {
                            is.reset();
                            return null;
                        }
                        if (b[1] != 0) {
                            return null;
                        }
                        if (b[0] != 10 && b[0] != 13) {
                            c[i++] = b[0];
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (b[0] != 0 || b[1] != 35) break block28;
                i = 0;
                c[i++] = b[1];
                while (i < 80) {
                    if (is.read(b, 0, 2) != 2) {
                        is.reset();
                        return null;
                    }
                    if (b[0] != 0) {
                        return null;
                    }
                    if (b[1] != 10 && b[1] != 13) {
                        c[i++] = b[1];
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                try {
                    is.reset();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return null;
            }
        }
        if (i == 0) {
            try {
                is.reset();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            return null;
        }
        String estr = new String(c, 0, i);
        StringTokenizer st = new StringTokenizer(estr, " \t\n\r\f;");
        String id = null;
        String ver = null;
        String enc = null;
        String loc = null;
        if (st.hasMoreTokens()) {
            id = st.nextToken();
        }
        if (!id.equals("#JSGF")) {
            try {
                is.reset();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            return null;
        }
        if (st.hasMoreTokens()) {
            ver = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            enc = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            loc = st.nextToken();
        }
        return new JSGFEncoding(ver, enc, loc);
    }

    public static JSGFRuleGrammar newGrammarFromJSGF(URL url, JSGFRuleGrammarFactory factory) throws JSGFGrammarParseException, IOException {
        InputStreamReader reader;
        BufferedInputStream stream = new BufferedInputStream(url.openStream(), 256);
        JSGFEncoding encoding = JSGFParser.getJSGFEncoding(stream);
        if (encoding != null && encoding.encoding != null) {
            System.out.println("Grammar Character Encoding \"" + encoding.encoding + "\"");
            reader = new InputStreamReader((InputStream)stream, encoding.encoding);
        } else {
            if (encoding == null) {
                System.out.println("WARNING: Grammar missing self identifying header");
            }
            reader = new InputStreamReader(stream);
        }
        return JSGFParser.newGrammarFromJSGF(reader, factory);
    }

    public static JSGFRule ruleForJSGF(String text) {
        JSGFRuleAlternatives r = null;
        try {
            StringReader sread = new StringReader(text);
            if (parser == null) {
                parser = new JSGFParser(sread);
            } else {
                parser.ReInit(sread);
            }
            r = parser.alternatives();
        }
        catch (ParseException e) {
            System.out.println("JSGF Parser Version 1.0:  Encountered errors during parse.");
        }
        return r;
    }

    static void extractKeywords(JSGFRuleGrammar grammar, String rname, String comment) {
        int i = 0;
        while ((i = comment.indexOf("@example ", i) + 9) > 9) {
            int j = Math.max(comment.indexOf(13, i), comment.indexOf(10, i));
            if (j < 0) {
                j = comment.length();
                if (comment.endsWith("*/")) {
                    j -= 2;
                }
            }
            grammar.addSampleSentence(rname, comment.substring(i, j).trim());
            i = j + 1;
        }
    }

    public final JSGFRuleGrammar GrammarUnit(JSGFRuleGrammarFactory factory) throws ParseException {
        JSGFRuleGrammar grammar = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.IdentHeader();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        grammar = this.GrammarDeclaration(factory);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block9;
                }
            }
            this.ImportDeclaration(grammar);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 28: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block10;
                }
            }
            this.RuleDeclaration(grammar);
        }
        this.jj_consume_token(0);
        return grammar;
    }

    public final JSGFRuleGrammar GrammarDeclaration(JSGFRuleGrammarFactory factory) throws ParseException {
        JSGFRuleGrammar grammar = null;
        Token t = null;
        t = this.jj_consume_token(13);
        String s = this.Name();
        this.jj_consume_token(26);
        grammar = factory.newGrammar(s);
        if (grammar != null && t != null && t.specialToken != null && t.specialToken.image != null && t.specialToken.image.startsWith("/**")) {
            JSGFRuleGrammar JG = grammar;
            JG.addGrammarDocComment(t.specialToken.image);
        }
        return grammar;
    }

    public final void IdentHeader() throws ParseException {
        this.jj_consume_token(23);
        this.jj_consume_token(27);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break block0;
                    }
                }
                this.jj_la1[3] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
    }

    public final void ImportDeclaration(JSGFRuleGrammar grammar) throws ParseException {
        boolean all = false;
        Token t = null;
        t = this.jj_consume_token(14);
        this.jj_consume_token(28);
        String name = this.Name();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                this.jj_consume_token(30);
                all = true;
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        this.jj_consume_token(31);
        this.jj_consume_token(26);
        if (all) {
            name = name + ".*";
        }
        JSGFRuleName r = new JSGFRuleName(name);
        if (grammar != null) {
            grammar.addImport(r);
            if (grammar instanceof JSGFRuleGrammar && t != null && t.specialToken != null && t.specialToken.image != null && t.specialToken.image.startsWith("/**")) {
                JSGFRuleGrammar JG = grammar;
                JG.addImportDocComment(r, t.specialToken.image);
            }
        }
    }

    public final String Name() throws ParseException {
        Token t1;
        StringBuilder sb = new StringBuilder();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                t1 = this.jj_consume_token(23);
                break;
            }
            case 15: {
                t1 = this.jj_consume_token(15);
                break;
            }
            case 14: {
                t1 = this.jj_consume_token(14);
                break;
            }
            case 13: {
                t1 = this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        sb.append(t1.image);
        while (this.jj_2_1(2)) {
            this.jj_consume_token(29);
            Token t2 = this.jj_consume_token(23);
            sb.append('.');
            sb.append(t2.image);
        }
        return sb.toString();
    }

    public final void RuleDeclaration(JSGFRuleGrammar grammar) throws ParseException {
        boolean pub = false;
        Token t = null;
        Token t1 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                t = this.jj_consume_token(15);
                pub = true;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        t1 = this.jj_consume_token(28);
        String s = this.ruleDef();
        this.jj_consume_token(31);
        this.jj_consume_token(32);
        JSGFRuleAlternatives r = this.alternatives();
        this.jj_consume_token(26);
        try {
            if (grammar != null) {
                grammar.setRule(s, r, pub);
                String docComment = null;
                if (t != null && t.specialToken != null && t.specialToken.image != null) {
                    docComment = t.specialToken.image;
                } else if (t1 != null && t1.specialToken != null && t1.specialToken.image != null) {
                    docComment = t1.specialToken.image;
                }
                if (docComment != null && docComment.startsWith("/**")) {
                    JSGFParser.extractKeywords(grammar, s, docComment);
                    grammar.addRuleDocComment(s, docComment);
                }
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("ERROR SETTING JSGFRule " + s);
        }
    }

    public final JSGFRuleAlternatives alternatives() throws ParseException {
        ArrayList<JSGFRule> ruleList = new ArrayList<JSGFRule>();
        ArrayList<Float> weights = new ArrayList<Float>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 28: 
            case 36: 
            case 38: {
                JSGFRuleSequence r = this.sequence();
                ruleList.add(r);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: {
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(33);
                    r = this.sequence();
                    ruleList.add(r);
                }
            }
            case 34: {
                float w = this.weight();
                JSGFRuleSequence r = this.sequence();
                ruleList.add(r);
                weights.add(Float.valueOf(w));
                block11: while (true) {
                    this.jj_consume_token(33);
                    w = this.weight();
                    r = this.sequence();
                    ruleList.add(r);
                    weights.add(Float.valueOf(w));
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: {
                            continue block11;
                        }
                    }
                    break;
                }
                this.jj_la1[9] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        JSGFRuleAlternatives ra = new JSGFRuleAlternatives(ruleList);
        if (weights.size() > 0) {
            ra.setWeights(weights);
        }
        return ra;
    }

    public final String ruleDef() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                t = this.jj_consume_token(23);
                break;
            }
            case 16: {
                t = this.jj_consume_token(16);
                break;
            }
            case 15: {
                t = this.jj_consume_token(15);
                break;
            }
            case 14: {
                t = this.jj_consume_token(14);
                break;
            }
            case 13: {
                t = this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    public final JSGFRuleSequence sequence() throws ParseException {
        ArrayList<JSGFRule> ruleList = new ArrayList<JSGFRule>();
        block3: while (true) {
            JSGFRule JSGFRule2 = this.item();
            ruleList.add(JSGFRule2);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 21: 
                case 23: 
                case 28: 
                case 36: 
                case 38: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[12] = this.jj_gen;
        return new JSGFRuleSequence(ruleList);
    }

    public final float weight() throws ParseException {
        Token t;
        this.jj_consume_token(34);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                t = this.jj_consume_token(18);
                break;
            }
            case 16: {
                t = this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(34);
        return Float.valueOf(t.image).floatValue();
    }

    public final JSGFRule item() throws ParseException {
        JSGFRule r;
        ArrayList<String> tags = null;
        int count = -1;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 28: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 21: 
                    case 23: {
                        r = this.terminal();
                        break;
                    }
                    case 28: {
                        r = this.ruleRef();
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: 
                    case 35: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 30: {
                                this.jj_consume_token(30);
                                count = 4;
                                break block9;
                            }
                            case 35: {
                                this.jj_consume_token(35);
                                count = 3;
                                break block9;
                            }
                        }
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        tags = this.tags();
                        break block0;
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                r = this.alternatives();
                this.jj_consume_token(37);
                block19 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: 
                    case 35: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 30: {
                                this.jj_consume_token(30);
                                count = 4;
                                break block19;
                            }
                            case 35: {
                                this.jj_consume_token(35);
                                count = 3;
                                break block19;
                            }
                        }
                        this.jj_la1[18] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        tags = this.tags();
                        break block0;
                    }
                }
                this.jj_la1[20] = this.jj_gen;
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                r = this.alternatives();
                this.jj_consume_token(39);
                count = 2;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        tags = this.tags();
                        break block0;
                    }
                }
                this.jj_la1[21] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (count != -1) {
            r = new JSGFRuleCount(r, count);
        }
        if (tags != null) {
            for (String tag : tags) {
                if (tag.charAt(0) == '{') {
                    tag = tag.substring(1, tag.length() - 1);
                    tag = tag.replace('\\', ' ');
                }
                r = new JSGFRuleTag(r, tag);
            }
        }
        return r;
    }

    public final ArrayList<String> tags() throws ParseException {
        ArrayList<String> tags = new ArrayList<String>();
        block3: while (true) {
            Token token = this.jj_consume_token(22);
            tags.add(token.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[23] = this.jj_gen;
        return tags;
    }

    public final JSGFRule terminal() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                t = this.jj_consume_token(23);
                break;
            }
            case 21: {
                t = this.jj_consume_token(21);
                break;
            }
            case 16: {
                t = this.jj_consume_token(16);
                break;
            }
            case 18: {
                t = this.jj_consume_token(18);
                break;
            }
            case 15: {
                t = this.jj_consume_token(15);
                break;
            }
            case 14: {
                t = this.jj_consume_token(14);
                break;
            }
            case 13: {
                t = this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String tn = t.image;
        if (tn.startsWith("\"") && tn.endsWith("\"")) {
            tn = tn.substring(1, tn.length() - 1);
        }
        JSGFRuleToken rt = new JSGFRuleToken(tn);
        return rt;
    }

    public final JSGFRuleName ruleRef() throws ParseException {
        this.jj_consume_token(28);
        String s = this.Name();
        this.jj_consume_token(31);
        JSGFRuleName rn = new JSGFRuleName(s);
        return rn;
    }

    public final JSGFRuleName importRef() throws ParseException {
        boolean all = false;
        this.jj_consume_token(28);
        String s = this.Name();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                this.jj_consume_token(30);
                all = true;
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        this.jj_consume_token(31);
        if (all) {
            s = s + ".*";
        }
        JSGFRuleName rn = new JSGFRuleName(s);
        return rn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x800000, 16384, 0x10008000, 0x800000, 0x800000, 0x20000000, 0x80E000, 32768, 0, 0, 279306240, 8511488, 279306240, 327680, 279306240, 0x40000000, 0x40000000, 0x400000, 0x40000000, 0x40000000, 0x400000, 0x400000, 279306240, 0x400000, 10870784, 0x20000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 84, 0, 80, 0, 0, 8, 8, 0, 8, 8, 0, 0, 80, 0, 0, 0};
    }

    public JSGFParser(InputStream stream) {
        this(stream, null);
    }

    public JSGFParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JSGFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JSGFParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new JSGFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JSGFParser(JSGFParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(JSGFParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[40];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 26; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 40; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        JSGFParser.jj_la1_init_0();
        JSGFParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

