/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.ConfigurableAdapter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.text.DecimalFormat;

public class MemoryTracker
extends ConfigurableAdapter
implements ResultListener,
StateListener,
Monitor {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_SUMMARY = "showSummary";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_DETAILS = "showDetails";
    private static final DecimalFormat memFormat = new DecimalFormat("0.00 Mb");
    private String name;
    private Recognizer recognizer;
    private boolean showSummary;
    private boolean showDetails;
    private float maxMemoryUsed;
    private int numMemoryStats;
    private float avgMemoryUsed;

    public MemoryTracker(Recognizer recognizer, boolean showSummary, boolean showDetails) {
        this.initRecognizer(recognizer);
        this.initLogger();
        this.showSummary = showSummary;
        this.showDetails = showDetails;
    }

    public MemoryTracker() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        Recognizer newRecognizer = (Recognizer)ps.getComponent(PROP_RECOGNIZER);
        this.initRecognizer(newRecognizer);
        this.showSummary = ps.getBoolean(PROP_SHOW_SUMMARY);
        this.showDetails = ps.getBoolean(PROP_SHOW_DETAILS);
    }

    private void initRecognizer(Recognizer newRecognizer) {
        if (this.recognizer == null) {
            this.recognizer = newRecognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        } else if (this.recognizer != newRecognizer) {
            this.recognizer.removeResultListener(this);
            this.recognizer.removeStateListener(this);
            this.recognizer = newRecognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void calculateMemoryUsage(boolean show) {
        float freeMem;
        float totalMem = (float)Runtime.getRuntime().totalMemory() / 1048576.0f;
        float usedMem = totalMem - (freeMem = (float)Runtime.getRuntime().freeMemory() / 1048576.0f);
        if (usedMem > this.maxMemoryUsed) {
            this.maxMemoryUsed = usedMem;
        }
        ++this.numMemoryStats;
        this.avgMemoryUsed = (this.avgMemoryUsed * (float)(this.numMemoryStats - 1) + usedMem) / (float)this.numMemoryStats;
        if (show) {
            this.logger.info("   Mem  Total: " + memFormat.format(totalMem) + "  " + "Free: " + memFormat.format(freeMem));
            this.logger.info("   Used: This: " + memFormat.format(usedMem) + "  " + "Avg: " + memFormat.format(this.avgMemoryUsed) + "  " + "Max: " + memFormat.format(this.maxMemoryUsed));
        }
    }

    @Override
    public void newResult(Result result) {
        if (result.isFinal()) {
            this.calculateMemoryUsage(this.showDetails);
        }
    }

    @Override
    public void statusChanged(Recognizer.State status) {
        if (status == Recognizer.State.DEALLOCATED) {
            this.calculateMemoryUsage(this.showSummary);
        }
    }
}

