/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.semiring;

import edu.cmu.sphinx.fst.semiring.Semiring;

public class TropicalSemiring
extends Semiring {
    private static final long serialVersionUID = 2711172386738607866L;
    private static float zero = Float.POSITIVE_INFINITY;
    private static float one = 0.0f;

    @Override
    public float plus(float w1, float w2) {
        if (!this.isMember(w1) || !this.isMember(w2)) {
            return Float.NEGATIVE_INFINITY;
        }
        return w1 < w2 ? w1 : w2;
    }

    @Override
    public float times(float w1, float w2) {
        if (!this.isMember(w1) || !this.isMember(w2)) {
            return Float.NEGATIVE_INFINITY;
        }
        return w1 + w2;
    }

    @Override
    public float divide(float w1, float w2) {
        if (!this.isMember(w1) || !this.isMember(w2)) {
            return Float.NEGATIVE_INFINITY;
        }
        if (w2 == zero) {
            return Float.NEGATIVE_INFINITY;
        }
        if (w1 == zero) {
            return zero;
        }
        return w1 - w2;
    }

    @Override
    public float zero() {
        return zero;
    }

    @Override
    public float one() {
        return one;
    }

    @Override
    public boolean isMember(float w) {
        return !Float.isNaN(w) && w != Float.NEGATIVE_INFINITY;
    }

    @Override
    public float reverse(float w1) {
        return w1;
    }
}

