/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.operations.Connect;
import edu.cmu.sphinx.fst.semiring.Semiring;
import java.util.HashMap;

public class RmEpsilon {
    private RmEpsilon() {
    }

    private static void put(State fromState, State toState, float weight, HashMap<State, Float>[] cl) {
        HashMap<State, Float> tmp = cl[fromState.getId()];
        if (tmp == null) {
            cl[fromState.getId()] = tmp = new HashMap();
        }
        tmp.put(toState, Float.valueOf(weight));
    }

    private static void add(State fromState, State toState, float weight, HashMap<State, Float>[] cl, Semiring semiring) {
        Float old = RmEpsilon.getPathWeight(fromState, toState, cl);
        if (old == null) {
            RmEpsilon.put(fromState, toState, weight, cl);
        } else {
            RmEpsilon.put(fromState, toState, semiring.plus(weight, old.floatValue()), cl);
        }
    }

    private static void calcClosure(Fst fst, State state, HashMap<State, Float>[] cl, Semiring semiring) {
        State s = state;
        int numArcs = s.getNumArcs();
        for (int j = 0; j < numArcs; ++j) {
            Arc a = s.getArc(j);
            if (a.getIlabel() != 0 || a.getOlabel() != 0) continue;
            if (cl[a.getNextState().getId()] == null) {
                RmEpsilon.calcClosure(fst, a.getNextState(), cl, semiring);
            }
            if (cl[a.getNextState().getId()] != null) {
                for (State pathFinalState : cl[a.getNextState().getId()].keySet()) {
                    float pathWeight = semiring.times(RmEpsilon.getPathWeight(a.getNextState(), pathFinalState, cl).floatValue(), a.getWeight());
                    RmEpsilon.add(state, pathFinalState, pathWeight, cl, semiring);
                }
            }
            RmEpsilon.add(state, a.getNextState(), a.getWeight(), cl, semiring);
        }
    }

    private static Float getPathWeight(State in, State out, HashMap<State, Float>[] cl) {
        if (cl[in.getId()] != null) {
            return cl[in.getId()].get(out);
        }
        return null;
    }

    public static Fst get(Fst fst) {
        State newState;
        State s;
        int i;
        if (fst == null) {
            return null;
        }
        if (fst.getSemiring() == null) {
            return null;
        }
        Semiring semiring = fst.getSemiring();
        Fst res = new Fst(semiring);
        HashMap[] cl = new HashMap[fst.getNumStates()];
        State[] oldToNewStateMap = new State[fst.getNumStates()];
        State[] newToOldStateMap = new State[fst.getNumStates()];
        int numStates = fst.getNumStates();
        for (i = 0; i < numStates; ++i) {
            s = fst.getState(i);
            newState = new State(s.getFinalWeight());
            res.addState(newState);
            oldToNewStateMap[s.getId()] = newState;
            newToOldStateMap[newState.getId()] = s;
            if (newState.getId() != fst.getStart().getId()) continue;
            res.setStart(newState);
        }
        for (i = 0; i < numStates; ++i) {
            s = fst.getState(i);
            newState = oldToNewStateMap[s.getId()];
            int numArcs = s.getNumArcs();
            for (int j = 0; j < numArcs; ++j) {
                Arc a = s.getArc(j);
                if (a.getIlabel() == 0 && a.getOlabel() == 0) continue;
                newState.addArc(new Arc(a.getIlabel(), a.getOlabel(), a.getWeight(), oldToNewStateMap[a.getNextState().getId()]));
            }
            if (cl[s.getId()] != null) continue;
            RmEpsilon.calcClosure(fst, s, cl, semiring);
        }
        numStates = res.getNumStates();
        for (i = 0; i < numStates; ++i) {
            s = res.getState(i);
            State oldState = newToOldStateMap[s.getId()];
            if (cl[oldState.getId()] == null) continue;
            for (State pathFinalState : cl[oldState.getId()].keySet()) {
                State s1 = pathFinalState;
                if (s1.getFinalWeight() != semiring.zero()) {
                    s.setFinalWeight(semiring.plus(s.getFinalWeight(), semiring.times(RmEpsilon.getPathWeight(oldState, s1, cl).floatValue(), s1.getFinalWeight())));
                }
                int numArcs = s1.getNumArcs();
                for (int j = 0; j < numArcs; ++j) {
                    Arc a = s1.getArc(j);
                    if (a.getIlabel() == 0 && a.getOlabel() == 0) continue;
                    Arc newArc = new Arc(a.getIlabel(), a.getOlabel(), semiring.times(a.getWeight(), RmEpsilon.getPathWeight(oldState, s1, cl).floatValue()), oldToNewStateMap[a.getNextState().getId()]);
                    s.addArc(newArc);
                }
            }
        }
        res.setIsyms(fst.getIsyms());
        res.setOsyms(fst.getOsyms());
        Connect.apply(res);
        return res;
    }
}

