/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.State;
import java.util.Arrays;
import java.util.Comparator;

public class ImmutableState
extends State {
    private Arc[] arcs = null;

    protected ImmutableState() {
    }

    protected ImmutableState(int numArcs) {
        super(0);
        this.initialNumArcs = numArcs;
        this.arcs = new Arc[numArcs];
    }

    @Override
    public void arcSort(Comparator<Arc> cmp) {
        Arrays.sort(this.arcs, cmp);
    }

    @Override
    public void addArc(Arc arc) {
        throw new IllegalArgumentException("You cannot modify an ImmutableState.");
    }

    @Override
    public void setArc(int index, Arc arc) {
        this.arcs[index] = arc;
    }

    @Override
    public Arc deleteArc(int index) {
        throw new IllegalArgumentException("You cannot modify an ImmutableState.");
    }

    public void setArcs(Arc[] arcs) {
        this.arcs = arcs;
    }

    @Override
    public int getNumArcs() {
        return this.initialNumArcs;
    }

    @Override
    public Arc getArc(int index) {
        return this.arcs[index];
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableState other = (ImmutableState)obj;
        if (!Arrays.equals(this.arcs, other.arcs)) {
            return false;
        }
        return super.equals(obj);
    }
}

