/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.ImmutableState;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;

public class ImmutableFst
extends Fst {
    private ImmutableState[] states = null;
    private int numStates;

    private ImmutableFst() {
    }

    private ImmutableFst(int numStates) {
        super(0);
        this.numStates = numStates;
        this.states = new ImmutableState[numStates];
    }

    @Override
    public int getNumStates() {
        return this.numStates;
    }

    @Override
    public ImmutableState getState(int index) {
        return this.states[index];
    }

    @Override
    public void addState(State state) {
        throw new IllegalArgumentException("You cannot modify an ImmutableFst.");
    }

    @Override
    public void saveModel(String filename) throws IOException {
        throw new IllegalArgumentException("You cannot serialize an ImmutableFst.");
    }

    private static ImmutableFst readImmutableFst(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String[] is = ImmutableFst.readStringMap(in);
        String[] os = ImmutableFst.readStringMap(in);
        int startid = in.readInt();
        Semiring semiring = (Semiring)in.readObject();
        int numStates = in.readInt();
        ImmutableFst res = new ImmutableFst(numStates);
        res.isyms = is;
        res.osyms = os;
        res.semiring = semiring;
        for (int i = 0; i < numStates; ++i) {
            int numArcs = in.readInt();
            ImmutableState s = new ImmutableState(numArcs + 1);
            float f = in.readFloat();
            if (f == res.semiring.zero()) {
                f = res.semiring.zero();
            } else if (f == res.semiring.one()) {
                f = res.semiring.one();
            }
            s.setFinalWeight(f);
            s.id = in.readInt();
            res.states[s.getId()] = s;
        }
        res.setStart(res.states[startid]);
        for (ImmutableState s1 : res.states) {
            for (int j = 0; j < s1.initialNumArcs - 1; ++j) {
                Arc a = new Arc();
                a.setIlabel(in.readInt());
                a.setOlabel(in.readInt());
                a.setWeight(in.readFloat());
                a.setNextState(res.states[in.readInt()]);
                s1.setArc(j, a);
            }
        }
        return res;
    }

    public static ImmutableFst loadModel(InputStream inputStream) throws IOException, ClassNotFoundException {
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        bis = new BufferedInputStream(inputStream);
        ois = new ObjectInputStream(bis);
        ImmutableFst obj = ImmutableFst.readImmutableFst(ois);
        ois.close();
        bis.close();
        inputStream.close();
        return obj;
    }

    public static ImmutableFst loadModel(String filename) {
        ImmutableFst obj;
        try {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            ObjectInputStream ois = null;
            fis = new FileInputStream(filename);
            bis = new BufferedInputStream(fis);
            ois = new ObjectInputStream(bis);
            obj = ImmutableFst.readImmutableFst(ois);
            ois.close();
            bis.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return obj;
    }

    @Override
    public void deleteState(State state) {
        throw new IllegalArgumentException("You cannot modify an ImmutableFst.");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fst(start=" + this.start + ", isyms=" + Arrays.toString(this.isyms) + ", osyms=" + Arrays.toString(this.osyms) + ", semiring=" + this.semiring + ")\n");
        for (ImmutableState s : this.states) {
            sb.append("  " + s + "\n");
            int numArcs = ((State)s).getNumArcs();
            for (int j = 0; j < numArcs; ++j) {
                Arc a = ((State)s).getArc(j);
                sb.append("    " + a + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableFst other = (ImmutableFst)obj;
        if (!Arrays.equals(this.states, other.states)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.states) + super.hashCode();
    }
}

