/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;

public class Fst {
    private ArrayList<State> states = null;
    protected State start;
    protected String[] isyms;
    protected String[] osyms;
    protected Semiring semiring;

    public Fst() {
        this.states = new ArrayList();
    }

    public Fst(int numStates) {
        if (numStates > 0) {
            this.states = new ArrayList(numStates);
        }
    }

    public Fst(Semiring s) {
        this();
        this.semiring = s;
    }

    public State getStart() {
        return this.start;
    }

    public Semiring getSemiring() {
        return this.semiring;
    }

    public void setSemiring(Semiring semiring) {
        this.semiring = semiring;
    }

    public void setStart(State start) {
        this.start = start;
    }

    public int getNumStates() {
        return this.states.size();
    }

    public State getState(int index) {
        return this.states.get(index);
    }

    public void addState(State state) {
        this.states.add(state);
        state.id = this.states.size() - 1;
    }

    public String[] getIsyms() {
        return this.isyms;
    }

    public void setIsyms(String[] isyms) {
        this.isyms = isyms;
    }

    public String[] getOsyms() {
        return this.osyms;
    }

    public void setOsyms(String[] osyms) {
        this.osyms = osyms;
    }

    private void writeStringMap(ObjectOutputStream out, String[] map) throws IOException {
        out.writeInt(map.length);
        for (int i = 0; i < map.length; ++i) {
            out.writeObject(map[i]);
        }
    }

    private void writeFst(ObjectOutputStream out) throws IOException {
        this.writeStringMap(out, this.isyms);
        this.writeStringMap(out, this.osyms);
        out.writeInt(this.states.indexOf(this.start));
        out.writeObject(this.semiring);
        out.writeInt(this.states.size());
        HashMap<State, Integer> stateMap = new HashMap<State, Integer>(this.states.size(), 1.0f);
        for (int i = 0; i < this.states.size(); ++i) {
            State s = this.states.get(i);
            out.writeInt(s.getNumArcs());
            out.writeFloat(s.getFinalWeight());
            out.writeInt(s.getId());
            stateMap.put(s, i);
        }
        int numStates = this.states.size();
        for (int i = 0; i < numStates; ++i) {
            State s = this.states.get(i);
            int numArcs = s.getNumArcs();
            for (int j = 0; j < numArcs; ++j) {
                Arc a = s.getArc(j);
                out.writeInt(a.getIlabel());
                out.writeInt(a.getOlabel());
                out.writeFloat(a.getWeight());
                out.writeInt((Integer)stateMap.get(a.getNextState()));
            }
        }
    }

    public void saveModel(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        this.writeFst(oos);
        oos.flush();
        oos.close();
        bos.close();
        fos.close();
    }

    protected static String[] readStringMap(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int mapSize = in.readInt();
        String[] map = new String[mapSize];
        for (int i = 0; i < mapSize; ++i) {
            String sym;
            map[i] = sym = (String)in.readObject();
        }
        return map;
    }

    private static Fst readFst(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int i;
        String[] is = Fst.readStringMap(in);
        String[] os = Fst.readStringMap(in);
        int startid = in.readInt();
        Semiring semiring = (Semiring)in.readObject();
        int numStates = in.readInt();
        Fst res = new Fst(numStates);
        res.isyms = is;
        res.osyms = os;
        res.semiring = semiring;
        for (i = 0; i < numStates; ++i) {
            int numArcs = in.readInt();
            State s = new State(numArcs + 1);
            float f = in.readFloat();
            if (f == res.semiring.zero()) {
                f = res.semiring.zero();
            } else if (f == res.semiring.one()) {
                f = res.semiring.one();
            }
            s.setFinalWeight(f);
            s.id = in.readInt();
            res.states.add(s);
        }
        res.setStart(res.states.get(startid));
        numStates = res.getNumStates();
        for (i = 0; i < numStates; ++i) {
            State s1 = res.getState(i);
            for (int j = 0; j < s1.initialNumArcs - 1; ++j) {
                Arc a = new Arc();
                a.setIlabel(in.readInt());
                a.setOlabel(in.readInt());
                a.setWeight(in.readFloat());
                a.setNextState(res.states.get(in.readInt()));
                s1.addArc(a);
            }
        }
        return res;
    }

    public static Fst loadModel(String filename) throws IOException, ClassNotFoundException {
        long starttime = Calendar.getInstance().getTimeInMillis();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        fis = new FileInputStream(filename);
        bis = new BufferedInputStream(fis);
        ois = new ObjectInputStream(bis);
        Fst obj = Fst.readFst(ois);
        ois.close();
        bis.close();
        fis.close();
        System.err.println("Load Time: " + (double)(Calendar.getInstance().getTimeInMillis() - starttime) / 1000.0);
        return obj;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fst other = (Fst)obj;
        if (!Arrays.equals(this.isyms, other.isyms)) {
            return false;
        }
        if (!Arrays.equals(this.osyms, other.osyms)) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        if (this.states == null ? other.states != null : !this.states.equals(other.states)) {
            return false;
        }
        return !(this.semiring == null ? other.semiring != null : !this.semiring.equals(other.semiring));
    }

    public int hashCode() {
        return 31 * (Arrays.hashCode(this.isyms) + 31 * (Arrays.hashCode(this.osyms) + 31 * ((this.start == null ? 0 : this.start.hashCode()) + 31 * ((this.states == null ? 0 : this.states.hashCode()) + 31 * (this.semiring == null ? 0 : this.semiring.hashCode())))));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fst(start=" + this.start + ", isyms=" + Arrays.toString(this.isyms) + ", osyms=" + Arrays.toString(this.osyms) + ", semiring=" + this.semiring + ")\n");
        int numStates = this.states.size();
        for (int i = 0; i < numStates; ++i) {
            State s = this.states.get(i);
            sb.append("  " + s + "\n");
            int numArcs = s.getNumArcs();
            for (int j = 0; j < numArcs; ++j) {
                Arc a = s.getArc(j);
                sb.append("    " + a + "\n");
            }
        }
        return sb.toString();
    }

    public void deleteState(State state) {
        if (state == this.start) {
            System.err.println("Cannot delete start state.");
            return;
        }
        this.states.remove(state);
        for (State s1 : this.states) {
            ArrayList<Arc> newArcs = new ArrayList<Arc>();
            for (int j = 0; j < s1.getNumArcs(); ++j) {
                Arc a = s1.getArc(j);
                if (a.getNextState().equals(state)) continue;
                newArcs.add(a);
            }
            s1.setArcs(newArcs);
        }
    }

    public void remapStateIds() {
        int numStates = this.states.size();
        for (int i = 0; i < numStates; ++i) {
            this.states.get((int)i).id = i;
        }
    }

    public void deleteStates(HashSet<State> toDelete) {
        if (toDelete.contains(this.start)) {
            System.err.println("Cannot delete start state.");
            return;
        }
        ArrayList<State> newStates = new ArrayList<State>();
        for (State s1 : this.states) {
            if (toDelete.contains(s1)) continue;
            newStates.add(s1);
            ArrayList<Arc> newArcs = new ArrayList<Arc>();
            for (int j = 0; j < s1.getNumArcs(); ++j) {
                Arc a = s1.getArc(j);
                if (toDelete.contains(a.getNextState())) continue;
                newArcs.add(a);
            }
            s1.setArcs(newArcs);
        }
        this.states = newStates;
        this.remapStateIds();
    }
}

