/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import edu.cmu.sphinx.fst.utils.Utils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;

public class Convert {
    private Convert() {
    }

    public static void export(Fst fst, String basename) throws IOException {
        Convert.exportSymbols(fst.getIsyms(), basename + ".input.syms");
        Convert.exportSymbols(fst.getOsyms(), basename + ".output.syms");
        Convert.exportFst(fst, basename + ".fst.txt");
    }

    private static void exportFst(Fst fst, String filename) throws IOException {
        FileWriter file = new FileWriter(filename);
        PrintWriter out = new PrintWriter(file);
        State start = fst.getStart();
        out.println(start.getId() + "\t" + start.getFinalWeight());
        int numStates = fst.getNumStates();
        for (int i = 0; i < numStates; ++i) {
            State s = fst.getState(i);
            if (s.getId() == fst.getStart().getId()) continue;
            out.println(s.getId() + "\t" + s.getFinalWeight());
        }
        String[] isyms = fst.getIsyms();
        String[] osyms = fst.getOsyms();
        numStates = fst.getNumStates();
        for (int i = 0; i < numStates; ++i) {
            State s = fst.getState(i);
            int numArcs = s.getNumArcs();
            for (int j = 0; j < numArcs; ++j) {
                Arc arc = s.getArc(j);
                String isym = isyms != null ? isyms[arc.getIlabel()] : Integer.toString(arc.getIlabel());
                String osym = osyms != null ? osyms[arc.getOlabel()] : Integer.toString(arc.getOlabel());
                out.println(s.getId() + "\t" + arc.getNextState().getId() + "\t" + isym + "\t" + osym + "\t" + arc.getWeight());
            }
        }
        out.close();
    }

    private static void exportSymbols(String[] syms, String filename) throws IOException {
        if (syms == null) {
            return;
        }
        FileWriter file = new FileWriter(filename);
        PrintWriter out = new PrintWriter(file);
        for (int i = 0; i < syms.length; ++i) {
            String key = syms[i];
            out.println(key + "\t" + i);
        }
        out.close();
    }

    private static HashMap<String, Integer> importSymbols(String filename) throws NumberFormatException, IOException {
        String strLine;
        File symfile = new File(filename);
        if (!symfile.exists() || !symfile.isFile()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(filename);
        DataInputStream dis = new DataInputStream(fis);
        BufferedReader br = new BufferedReader(new InputStreamReader(dis));
        HashMap<String, Integer> syms = new HashMap<String, Integer>();
        while ((strLine = br.readLine()) != null) {
            String[] tokens = strLine.split("\\t");
            String sym = tokens[0];
            Integer index = Integer.parseInt(tokens[1]);
            syms.put(sym, index);
        }
        br.close();
        return syms;
    }

    public static Fst importFst(String basename, Semiring semiring) throws NumberFormatException, IOException {
        String strLine;
        HashMap<String, Integer> osyms;
        Fst fst = new Fst(semiring);
        HashMap<String, Integer> isyms = Convert.importSymbols(basename + ".input.syms");
        if (isyms == null) {
            isyms = new HashMap();
            isyms.put("<eps>", 0);
        }
        if ((osyms = Convert.importSymbols(basename + ".output.syms")) == null) {
            osyms = new HashMap();
            osyms.put("<eps>", 0);
        }
        HashMap<String, Integer> ssyms = Convert.importSymbols(basename + ".states.syms");
        FileInputStream fis = new FileInputStream(basename + ".fst.txt");
        DataInputStream dis = new DataInputStream(fis);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)dis, "UTF-8"));
        boolean firstLine = true;
        HashMap<Integer, State> stateMap = new HashMap<Integer, State>();
        while ((strLine = br.readLine()) != null) {
            String[] tokens = strLine.split("\\t");
            Integer inputStateId = ssyms == null ? Integer.valueOf(Integer.parseInt(tokens[0])) : ssyms.get(tokens[0]);
            State inputState = (State)stateMap.get(inputStateId);
            if (inputState == null) {
                inputState = new State(semiring.zero());
                fst.addState(inputState);
                stateMap.put(inputStateId, inputState);
            }
            if (firstLine) {
                firstLine = false;
                fst.setStart(inputState);
            }
            if (tokens.length > 2) {
                Integer nextStateId = ssyms == null ? Integer.valueOf(Integer.parseInt(tokens[1])) : ssyms.get(tokens[1]);
                State nextState = (State)stateMap.get(nextStateId);
                if (nextState == null) {
                    nextState = new State(semiring.zero());
                    fst.addState(nextState);
                    stateMap.put(nextStateId, nextState);
                }
                if (isyms.get(tokens[2]) == null) {
                    isyms.put(tokens[2], isyms.size());
                }
                int iLabel = isyms.get(tokens[2]);
                if (osyms.get(tokens[3]) == null) {
                    osyms.put(tokens[3], osyms.size());
                }
                int oLabel = osyms.get(tokens[3]);
                float arcWeight = tokens.length > 4 ? Float.parseFloat(tokens[4]) : 0.0f;
                Arc arc = new Arc(iLabel, oLabel, arcWeight, nextState);
                inputState.addArc(arc);
                continue;
            }
            if (tokens.length > 1) {
                float finalWeight = Float.parseFloat(tokens[1]);
                inputState.setFinalWeight(finalWeight);
                continue;
            }
            inputState.setFinalWeight(0.0f);
        }
        dis.close();
        fst.setIsyms(Utils.toStringArray(isyms));
        fst.setOsyms(Utils.toStringArray(osyms));
        return fst;
    }
}

