/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;

public class VUMeter {
    private double rms;
    private double average;
    private double peak;
    private static final double log10 = Math.log(10.0);
    private static final double maxDB = Math.max(0.0, 20.0 * Math.log(32767.0) / log10);
    private final int peakHoldTime = 1000;
    private long then = System.currentTimeMillis();
    private final float a2 = -1.9556f;
    private final float a3 = 0.9565f;
    private final float b1 = 0.978f;
    private final float b2 = -1.9561f;
    private final float b3 = 0.978f;

    public final synchronized double getRmsDB() {
        return Math.max(0.0, 20.0 * Math.log(this.rms) / log10);
    }

    public final synchronized double getAverageDB() {
        return Math.max(0.0, 20.0 * Math.log(this.average) / log10);
    }

    public final synchronized double getPeakDB() {
        return Math.max(0.0, 20.0 * Math.log(this.peak) / log10);
    }

    public final synchronized boolean getIsClipping() {
        return 32767.0 < 2.0 * this.peak;
    }

    public final synchronized double getMaxDB() {
        return maxDB;
    }

    public void calculateVULevels(Data data) {
        if (data instanceof DoubleData) {
            double[] samples = ((DoubleData)data).getValues();
            this.calculateVULevels(samples);
        }
    }

    public void calculateVULevels(byte[] data, int offset, int cnt) {
        short[] samples = new short[cnt / 2];
        for (int i = 0; i < cnt / 2; ++i) {
            int o = offset + 2 * i;
            samples[i] = (short)(data[o] << 8 | 0xFF & data[o + 1]);
        }
        this.calculateVULevels(samples);
    }

    private synchronized void calculateVULevels(double[] samples) {
        double energy = 0.0;
        this.average = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        for (int i = 0; i < samples.length; ++i) {
            double i1 = samples[i];
            double j = 0.0;
            double k = 0.0;
            if (i > 0) {
                j = samples[i - 1];
            }
            if (i > 1) {
                k = samples[i - 2];
            }
            double y = (double)0.978f * i1 + (double)-1.9561f * j + (double)0.978f * k - (double)-1.9556f * y1 - (double)0.9565f * y2;
            y2 = y1;
            y1 = y;
            double v2 = Math.abs(y);
            long now = System.currentTimeMillis();
            energy += v2 * v2;
            this.average += v2;
            if (v2 > this.peak) {
                this.peak = v2;
                continue;
            }
            if (now - this.then <= 1000L) continue;
            this.peak = v2;
            this.then = now;
        }
        this.rms = energy / (double)samples.length;
        this.rms = Math.sqrt(this.rms);
        this.average /= (double)samples.length;
    }

    private synchronized void calculateVULevels(short[] samples) {
        double energy = 0.0;
        this.average = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        for (int i = 0; i < samples.length; ++i) {
            short i1 = samples[i];
            double j = 0.0;
            double k = 0.0;
            if (i > 0) {
                j = samples[i - 1];
            }
            if (i > 1) {
                k = samples[i - 2];
            }
            double y = (double)(0.978f * (float)i1) + (double)-1.9561f * j + (double)0.978f * k - (double)-1.9556f * y1 - (double)0.9565f * y2;
            y2 = y1;
            y1 = y;
            double v2 = Math.abs(y);
            long now = System.currentTimeMillis();
            energy += v2 * v2;
            this.average += v2;
            if (v2 > this.peak) {
                this.peak = v2;
                continue;
            }
            if (now - this.then <= 1000L) continue;
            this.peak = v2;
            this.then = now;
        }
        this.rms = energy / (double)samples.length;
        this.rms = Math.sqrt(this.rms);
        this.average /= (double)samples.length;
    }
}

