/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class Utterance {
    private final String name;
    private final ByteArrayOutputStream audioBuffer;
    private final AudioFormat audioFormat;

    public Utterance(String name, AudioFormat format) {
        this.name = name;
        this.audioFormat = format;
        this.audioBuffer = new ByteArrayOutputStream();
    }

    public String getName() {
        return this.name;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte[] audio) {
        ByteArrayOutputStream byteArrayOutputStream = this.audioBuffer;
        synchronized (byteArrayOutputStream) {
            this.audioBuffer.write(audio, 0, audio.length);
        }
    }

    public byte[] getAudio() {
        return this.audioBuffer.toByteArray();
    }

    public float getAudioTime() {
        return (float)this.audioBuffer.size() / (this.audioFormat.getSampleRate() * (float)this.audioFormat.getSampleSizeInBits() / 8.0f);
    }

    public void save(String fileName, AudioFileFormat.Type fileFormat) throws IOException {
        File file = new File(fileName);
        byte[] audio = this.getAudio();
        AudioInputStream ais = new AudioInputStream(new ByteArrayInputStream(audio), this.getAudioFormat(), audio.length);
        AudioSystem.write(ais, fileFormat, file);
    }
}

