/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.Utilities;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class DataUtil {
    private static final int HEXADECIMAL = 1;
    private static final int SCIENTIFIC = 2;
    private static final int DECIMAL = 3;
    private static final DecimalFormat format = new DecimalFormat();
    private static final int decimalIntegerDigits = 10;
    private static final int decimalFractionDigits = 5;
    private static final int floatScientificFractionDigits = 8;
    private static final int doubleScientificFractionDigits = 8;
    private static int dumpFormat = 2;

    private DataUtil() {
    }

    public static short[] byteToShortArray(byte[] byteArray, int offset, int length) throws ArrayIndexOutOfBoundsException {
        if (0 < length && offset + length <= byteArray.length) {
            int shortLength = length / 2;
            short[] shortArray = new short[shortLength];
            int i = offset;
            for (int j = 0; j < shortLength; ++j) {
                int temp = byteArray[i++] << 8;
                shortArray[j] = (short)(temp |= 0xFF & byteArray[i++]);
                temp = 0;
            }
            return shortArray;
        }
        throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", array length: " + byteArray.length);
    }

    public static double[] bytesToValues(byte[] byteArray, int offset, int length, int bytesPerValue, boolean signedData) throws ArrayIndexOutOfBoundsException {
        if (0 < length && offset + length <= byteArray.length) {
            assert (length % bytesPerValue == 0);
            double[] doubleArray = new double[length / bytesPerValue];
            int i = offset;
            for (int j = 0; j < doubleArray.length; ++j) {
                int val = byteArray[i++];
                if (!signedData) {
                    val &= 0xFF;
                }
                for (int c = 1; c < bytesPerValue; ++c) {
                    int temp = byteArray[i++] & 0xFF;
                    val = (val << 8) + temp;
                }
                doubleArray[j] = val;
            }
            return doubleArray;
        }
        throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", array length: " + byteArray.length);
    }

    public static double[] littleEndianBytesToValues(byte[] data, int offset, int length, int bytesPerValue, boolean signedData) throws ArrayIndexOutOfBoundsException {
        if (0 < length && offset + length <= data.length) {
            assert (length % bytesPerValue == 0);
            double[] doubleArray = new double[length / bytesPerValue];
            int i = offset + bytesPerValue - 1;
            for (int j = 0; j < doubleArray.length; ++j) {
                int val = data[i--];
                if (!signedData) {
                    val &= 0xFF;
                }
                for (int c = 1; c < bytesPerValue; ++c) {
                    int temp = data[i--] & 0xFF;
                    val = (val << 8) + temp;
                }
                i += bytesPerValue * 2;
                doubleArray[j] = val;
            }
            return doubleArray;
        }
        throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", array length: " + data.length);
    }

    public static short bytesToShort(byte[] byteArray, int offset) throws ArrayIndexOutOfBoundsException {
        short result = (short)(byteArray[offset++] << 8 | 0xFF & byteArray[offset]);
        return result;
    }

    public static String shortArrayToString(short[] data) {
        StringBuilder dump = new StringBuilder().append(data.length);
        for (short val : data) {
            dump.append(' ').append(val);
        }
        return dump.toString();
    }

    public static String doubleArrayToString(double[] data) {
        return DataUtil.doubleArrayToString(data, dumpFormat);
    }

    private static String doubleArrayToString(double[] data, int format) {
        StringBuilder dump = new StringBuilder().append(data.length);
        for (double val : data) {
            if (format == 3) {
                dump.append(' ').append(DataUtil.formatDouble(val, 10, 5));
                continue;
            }
            if (format == 1) {
                long binary = Double.doubleToRawLongBits(val);
                dump.append(" 0x").append(Long.toHexString(binary));
                continue;
            }
            if (format != 2) continue;
            dump.append(' ').append(Utilities.doubleToScientificString(val, 8));
        }
        return dump.toString();
    }

    public static String floatArrayToString(float[] data) {
        return DataUtil.floatArrayToString(data, dumpFormat);
    }

    private static String floatArrayToString(float[] data, int format) {
        StringBuilder dump = new StringBuilder().append(data.length);
        for (float val : data) {
            if (format == 3) {
                dump.append(' ').append(DataUtil.formatDouble(val, 10, 5));
                continue;
            }
            if (format == 1) {
                int binary = Float.floatToRawIntBits(val);
                dump.append(" 0x").append(Integer.toHexString(binary));
                continue;
            }
            if (format != 2) continue;
            dump.append(' ').append(Utilities.doubleToScientificString(val, 8));
        }
        return dump.toString();
    }

    public static String formatDouble(double number, int integerDigits, int fractionDigits) {
        StringBuilder formatter = new StringBuilder(2 + fractionDigits).append("0.");
        for (int i = 0; i < fractionDigits; ++i) {
            formatter.append('0');
        }
        format.applyPattern(formatter.toString());
        String formatted = format.format(number);
        int dotIndex = formatted.indexOf(46);
        if (dotIndex == -1) {
            formatted = formatted + ".";
            dotIndex = formatted.length() - 1;
        }
        StringBuilder result = new StringBuilder();
        for (int i = dotIndex; i < integerDigits; ++i) {
            result.append(' ');
        }
        result.append(formatted);
        return result.toString();
    }

    public static int getSamplesPerWindow(int sampleRate, float windowSizeInMs) {
        return (int)((float)sampleRate * windowSizeInMs / 1000.0f);
    }

    public static int getSamplesPerShift(int sampleRate, float windowShiftInMs) {
        return (int)((float)sampleRate * windowShiftInMs / 1000.0f);
    }

    public static void bytesToFile(byte[] data, String filename) throws IOException {
        FileOutputStream file = new FileOutputStream(filename);
        file.write(data);
        file.close();
    }

    public static AudioFormat getNativeAudioFormat(AudioFormat format) {
        return DataUtil.getNativeAudioFormat(format, null);
    }

    public static AudioFormat getNativeAudioFormat(AudioFormat format, Mixer mixer) {
        Line.Info[] lineInfos = mixer != null ? mixer.getTargetLineInfo(new Line.Info(TargetDataLine.class)) : AudioSystem.getTargetLineInfo(new Line.Info(TargetDataLine.class));
        AudioFormat nativeFormat = null;
        for (Line.Info info : lineInfos) {
            AudioFormat[] formats;
            for (AudioFormat thisFormat : formats = ((DataLine.Info)info).getFormats()) {
                if (thisFormat.getEncoding() != format.getEncoding() || thisFormat.isBigEndian() != format.isBigEndian() || thisFormat.getSampleSizeInBits() != format.getSampleSizeInBits() || !(thisFormat.getSampleRate() >= format.getSampleRate())) continue;
                nativeFormat = thisFormat;
                break;
            }
            if (nativeFormat != null) break;
        }
        return nativeFormat;
    }

    public static DoubleData FloatData2DoubleData(FloatData data) {
        int numSamples = data.getValues().length;
        double[] doubleData = new double[numSamples];
        float[] values = data.getValues();
        for (int i = 0; i < values.length; ++i) {
            doubleData[i] = values[i];
        }
        return new DoubleData(doubleData, data.getSampleRate(), data.getFirstSampleNumber());
    }

    public static FloatData DoubleData2FloatData(DoubleData data) {
        int numSamples = data.getValues().length;
        float[] floatData = new float[numSamples];
        double[] values = data.getValues();
        for (int i = 0; i < values.length; ++i) {
            floatData[i] = (float)values[i];
        }
        return new FloatData(floatData, data.getSampleRate(), data.getFirstSampleNumber());
    }

    static {
        String formatProperty = System.getProperty("frontend.util.dumpformat", "SCIENTIFIC");
        if (formatProperty.compareToIgnoreCase("DECIMAL") == 0) {
            dumpFormat = 3;
        } else if (formatProperty.compareToIgnoreCase("HEXADECIMAL") == 0) {
            dumpFormat = 1;
        } else if (formatProperty.compareToIgnoreCase("SCIENTIFIC") == 0) {
            dumpFormat = 2;
        }
    }
}

