/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.transform;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;

public class Lifter
extends BaseDataProcessor {
    @S4Integer(defaultValue=22)
    public static final String PROP_LIFTER_VALUE = "lifterValue";
    protected int lifterValue;
    protected int cepstrumSize;
    protected double[] lifterWeights;

    public Lifter(int lifterValue) {
        this.initLogger();
        this.lifterValue = lifterValue;
    }

    public Lifter() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.lifterValue = ps.getInt(PROP_LIFTER_VALUE);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data != null && data instanceof DoubleData) {
            this.liftCepstrum((DoubleData)data);
        }
        return data;
    }

    private void liftCepstrum(DoubleData input) throws IllegalArgumentException {
        double[] melCepstrum = input.getValues();
        if (this.lifterWeights == null) {
            this.cepstrumSize = melCepstrum.length;
            this.computeLifterWeights();
        } else if (melCepstrum.length != this.cepstrumSize) {
            throw new IllegalArgumentException("MelCepstrum size is incorrect: melcepstrum.length == " + melCepstrum.length + ", cepstrumSize == " + this.cepstrumSize);
        }
        for (int i = 0; i < melCepstrum.length; ++i) {
            melCepstrum[i] = melCepstrum[i] * this.lifterWeights[i];
        }
    }

    private void computeLifterWeights() {
        this.lifterWeights = new double[this.cepstrumSize];
        for (int i = 0; i < this.cepstrumSize; ++i) {
            this.lifterWeights[i] = 1.0 + (double)(this.lifterValue / 2) * Math.sin((double)i * Math.PI / (double)this.lifterValue);
        }
    }
}

